<?php
if(session_status()===PHP_SESSION_NONE) session_start();
ob_start();
error_reporting(0);
date_default_timezone_set("Asia/Yangon");

/* ===== CONFIG ===== */
define("ADMIN_KEY","AutoBot2025"); 
define("TOKEN_FILE",__DIR__."/token.json");
$tk_data = @json_decode(@file_get_contents(TOKEN_FILE), true);
define("BOT_TOKEN", $tk_data["token"] ?? "8220682200:AAGe0fVOj9MzPGkrBdu0_Y8fVzJ54eimGxw");


define("UFILE",__DIR__."/data/users.json");
define("HFILE",__DIR__."/data/history.json");

define("ML_FILE",__DIR__."/prices.json");
define("PUBG_UC_FILE",__DIR__."/pubg_prices.json");
define("PUBG_CODE_FILE",__DIR__."/pubg_code_prices.json");

define("COOKIES_FILE",__DIR__."/cookies.json");
define("BACKUP_COK_DIR",__DIR__."/BackupCok");

define("SMILE_FILE",__DIR__."/smile.php");
define("BACKUP_SMILE_DIR",__DIR__."/BackupSmile");

define("BOT_FILE",__DIR__."/bot.php");          // ✅ admin will replace this
define("BACKUP_DIR",__DIR__."/backup");         // ✅ backups here

define("MAX_IMG_MB",10);
define("MAX_PHP_MB",2);                         // bot.php max upload size
define("BC_DELAY_MS",80);

/* ===== BASIC ===== */
function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,"UTF-8"); }
function jr($f){
  if(!file_exists($f)) return [];
  $j=@json_decode(@file_get_contents($f),true);
  return is_array($j)?$j:[];
}
function jw($f,$d){
  @mkdir(dirname($f),0777,true);
  $tmp=$f.".tmp";
  @file_put_contents($tmp,json_encode($d,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE),LOCK_EX);
  @rename($tmp,$f);
}
function read_text($f,$fallback="[]"){
  if(!file_exists($f)) return $fallback;
  $t=trim((string)@file_get_contents($f));
  return ($t==="")?$fallback:$t;
}
function write_text_atomic($f,$txt){
  @mkdir(dirname($f),0777,true);
  $tmp=$f.".tmp";
  @file_put_contents($tmp,$txt,LOCK_EX);
  @rename($tmp,$f);
  return true;
}

function auth(){
  $k=$_GET["key"]??$_POST["key"]??"";
  if($k!==ADMIN_KEY){ header("Content-Type:text/html; charset=utf-8"); exit("Unauthorized. Use ?key=ADMIN_KEY"); }
  return $k;
}

/* ===== Telegram ===== */
function tg_api($method,$data,$multipart=false){
  $url="https://api.telegram.org/bot".BOT_TOKEN."/".$method;
  $ch=curl_init($url);
  curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>1,CURLOPT_POST=>1,CURLOPT_POSTFIELDS=>$data,CURLOPT_TIMEOUT=>35,CURLOPT_CONNECTTIMEOUT=>10]);
  if($multipart) curl_setopt($ch,CURLOPT_HTTPHEADER,["Expect:"]);
  $res=curl_exec($ch); $err=curl_error($ch); curl_close($ch);
  if($res===false||$res==="") return ["ok"=>0,"description"=>$err?: "empty_response"];
  $j=@json_decode($res,true);
  return is_array($j)?$j:["ok"=>0,"description"=>"bad_json","raw"=>$res];
}
function tg_text($cid,$text){
  $text=trim((string)$text); if($text==="") $text=" ";
  return tg_api("sendMessage",["chat_id"=>$cid,"text"=>$text,"parse_mode"=>"HTML","disable_web_page_preview"=>true],false);
}
function tg_photo_file($cid,$filePath,$caption=""){
  $caption=trim((string)$caption);
  if(mb_strlen($caption)>1024) $caption=mb_substr($caption,0,1020)."...";
  $mime=function_exists("mime_content_type")?@mime_content_type($filePath):"image/jpeg"; if(!$mime) $mime="image/jpeg";
  $cf=new CURLFile($filePath,$mime,basename($filePath));
  return tg_api("sendPhoto",["chat_id"=>$cid,"photo"=>$cf,"caption"=>$caption,"parse_mode"=>"HTML"],true);
}
function dl_tmp($url,&$e=null){
  $e=null; $url=trim((string)$url);
  if($url===""){ $e="empty_url"; return null; }
  $tmp=tempnam(sys_get_temp_dir(),"adm_"); if(!$tmp){ $e="tmp_fail"; return null; }
  $fp=@fopen($tmp,"w"); if(!$fp){ @unlink($tmp); $e="fp_fail"; return null; }
  $ch=curl_init($url);
  curl_setopt_array($ch,[CURLOPT_FILE=>$fp,CURLOPT_FOLLOWLOCATION=>1,CURLOPT_TIMEOUT=>25,CURLOPT_CONNECTTIMEOUT=>10,
    CURLOPT_USERAGENT=>"Mozilla/5.0",CURLOPT_SSL_VERIFYPEER=>0,CURLOPT_SSL_VERIFYHOST=>0]);
  $ok=curl_exec($ch); $cerr=curl_error($ch); $code=curl_getinfo($ch,CURLINFO_HTTP_CODE); curl_close($ch); fclose($fp);
  $sz=@filesize($tmp);
  if(!$ok||$code<200||$code>=300||$sz<200){ @unlink($tmp); $e="download_fail code=$code err=$cerr"; return null; }
  if($sz>MAX_IMG_MB*1024*1024){ @unlink($tmp); $e="file_too_large"; return null; }
  return $tmp;
}
function tg_send_any($cid,$text,$imgUrl="",$imgFileTmp=null){
  if($imgFileTmp && file_exists($imgFileTmp)) return tg_photo_file($cid,$imgFileTmp,$text);
  $imgUrl=trim((string)$imgUrl);
  if($imgUrl!==""){
    $e=null; $tmp=dl_tmp($imgUrl,$e); if(!$tmp) return ["ok"=>0,"description"=>"img_download_failed: ".$e];
    $r=tg_photo_file($cid,$tmp,$text); @unlink($tmp); return $r;
  }
  return tg_text($cid,$text);
}
function ks($n){ return number_format((int)round((float)$n))." MMK"; }

/* ===== BOT.PHP MANAGER ===== */
function ensure_backup_dir(){ @mkdir(BACKUP_DIR,0777,true); }
function backup_file($path){
  if(!file_exists($path)) return null;
  ensure_backup_dir();
  $bn=basename($path);
  $dst=BACKUP_DIR."/".$bn.".".date("Ymd_His").".bak";
  @copy($path,$dst);
  return $dst;
}
function looks_like_php($txt){
  $t=ltrim((string)$txt);
  return (stripos($t,"<?php")!==false); // simple check
}

/* ===== DOWNLOAD HISTORY (TXT) ===== */
if(isset($_GET['download_history'])){
  $h = jr(HFILE);
  $u = jr(UFILE);
  
  $rows = [];
  foreach($h as $cid=>$list){
    if(!is_array($list)) continue;
    foreach($list as $r){
      $r["cid"] = $cid;
      // Pre-calc user info
      $r["uName"] = $u[$cid]["name"] ?? ($u[$cid]["username"] ? "@".$u[$cid]["username"] : $cid);
      $rows[] = $r;
    }
  }

  // Sort descending by time
  usort($rows, function($a, $b){
     $t1 = DateTime::createFromFormat("H:i d.m.Y", $a["time"]??'');
     $t2 = DateTime::createFromFormat("H:i d.m.Y", $b["time"]??'');
     if(!$t1) return 1; if(!$t2) return -1;
     return $t2 <=> $t1;
  });

  // Prepare output
  header('Content-Type: text/plain; charset=utf-8');
  header('Content-Disposition: attachment; filename="history_'.date('Y-m-d_H-i').'.txt"');
  
  // Header
  echo sprintf("%-18s | %-10s | %-12s | %-20s | %-25s | %-12s | %s\n", 
               "Time", "Status", "CID", "User", "Item", "Amount", "Info");
  echo str_repeat("-", 130) . "\n";

  foreach($rows as $r){
    $st = $r["status"] ?? "success";
    $isFail = ($st === "fail");
    $info = $isFail ? ($r["error"]??"") : ($r["sn"]??"");
    $item = $r["order"] ?? ($r["item"] ?? "-");
    $amt = number_format($r["amount"]??0);
    
    // Clean strings for text file (remove newlines/pipes)
    $cleanUser = str_replace(['|',"\n","\r"], '', $r["uName"]);
    $cleanItem = str_replace(['|',"\n","\r"], '', $item);
    $cleanInfo = str_replace(['|',"\n","\r"], ' ', $info);
    
    echo sprintf("%-18s | %-10s | %-12s | %-20s | %-25s | %-12s | %s\n",
      $r["time"]??"-",
      strtoupper($st),
      $r["cid"],
      mb_strimwidth($cleanUser, 0, 20, "..."),
      mb_strimwidth($cleanItem, 0, 25, "..."),
      $amt,
      $cleanInfo
    );
  }
  exit;
}

/* ===== INIT ===== */

if(isset($_POST["save_token"])){
  $nt = trim($_POST["new_token"]??"");
  if($nt && strlen($nt)>20){
    write_text_atomic(TOKEN_FILE, json_encode(["token"=>$nt]));
    header("Location: ?view=bot"); exit;
  }
}

$users=jr(UFILE); if(!is_array($users)) $users=[];
$hist =jr(HFILE); if(!is_array($hist))  $hist=[];

$view=$_GET["view"]??"dashboard";
$q=trim($_GET["q"]??"");
$msg=""; $err=""; $info="";

/* ===== STATS ===== */
$todayStr = date("d.m.Y");
$stats = [
  "users" => count($users),
  "balance" => 0,
  "orders_total" => 0,
  "sales_total" => 0,
  "orders_today" => 0,
  "sales_today" => 0
];

$allOrders = [];

foreach($users as $u){
  $stats["balance"] += (float)($u["bal"]??0);
}

foreach($hist as $cid=>$orders){
  if(!is_array($orders)) continue;
  foreach($orders as $o){
    $stats["orders_total"]++;
    $amt = (float)($o["amount"]??0);
    $stats["sales_total"] += $amt;
    
    $o["cid"] = $cid;
    $ud = $users[$cid] ?? [];
    $o["u_name"] = $ud["username"] ? "@".$ud["username"] : ($ud["name"] ?? $cid);
    $allOrders[] = $o;
    
    $parts = explode(" ", $o["time"]??'');
    if(isset($parts[1]) && $parts[1]===$todayStr){
        $stats["orders_today"]++;
        $stats["sales_today"] += $amt;
    }
  }
}

usort($allOrders, function($a, $b){
    $t1 = DateTime::createFromFormat("H:i d.m.Y", $a["time"]??'');
    $t2 = DateTime::createFromFormat("H:i d.m.Y", $b["time"]??'');
    if(!$t1) return 1; if(!$t2) return -1;
    return $t2 <=> $t1;
});
$recentOrders = array_slice($allOrders, 0, 10);

/* ===== ACTIONS ===== */

/* Balance + auto notify */
if(isset($_POST["add_bal"])){
  $cid=trim($_POST["cid"]??"");
  $amt=(int)($_POST["amt"]??0);
  if($cid===""||!preg_match("/^\d+$/",$cid)) $err="CID မမှန်ပါ";
  else{
    if(!isset($users[$cid])) $users[$cid]=["bal"=>0,"join"=>date("Y-m-d H:i:s")];
    $old=(int)($users[$cid]["bal"]??0);
    $new=max(0,$old+$amt);
    $users[$cid]["bal"]=$new;
    if(empty($users[$cid]["join"])) $users[$cid]["join"]=date("Y-m-d H:i:s");
    jw(UFILE,$users);

    $deltaTxt=($amt>=0?"+":"").ks(abs($amt));
    $text="💰 <b>Wallet Update</b>\n━━━━━━━━━━━━━━\n🆔 <code>$cid</code>\n➕➖ Change: <b>$deltaTxt</b>\nOld: <b>".ks($old)."</b>\nNew: <b>".ks($new)."</b>\n\n🙏 Thanks!";
    tg_text($cid,$text);

    $msg="Balance Updated ✅ ($cid)";
  }
}

/* Save prices */
if(isset($_POST["save_price"])){
  $file=$_POST["file"]??"";
  $json=trim($_POST["json"]??"");
  $arr=@json_decode($json,true);
  if(!$file) $err="File missing";
  elseif(!is_array($arr)) $err="JSON မမှန်ပါ";
  else{ jw($file,$arr); $msg="Saved ✅"; }
}

/* Notify one */
if(isset($_POST["notify_one"])){
  $cid=trim($_POST["n_cid"]??"");
  $text=trim($_POST["n_text"]??"");
  $imgUrl=trim($_POST["n_img_url"]??"");
  $imgTmp=null;

  if(!empty($_FILES["n_img_file"]["tmp_name"]) && is_uploaded_file($_FILES["n_img_file"]["tmp_name"])){
    $sz=(int)($_FILES["n_img_file"]["size"]??0);
    if($sz>MAX_IMG_MB*1024*1024) $err="Image too large (max ".MAX_IMG_MB."MB)";
    else $imgTmp=$_FILES["n_img_file"]["tmp_name"];
  }
  if(!$err){
    if($cid===""||!preg_match("/^\d+$/",$cid)) $err="CID မမှန်ပါ";
    elseif($text==="" && $imgUrl==="" && !$imgTmp) $err="Message သို့ Photo ထည့်ပါ";
    else{
      $r=tg_send_any($cid,$text,$imgUrl,$imgTmp);
      if(!empty($r["ok"])) $msg="Notify sent ✅ ($cid)";
      else $err="Notify failed ($cid): ".h($r["description"]??"send_failed");
    }
  }
}

/* Broadcast all */
$fails=[];
if(isset($_POST["broadcast_all"])){
  $text=trim($_POST["b_text"]??"");
  $imgUrl=trim($_POST["b_img_url"]??"");
  $delay=(int)($_POST["b_delay"]??BC_DELAY_MS);
  if($delay<0) $delay=0; if($delay>2000) $delay=2000;

  $imgTmp=null; $shared=null;
  if(!empty($_FILES["b_img_file"]["tmp_name"]) && is_uploaded_file($_FILES["b_img_file"]["tmp_name"])){
    $sz=(int)($_FILES["b_img_file"]["size"]??0);
    if($sz>MAX_IMG_MB*1024*1024) $err="Image too large (max ".MAX_IMG_MB."MB)";
    else $imgTmp=$_FILES["b_img_file"]["tmp_name"];
  }

  if(!$err){
    if(!$users) $err="users မရှိသေးပါ";
    elseif($text==="" && $imgUrl==="" && !$imgTmp) $err="Message သို့ Photo ထည့်ပါ";
    else{
      if(!$imgTmp && $imgUrl!==""){ $e=null; $shared=dl_tmp($imgUrl,$e); if(!$shared) $err="Image download failed: ".$e; }
      if(!$err){
        $ok=0;$fail=0;
        foreach(array_keys($users) as $cid){
          if(!preg_match("/^\d+$/",$cid)) continue;
          $useFile=$imgTmp?:$shared;
          $r=tg_send_any($cid,$text,"",$useFile);
          if(!empty($r["ok"])) $ok++;
          else{ $fail++; $fails[]=["cid"=>$cid,"desc"=>$r["description"]??"send_failed"]; }
          usleep($delay*1000);
        }
        if($shared) @unlink($shared);
        $info="Broadcast DONE ✅ | OK:$ok FAIL:$fail TOTAL:".count($users);
      }
    }
  }
}

/* ===== NEW: COOKIES EDITOR ===== */
if(isset($_POST["save_cookies"])){
  $txt = trim($_POST["cookies_text"]??"");
  if($txt===""){
    $err = "Cookies content empty";
  } elseif(json_decode($txt)===null){
    $err = "Invalid JSON format";
  } else {
    // Backup
    if(file_exists(COOKIES_FILE)){
      @mkdir(BACKUP_COK_DIR, 0777, true);
      $bk = BACKUP_COK_DIR . "/cookies_" . date("Ymd_His") . ".json";
      @copy(COOKIES_FILE, $bk);
    }
    // Save
    if(write_text_atomic(COOKIES_FILE, $txt)){
      $msg = "Cookies saved & backed up ✅";
    } else {
      $err = "Failed to save cookies";
    }
  }
}

/* ===== NEW: SMILE.PHP EDITOR ===== */
if(isset($_POST["save_smile"])){
  $txt = trim($_POST["smile_text"]??"");
  if($txt===""){
            $err = "smile.php content empty";
          } elseif(!looks_like_php($txt) && json_decode($txt)===null){
            $err = "Content must be valid PHP (<?php) or JSON";
          } else {
    // Backup
    if(file_exists(SMILE_FILE)){
      @mkdir(BACKUP_SMILE_DIR, 0777, true);
      $bk = BACKUP_SMILE_DIR . "/smile_" . date("Ymd_His") . ".php";
      @copy(SMILE_FILE, $bk);
    }
    // Save
    if(write_text_atomic(SMILE_FILE, $txt)){
      $msg = "smile.php saved & backed up ✅";
    } else {
      $err = "Failed to save smile.php";
    }
  }
}

/* ===== NEW: BOT.PHP UPDATE (Upload / Edit) ===== */
if(isset($_POST["bot_save_text"])){
  $txt=(string)($_POST["bot_text"]??"");
  if(trim($txt)==="") $err="bot.php content empty";
  elseif(!looks_like_php($txt)) $err="PHP code မဟုတ်သလိုပဲ (<?php မတွေ့ဘူး)";
  else{
    backup_file(BOT_FILE);
    write_text_atomic(BOT_FILE,$txt);
    $msg="bot.php saved ✅";
  }
}
if(isset($_POST["bot_upload_file"])){
  if(empty($_FILES["bot_file"]["tmp_name"]) || !is_uploaded_file($_FILES["bot_file"]["tmp_name"])) $err="Upload file မတွေ့ဘူး";
  else{
    $sz=(int)($_FILES["bot_file"]["size"]??0);
    if($sz > MAX_PHP_MB*1024*1024) $err="bot.php too large (max ".MAX_PHP_MB."MB)";
    else{
      $raw=@file_get_contents($_FILES["bot_file"]["tmp_name"]);
      if(!$raw || !looks_like_php($raw)) $err="Upload ဖိုင်က PHP မဟုတ်သလိုပဲ";
      else{
        backup_file(BOT_FILE);
        write_text_atomic(BOT_FILE,$raw);
        $msg="bot.php upload saved ✅";
      }
    }
  }
}

/* ===== LOAD UI TEXT ===== */
$ml = read_text(ML_FILE);
$uc = read_text(PUBG_UC_FILE);
$pc = read_text(PUBG_CODE_FILE);
$cookies_now = read_text(COOKIES_FILE, "[]");
$smile_now = file_exists(SMILE_FILE) ? (string)file_get_contents(SMILE_FILE) : "<?php\n// smile.php not found\n";
$bot_now = file_exists(BOT_FILE) ? (string)file_get_contents(BOT_FILE) : "<?php\n// bot.php not found\n";

$warn=[];
if(!file_exists(ML_FILE))        $warn[]="prices.json (ML) not found";
if(!file_exists(PUBG_UC_FILE))   $warn[]="pubg_prices.json (UC) not found";
if(!file_exists(PUBG_CODE_FILE)) $warn[]="pubg_code_prices.json (CODE) not found";
if(!file_exists(COOKIES_FILE))   $warn[]="cookies.json not found";
if(!file_exists(SMILE_FILE))     $warn[]="smile.php not found";
if(!file_exists(BOT_FILE))       $warn[]="bot.php not found";

$tabs=[
  "dashboard"=>"📊 Dashboard",
  "users"=>"👤 Users",
  "balance"=>"💰 Balance",
  "notify"=>"🔔 Notify",
  "broadcast"=>"📣 Broadcast",
  "prices"=>"🎮 Prices",
  "cookies"=>"🍪 Cookies",
  "smile"=>"<img src='https://www.google.com/s2/favicons?domain=smile.one&sz=32' style='vertical-align:middle;width:20px;margin-right:4px;border-radius:50%'> Smile",
  "bot"=>"🧩 Bot Editor",
  "history"=>"📜 History"
];
?>
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin</title>
<style>
/* SEA BLUE THEME */
@import url('https://fonts.googleapis.com/css2?family=Fredoka:wght@300;400;600&display=swap');

:root{
  --p: #00BCD4;          /* Cyan */
  --p-dim: #0097A7;      /* Darker Cyan */
  --bg: #E0F7FA;         /* Light Cyan Background */
  --panel: #FFFFFF;      /* White */
  --border: #B2EBF2;     /* Cyan Border */
  --text: #006064;       /* Dark Cyan Text */
  --shadow: 0 8px 20px rgba(0, 188, 212, 0.25);
}

*{
  box-sizing:border-box;
  -webkit-tap-highlight-color: transparent; /* Remove mobile tap highlight */
}

body{
  margin:0;
  font-family: 'Fredoka', sans-serif;
  background-color: var(--bg);
  background-image: radial-gradient(#80DEEA 15%, transparent 16%), radial-gradient(#80DEEA 15%, transparent 16%);
  background-size: 40px 40px;
  background-position: 0 0, 20px 20px;
  color: var(--text);
}

a{color:var(--p-dim);text-decoration:none; transition:0.3s; font-weight:600}
a:hover{color:#00838F; text-shadow:0 2px 5px rgba(0,188,212,0.3)}
a:active{transform: scale(0.95);} /* Active click effect for links */

/* Button Touch Effects */
button, .btn, .btn-sm, .page-btn, .tab, .modal-btn, .custom-select-trigger {
  cursor: pointer;
  touch-action: manipulation; /* Faster tap */
  user-select: none;
  transition: transform 0.1s, background 0.2s, box-shadow 0.2s !important;
}

button:active, .btn:active, .btn-sm:active, .page-btn:active, .tab:active, .modal-btn:active, .custom-select-trigger:active {
  transform: scale(0.95) !important;
  box-shadow: 0 2px 10px rgba(0,0,0,0.1) !important;
}

/* Card Touch Effects (Subtle) */
.card, .stat-card, .user-preview {
  transition: transform 0.3s, box-shadow 0.3s;
}
.card:active, .stat-card:active, .user-preview:active {
  transform: scale(0.98);
}

/* Input Focus Effects */
input:focus, textarea:focus, select:focus {
  transform: scale(1.01);
}


.top{
  position:sticky; top:0; z-index:99;
  background: rgba(255, 255, 255, 0.9);
  backdrop-filter: blur(10px);
  border-bottom: 2px solid var(--border);
  padding:15px;
  box-shadow: var(--shadow);
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.brand{display:flex;align-items:center;gap:15px}
.dot{
  width:15px; height:15px; background:var(--p);
  border-radius: 50%;
  box-shadow: 0 0 10px var(--p);
  animation: pulse 2s infinite;
}
@keyframes pulse { 0%{transform:scale(1)} 50%{transform:scale(1.2)} 100%{transform:scale(1)} }

.mini{opacity:.7;font-size:13px; letter-spacing:0.5px}

.wrap{
  max-width: 1200px;
  width: 95%; /* More fluid on smaller screens */
  margin: auto;
  padding: 25px 0; /* Remove side padding to use width */
}

.tabbar{display:flex;flex-wrap:wrap;gap:10px;margin-top:0;}
.tab{
  padding:10px 20px;
  background: #FFF;
  border: 2px solid var(--border);
  color: var(--p-dim);
  border-radius: 50px;
  font-weight: 600;
  transition: 0.3s;
  box-shadow: 0 4px 10px rgba(0,0,0,0.05);
}
.tab:hover{background:#E0F7FA; transform:translateY(-2px)}
.tab.act{
  background: var(--p);
  color: #fff;
  border-color: var(--p);
  box-shadow: 0 5px 15px rgba(0, 188, 212, 0.4);
}

/* Responsive */
@media (max-width: 900px) {
  .menu-btn { display: none !important; } /* Hide 3-line menu */
  
  .tabbar { display: none !important; }
  .mobile-nav-select { display: block !important; }
  
  .row { grid-template-columns: 1fr !important; }
  .stat-grid { grid-template-columns: 1fr 1fr; }
  
  /* Add padding to container to prevent edge cutoff */
  .top { padding-bottom: 5px; flex-wrap: wrap; }
  .brand { width: 100%; margin-bottom: 10px; justify-content: center; }
}


@keyframes fadeInMenu { from { opacity: 0; } to { opacity: 1; } }
@keyframes slideInTab { 
  from { opacity: 0; transform: translateY(20px); } 
  to { opacity: 1; transform: translateY(0); } 
}


@media (max-width: 480px) {
  .stat-grid { grid-template-columns: 1fr; }
}

@keyframes slideDown {
  from { opacity: 0; transform: translateY(-10px); }
  to { opacity: 1; transform: translateY(0); }
}

/* User Preview Card */
.user-preview {
  display: flex;
  align-items: center;
  gap: 15px;
  background: #E0F7FA;
  padding: 15px;
  border-radius: 15px;
  margin-top: 10px;
  border: 1px dashed var(--p);
  animation: fadeIn 0.3s ease;
}
@keyframes fadeIn { from{opacity:0;transform:translateY(5px)} to{opacity:1;transform:translateY(0)} }

.user-preview .avatar {
  min-width: 50px; width: 50px; height: 50px;
  background: var(--p);
  color: #fff;
  border-radius: 50%;
  display: flex; align-items: center; justify-content: center;
  font-size: 24px;
  font-weight: bold;
  box-shadow: 0 4px 10px rgba(0,188,212,0.3);
}
.user-preview .details { display: flex; flex-direction: column; }
.user-preview .name { font-weight: bold; font-size: 16px; color: var(--p-dim); }
.user-preview .sub { font-size: 13px; opacity: 0.8; color: var(--text); }

/* Table Responsive Wrapper */
.table-wrap { 
  overflow-x: auto; 
  -webkit-overflow-scrolling: touch; 
  border-radius: 15px;
}

/* Small Action Buttons */
.btn-sm {
  padding: 6px 14px;
  font-size: 12px;
  border-radius: 20px;
  display: inline-block;
  margin: 2px;
  text-decoration: none !important;
  color: white !important;
  font-weight: bold;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
  transition: 0.2s;
}
.btn-sm:hover { transform: translateY(-2px); box-shadow: 0 5px 10px rgba(0,0,0,0.2); }
.btn-sm.blue { background: #4DB6AC; }
.btn-sm.orange { background: #FFB74D; }

.card{
  background: var(--panel);
  border-radius: 25px;
  padding: 25px;
  margin: 20px 0;
  box-shadow: var(--shadow);
  border: 1px solid white;
}

/* Custom Select */
.custom-select-wrapper {
  position: relative;
  display: block;
  width: 100%;
}
.custom-select-wrapper select {
  width: 100%;
  padding: 12px 15px;
  border-radius: 12px;
  border: 2px solid var(--border);
  background: #fff;
  color: var(--text);
  font-size: 15px;
  font-weight: 600;
  appearance: none;
  cursor: pointer;
  transition: 0.3s;
  outline: none;
}
.custom-select-wrapper::after {
  content: '▼';
  font-size: 12px;
  color: var(--p);
  position: absolute;
  right: 15px;
  top: 50%;
  transform: translateY(-50%);
  pointer-events: none;
}
.custom-select-wrapper select:hover {
  border-color: var(--p);
  box-shadow: 0 4px 10px rgba(0, 188, 212, 0.15);
}

/* Beautiful Modal */
.modal-overlay {
  position: fixed; top: 0; left: 0; width: 100%; height: 100%;
  background: rgba(0,0,0,0.6);
  backdrop-filter: blur(8px);
  z-index: 1000;
  display: none;
  justify-content: center;
  align-items: center;
  opacity: 0;
  transition: opacity 0.3s;
}
.modal-overlay.show { display: flex; opacity: 1; }
.modal-box {
  background: #fff;
  padding: 30px;
  border-radius: 25px;
  width: 90%;
  max-width: 400px;
  text-align: center;
  box-shadow: 0 20px 50px rgba(0,0,0,0.3);
  transform: scale(0.9);
  transition: transform 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
}
.modal-overlay.show .modal-box { transform: scale(1); }
.modal-icon { font-size: 40px; margin-bottom: 15px; animation: pop 0.5s; }
@keyframes pop { 0%{transform:scale(0)} 80%{transform:scale(1.2)} 100%{transform:scale(1)} }
.modal-title { font-size: 22px; font-weight: bold; color: var(--p-dim); margin-bottom: 10px; }
.modal-desc { font-size: 16px; color: #666; margin-bottom: 25px; line-height: 1.6; }
.modal-btns { display: flex; gap: 15px; justify-content: center; }
.modal-btn { flex: 1; padding: 12px; border-radius: 50px; font-weight: bold; cursor: pointer; border: none; transition: 0.2s; font-size: 15px; }
.modal-btn.yes { background: var(--p); color: #fff; box-shadow: 0 4px 15px rgba(0, 188, 212, 0.4); }
.modal-btn.yes:hover { background: var(--p-dim); transform: translateY(-2px); }
.modal-btn.no { background: #f5f5f5; color: #777; }
.modal-btn.no:hover { background: #e0e0e0; }

/* Custom Select with Images */
.mobile-nav-select { display: none; margin-bottom: 20px; }
.custom-select-container { position: relative; width: 100%; font-family: 'Fredoka', sans-serif; user-select: none; }
.custom-select-trigger { background: white; border: 2px solid var(--border); border-radius: 12px; padding: 12px; display: flex; align-items: center; cursor: pointer; transition: all 0.3s; }
.custom-select-trigger:hover { border-color: var(--p); box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
.custom-select-trigger img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; object-fit: cover; border: 1px solid #eee; }
.custom-select-trigger span { font-weight: 600; color: #555; flex-grow: 1; font-size: 15px; }
.custom-select-trigger .arrow { color: #999; font-size: 12px; transition: transform 0.3s; }
.custom-options { position: absolute; top: 115%; left: 0; right: 0; background: white; border: 2px solid var(--border); border-radius: 12px; box-shadow: 0 8px 24px rgba(0,0,0,0.1); opacity: 0; visibility: hidden; transform: translateY(-10px); transition: all 0.3s; z-index: 100; overflow-y: auto; max-height: 60vh; }
.custom-options.open { opacity: 1; visibility: visible; transform: translateY(0); }
.custom-option { padding: 12px; display: flex; align-items: center; cursor: pointer; transition: background 0.2s; border-bottom: 1px solid #f9f9f9; }
.custom-option:last-child { border-bottom: none; }
.custom-option:hover { background: var(--bg); }
.custom-option img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; border: 1px solid #eee; }
.custom-option.selected { background: var(--bg); font-weight: bold; color: var(--p-dim); }
.custom-select-container.active .arrow { transform: rotate(180deg); }

h3{
  margin:0 0 20px 0;
  color: var(--p-dim);
  font-size: 24px; /* Big Head Title */
  border-bottom: 2px dashed var(--border);
  padding-bottom: 10px;
  text-align: center;
}

input,textarea,button,select{
  width:100%; padding:15px;
  background: #FFF;
  border: 2px solid var(--border);
  color: var(--text);
  font-family: inherit;
  font-size: 15px;
  outline: none;
  margin-bottom: 10px;
  border-radius: 15px;
  transition: 0.3s;
}
input:focus,textarea:focus,select:focus{
  border-color: var(--p);
  box-shadow: 0 0 0 4px rgba(0, 188, 212, 0.2);
}

/* Flexible Row for Inputs */
.row {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
}
.row > * {
  flex: 1 1 300px; /* Grow to fill, min-width 300px */
}

.btn {
  background: var(--p);
  color: #fff;
  border: none;
  font-weight: bold;
  cursor: pointer;
  letter-spacing: 1px;
  border-radius: 50px;
  box-shadow: 0 5px 15px rgba(0, 188, 212, 0.4);
}
.btn:hover{
  background: var(--p-dim);
  transform: translateY(-3px);
  box-shadow: 0 8px 20px rgba(0, 151, 167, 0.5);
}

/* Status Colors - Sea Blue Theme */
.ok{border-left: 5px solid #4DB6AC; background: #E0F2F1}
.bad{border-left: 5px solid #E57373; background: #FFEBEE}
.info{border-left: 5px solid #4DD0E1; background: #E0F7FA}

table{width:100%;border-collapse:separate; border-spacing: 0 10px; font-size:15px}
th{text-align:left; color:var(--p-dim); padding:15px; border-bottom:2px solid var(--bg)}
td{padding:15px; background: #FFF; border-top: 1px solid var(--bg); border-bottom: 1px solid var(--bg)}
tr td:first-child{border-top-left-radius: 15px; border-bottom-left-radius: 15px; border-left: 1px solid var(--bg)}
tr td:last-child{border-top-right-radius: 15px; border-bottom-right-radius: 15px; border-right: 1px solid var(--bg)}
tr:hover td{background: #E0F7FA; transform: scale(1.01); transition: 0.2s}

code{
  background: #E0F7FA;
  border: 1px solid #B2EBF2;
  color: #006064;
  padding: 4px 8px;
  font-size: 14px;
  border-radius: 8px;
  font-family: 'Fredoka', sans-serif;
}

.stat-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:15px;margin-bottom:20px}
.stat-card{
  background: var(--panel);
  padding:15px;
  border-radius: 15px;
  box-shadow: var(--shadow);
  position:relative;
  overflow:hidden;
  transition: 0.3s;
  text-align: center;
}
.stat-card:hover{transform: translateY(-3px)}

.stat-val{font-size:24px; color:var(--p-dim); font-weight:bold; margin:5px 0}
.stat-lbl{font-size:12px; color:#888; text-transform:uppercase; letter-spacing:1px}

/* Scrollbar */
::-webkit-scrollbar{width:10px}
::-webkit-scrollbar-track{background:var(--bg)}
::-webkit-scrollbar-thumb{background:var(--border); border-radius:10px}
::-webkit-scrollbar-thumb:hover{background:var(--p)}
</style>
</head>
<body>

<div class="top">
  <script>
    const allUsers = <?=json_encode($users)?>;
    function checkUser(cid, divId){
      const d = document.getElementById(divId);
      if(!d) return;
      if(allUsers[cid]){
        const u = allUsers[cid];
        const n = u.username ? "@"+u.username : (u.name || "Unknown");
        const bal = u.bal || 0;
        const letter = (n.replace('@','').charAt(0) || '?').toUpperCase();
        
        d.innerHTML = `
          <div class="user-preview">
            <div class="avatar">${letter}</div>
            <div class="details">
              <div class="name">${n}</div>
              <div class="sub">CID: <b>${cid}</b> • Bal: <b>${bal} K</b></div>
            </div>
          </div>
        `;
        d.style.display = "block";
      } else {
        d.innerHTML = "";
        d.style.display = "none";
      }
    }
    // Auto run if value exists
    window.addEventListener('load', ()=>{
       let b = document.getElementById('bal_cid'); if(b && b.value) checkUser(b.value, 'bal_info');
       let n = document.getElementById('not_cid'); if(n && n.value) checkUser(n.value, 'not_info');
    });
  </script>
  <div class="brand">
    <div class="dot"></div>
    <div>
      <b style="font-size: 20px;">Admin Panel</b><br>
      <span class="mini">Theme: <b>Sea Blue</b> • Users: <b><?=count($users)?></b></span>
    </div>
  </div>

  <!-- Mobile Nav Selector -->
  <div class="custom-select-container mobile-nav-select" id="customNavSel">
    <div class="custom-select-trigger" onclick="toggleCustomNav()">
      <span id="navSelText" style="display:flex;align-items:center">
        <?php 
          if($view === "smile") echo '<img src="https://www.google.com/s2/favicons?domain=smile.one&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> Smile';
          else echo $tabs[$view] ?? "Menu";
        ?>
      </span>
      <div class="arrow">▼</div>
    </div>
    <div class="custom-options" id="customNavOptions">
      <?php foreach($tabs as $k=>$n): ?>
        <div class="custom-option <?=($view===$k?"selected":"")?>" onclick="window.location.href='?view=<?=$k?>'">
          <?php 
            if($k === "smile") echo '<img src="https://www.google.com/s2/favicons?domain=smile.one&sz=64"> Smile';
            else echo $n; 
          ?>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="tabbar" id="mainMenu">
    <?php foreach($tabs as $k=>$n): ?>
      <a class="tab <?=($view===$k?"act":"")?>" href="?view=<?=$k?>"><?=$n?></a>
    <?php endforeach; ?>
  </div>
</div>

<div class="wrap">
  <?php if($msg):?><div class="card ok">✅ <?=h($msg)?></div><?php endif;?>
  <?php if($info):?><div class="card info">ℹ️ <?=h($info)?></div><?php endif;?>
  <?php if($err):?><div class="card bad">❌ <?=h($err)?></div><?php endif;?>
  <?php if($warn):?><div class="card bad">⚠️ <?=h(implode(" | ",$warn))?></div><?php endif;?>

  <?php if($view==="dashboard"): ?>
    <div class="stat-grid">
      <div class="stat-card" style="border-left:5px solid #87CEFA">
        <div class="stat-lbl">Total Users</div>
        <div class="stat-val"><?=number_format($stats["users"])?></div>
      </div>
      <div class="stat-card" style="border-left:5px solid #98FB98">
        <div class="stat-lbl">User Balance</div>
        <div class="stat-val"><?=number_format($stats["balance"])?> K</div>
      </div>
      <div class="stat-card" style="border-left:5px solid #FFDAB9">
        <div class="stat-lbl">Total Sales</div>
        <div class="stat-val"><?=number_format($stats["sales_total"])?> K</div>
      </div>
      <div class="stat-card" style="border-left:5px solid #DDA0DD">
        <div class="stat-lbl">Orders (All)</div>
        <div class="stat-val"><?=number_format($stats["orders_total"])?></div>
      </div>
      <div class="stat-card" style="border-left:4px solid #E91E63">
        <div class="stat-lbl">Today Sales</div>
        <div class="stat-val"><?=number_format($stats["sales_today"])?> K</div>
      </div>
      <div class="stat-card" style="border-left:4px solid #00BCD4">
        <div class="stat-lbl">Today Orders</div>
        <div class="stat-val"><?=number_format($stats["orders_today"])?></div>
      </div>
    </div>
    
    <div class="card">
      <h3>🕒 Recent Orders</h3>
      <div class="table-wrap">
      <table>
        <tr><th>Time</th><th>User</th><th>Item</th><th>Amount</th><th>Status</th></tr>
        <?php foreach($recentOrders as $o): ?>
          <tr>
            <td><?=h($o["time"])?></td>
            <td><?=h($o["u_name"])?></td>
            <td><?=h($o["order"])?></td>
            <td><?=h(ks($o["amount"]))?></td>
            <td><span class="mini">✅ Success</span></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$recentOrders) echo "<tr><td colspan='5'>No orders yet</td></tr>"; ?>
      </table>
      </div>
    </div>

    <div class="row">
        <div class="card">
            <h3>📈 Quick Actions</h3>
            <div class="mini">Select a tab above to manage content.</div>
        </div>
        <div class="card">
            <h3>🗓 System Info</h3>
            <div class="mini">
                Time: <?=date("Y-m-d H:i:s")?><br>
                PHP: <?=phpversion()?><br>
                Memory: <?=round(memory_get_usage()/1024/1024,2)?> MB
            </div>
        </div>
    </div>
  <?php endif; ?>

  <?php if($view==="users"): ?>
    <div class="card">
      <h3>👤 Users</h3>
      <form method="get">
        <input type="hidden" name="view" value="users">
        <div class="row">
          <input name="q" placeholder="Search CID..." value="<?=h($q)?>">
          <button class="btn">Search</button>
        </div>
      </form>
    </div>
    <div class="card">
      <div class="table-wrap">
        <table>
          <tr><th>User (CID/Name)</th><th>Balance</th><th>Join</th></tr>
          <?php
            $show=$users;
            if($q!==""){ $show=[]; foreach($users as $cid=>$ud){ if(strpos((string)$cid,$q)!==false) $show[$cid]=$ud; } }
            uasort($show,function($a,$b){ return (int)($b["bal"]??0) <=> (int)($a["bal"]??0); });
            $i=0;
            foreach($show as $cid=>$ud){
              if(++$i>250) break;
              $uName = $ud["username"] ? "@".$ud["username"] : ($ud["name"] ?? "");
              $link = $ud["username"] ? "https://t.me/".$ud["username"] : "tg://user?id=".$cid;
              echo "<tr>
                <td><code>".h($cid)."</code><br><a href='".h($link)."' target='_blank' style='color:#0097A7'>".h($uName)."</a></td>
                <td><b>".h(ks($ud["bal"]??0))."</b></td>
                <td>
                  <div style='margin-bottom:5px'>".h($ud["join"]??"-")."</div>
                  <a href='?view=balance&cid=".h($cid)."' class='btn-sm blue'>💰 Topup</a> 
                  <a href='?view=notify&cid=".h($cid)."' class='btn-sm orange'>🔔 Msg</a>
                </td>
              </tr>";
            }
            if(!$show) echo "<tr><td colspan='3'>No users</td></tr>";
          ?>
        </table>
      </div>
    </div>
  <?php endif; ?>

  <?php if($view==="balance"): ?>
    <div class="card">
      <h3>💰 Balance + Auto Notify</h3>
      <form method="post">
        <div class="row">
          <div>
            <input id="bal_cid" name="cid" placeholder="CID (numbers only)" required value="<?=h($_GET['cid']??"")?>" oninput="checkUser(this.value, 'bal_info')">
            <div id="bal_info" class="mini" style="margin-top:5px;color:#00BCD4;min-height:20px"></div>
          </div>
          <input name="amt" placeholder="+5000 / -2000" required>
        </div>
        <button class="btn" name="add_bal" style="margin-top:10px">UPDATE & NOTIFY</button>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="notify"): ?>
    <div class="card">
      <h3>🔔 Notify (One User)</h3>
      <form method="post" enctype="multipart/form-data">
        <div>
          <input id="not_cid" name="n_cid" placeholder="CID" required value="<?=h($_GET['cid']??"")?>" oninput="checkUser(this.value, 'not_info')">
          <div id="not_info" class="mini" style="margin-top:5px;color:#0097A7;min-height:20px"></div>
        </div>
        <textarea name="n_text" placeholder="Message (Caption)" style="margin-top:10px"></textarea>
        <div class="row" style="margin-top:10px">
          <input name="n_img_url" placeholder="Image URL (optional)">
          <input type="file" name="n_img_file" accept="image/*">
        </div>
        <button class="btn" name="notify_one" style="margin-top:10px">SEND</button>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="broadcast"): ?>
    <div class="card">
      <h3>📣 Broadcast (ALL Users)</h3>
      <form method="post" enctype="multipart/form-data">
        <textarea name="b_text" placeholder="Message (Caption)"></textarea>
        <div class="row" style="margin-top:10px">
          <input name="b_img_url" placeholder="Image URL (optional)">
          <input type="file" name="b_img_file" accept="image/*">
        </div>
        <div class="row" style="margin-top:10px">
          <input name="b_delay" value="<?=h(BC_DELAY_MS)?>" placeholder="Delay ms">
          <input value="Users: <?=count($users)?>" readonly>
        </div>
        <button class="btn" name="broadcast_all" style="margin-top:10px">SEND BROADCAST</button>
      </form>
    </div>
    <?php if($fails): ?>
      <div class="card bad"><h3>❌ Failed</h3>
        <textarea readonly><?=h(json_encode($fails,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT))?></textarea>
      </div>
    <?php endif; ?>
  <?php endif; ?>

  <?php if($view==="prices"): ?>
    <div class="card">
      <h3>🎮 Prices (JSON)</h3>
      <div class="mini">Select a file to edit. Backup is recommended!</div>
    </div>

    <div class="card">
      <div style="margin-bottom:20px">
        <label style="font-weight:bold;color:var(--p-dim);display:block;margin-bottom:8px">Select Price File:</label>
        <div class="custom-select-wrapper">
          <!-- Hidden Original Select -->
          <select id="priceFileSelector" onchange="showPriceForm(this.value)" style="display:none">
            <option value="ml">ML Prices</option>
            <option value="uc">PUBG UC Prices</option>
            <option value="code">PUBG CODE Prices</option>
          </select>

          <!-- Custom Select UI -->
          <div class="custom-select-container" id="customPriceSel">
            <div class="custom-select-trigger" onclick="toggleCustomSelect()">
              <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64" id="selImg">
              <span id="selText">ML Prices</span>
              <div class="arrow">▼</div>
            </div>
            <div class="custom-options" id="customOptions">
              <div class="custom-option selected" onclick="selectCustomOption('ml', 'ML Prices', 'https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64')">
                <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64"> ML Prices
              </div>
              <div class="custom-option" onclick="selectCustomOption('uc', 'PUBG UC Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG UC Prices
              </div>
              <div class="custom-option" onclick="selectCustomOption('code', 'PUBG CODE Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG CODE Prices
              </div>
            </div>
          </div>
        </div>
      </div>

      <div style="display:flex; gap:10px; align-items:center; flex-wrap:wrap; padding-top:20px; border-top:2px dashed var(--border)">
        <strong>⚡ Bulk Update:</strong>
        <input type="number" id="bulkPercent" placeholder="%" style="width:80px; padding:8px; border-radius:15px; border:2px solid #B2EBF2; background:#FFF; color:#555">
        <button class="btn" onclick="applyBulkPrice(1)" style="width:auto; padding:8px 15px; background:#81C784; border:none; box-shadow:0 4px 10px rgba(76,175,80,0.3)">➕ ADD %</button>
        <button class="btn" onclick="applyBulkPrice(-1)" style="width:auto; padding:8px 15px; background:#E57373; border:none; box-shadow:0 4px 10px rgba(229,115,115,0.3)">➖ DEDUCE %</button>
        <div class="mini" style="margin-left:auto">Updates prices in the box below (Click SAVE after)</div>
      </div>
    </div>

    <div id="form_ml" class="price-form">
      <div class="card"><form method="post">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
            <h3 style="margin:0;border:none;display:flex;align-items:center"><img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> ML</h3>
            <div>
                <input type="file" id="impML" accept=".json" style="display:none" onchange="importJson(this, 'mlTa')">
                <button type="button" class="btn" onclick="document.getElementById('impML').click()" style="width:auto;padding:5px 15px;font-size:13px;background:#9575CD">📂 Import JSON</button>
            </div>
        </div>
        <textarea id="mlTa" name="json" style="height:500px; resize:none; font-family:monospace"><?=h($ml)?></textarea>
        <input type="hidden" name="file" value="<?=h(ML_FILE)?>">
        <button class="btn" name="save_price" style="margin-top:10px">SAVE ML</button>
      </form></div>
    </div>

    <div id="form_uc" class="price-form" style="display:none">
      <div class="card"><form method="post">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
            <h3 style="margin:0;border:none;display:flex;align-items:center"><img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> PUBG UC</h3>
            <div>
                <input type="file" id="impUC" accept=".json" style="display:none" onchange="importJson(this, 'ucTa')">
                <button type="button" class="btn" onclick="document.getElementById('impUC').click()" style="width:auto;padding:5px 15px;font-size:13px;background:#9575CD">📂 Import JSON</button>
            </div>
        </div>
        <textarea id="ucTa" name="json" style="height:500px; resize:none; font-family:monospace"><?=h($uc)?></textarea>
        <input type="hidden" name="file" value="<?=h(PUBG_UC_FILE)?>">
        <button class="btn" name="save_price" style="margin-top:10px">SAVE UC</button>
      </form></div>
    </div>

    <div id="form_code" class="price-form" style="display:none">
      <div class="card"><form method="post">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
            <h3 style="margin:0;border:none;display:flex;align-items:center"><img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> PUBG CODE</h3>
            <div>
                <input type="file" id="impCode" accept=".json" style="display:none" onchange="importJson(this, 'codeTa')">
                <button type="button" class="btn" onclick="document.getElementById('impCode').click()" style="width:auto;padding:5px 15px;font-size:13px;background:#9575CD">📂 Import JSON</button>
            </div>
        </div>
        <textarea id="codeTa" name="json" style="height:500px; resize:none; font-family:monospace"><?=h($pc)?></textarea>
        <input type="hidden" name="file" value="<?=h(PUBG_CODE_FILE)?>">
        <button class="btn" name="save_price" style="margin-top:10px">SAVE CODE</button>
      </form></div>
    </div>

    <div id="confirmModal" class="modal-overlay">
      <div class="modal-box">
        <div class="modal-icon">🤔</div>
        <div class="modal-title">Confirm Action</div>
        <div class="modal-desc" id="modalMsg">Are you sure?</div>
        <div class="modal-btns">
          <button class="modal-btn no" onclick="closeModal()">Cancel</button>
          <button class="modal-btn yes" id="modalYesBtn">Yes, Proceed</button>
        </div>
      </div>
    </div>

    <script>
      let pendingBulkAction = null;

      function toggleCustomSelect() {
        document.getElementById('customOptions').classList.toggle('open');
        document.getElementById('customPriceSel').classList.toggle('active');
      }

      function selectCustomOption(val, text, imgUrl) {
        // Update hidden select
        const sel = document.getElementById('priceFileSelector');
        sel.value = val;
        sel.dispatchEvent(new Event('change')); // Trigger onchange for showPriceForm

        // Update trigger UI
        document.getElementById('selImg').src = imgUrl;
        document.getElementById('selText').innerText = text;

        // Update options styling
        document.querySelectorAll('.custom-option').forEach(opt => opt.classList.remove('selected'));
        event.currentTarget.classList.add('selected');

        toggleCustomSelect();
      }

      // Close on click outside
      document.addEventListener('click', function(e) {
        if (!e.target.closest('#customPriceSel')) {
          document.getElementById('customOptions').classList.remove('open');
          document.getElementById('customPriceSel').classList.remove('active');
        }
      });

      function applyBulkPrice(sign){
        let val = parseFloat(document.getElementById('bulkPercent').value);
        if(isNaN(val) || val <= 0){ alert("Please enter a valid positive percentage (e.g. 10)"); return; }
        
        let action = sign > 0 ? "increase" : "decrease";
        let msg = "Are you sure you want to <b>" + action + "</b> all prices by <b>" + val + "%</b>?";
        
        pendingBulkAction = { sign: sign, val: val };
        showModal(msg, executeBulkUpdate);
      }

      function executeBulkUpdate(){
        if(!pendingBulkAction) return;
        const { sign, val } = pendingBulkAction;
        
        const p = val * sign;
        const sel = document.getElementById('priceFileSelector').value;
        const div = document.getElementById('form_'+sel);
        const ta = div.querySelector('textarea');
        
        try {
          let j = JSON.parse(ta.value);
          if(!Array.isArray(j)){ alert("JSON root must be an array!"); return; }
          
          let c=0;
          j.forEach(x => {
            if(x.price !== undefined){
              let old = parseFloat(x.price);
              let nw = old + (old * p / 100);
              x.price = Math.round(nw);
              c++;
            }
          });
          
          ta.value = JSON.stringify(j, null, 4);
          let actionDone = sign > 0 ? "Increased" : "Decreased";
          
          // Re-use modal for success
          closeModal();
          setTimeout(() => {
             alert(actionDone+" "+c+" prices by "+val+"%. Review and click SAVE!");
          }, 200);

        } catch(e) {
          alert("Invalid JSON in text area! Fix it first.");
          closeModal();
        }
      }

      function showPriceForm(val){
        document.querySelectorAll('.price-form').forEach(el => el.style.display = 'none');
        document.getElementById('form_' + val).style.display = 'block';
      }
      
      const savedSel = localStorage.getItem('price_sel');
      if(savedSel && document.getElementById('form_' + savedSel)) {
        document.getElementById('priceFileSelector').value = savedSel;
        showPriceForm(savedSel);
      }
      document.getElementById('priceFileSelector').addEventListener('change', function(){
        localStorage.setItem('price_sel', this.value);
      });

      // Helper functions for Modal
      function showModal(msg, yesCallback){
        document.getElementById('modalMsg').innerHTML = msg;
        const yesBtn = document.getElementById('modalYesBtn');
        // Remove old listeners to prevent stacking
        let newBtn = yesBtn.cloneNode(true);
        yesBtn.parentNode.replaceChild(newBtn, yesBtn);
        
        newBtn.addEventListener('click', yesCallback);
        
        const m = document.getElementById('confirmModal');
        m.classList.add('show');
      }

      function closeModal(){
        document.getElementById('confirmModal').classList.remove('show');
      }
    </script>
  <?php endif; ?>

  <script>
    // Mobile Nav Selector
    function toggleCustomNav() {
      document.getElementById('customNavOptions').classList.toggle('open');
      document.getElementById('customNavSel').classList.toggle('active');
    }

    // Close Nav on click outside
    document.addEventListener('click', function(e) {
      if (!e.target.closest('#customNavSel')) {
        const opts = document.getElementById('customNavOptions');
        const sel = document.getElementById('customNavSel');
        if(opts && opts.classList.contains('open')) {
          opts.classList.remove('open');
          sel.classList.remove('active');
        }
      }
    });

    function importJson(input, taId) {
      const file = input.files[0];
      if (!file) return;
      
      // Strict JSON check (extension or mime)
      if (file.type !== "application/json" && !file.name.toLowerCase().endsWith(".json")) {
        alert("Only JSON files are accepted!");
        input.value = ""; 
        return;
      }

      const reader = new FileReader();
      reader.onload = function(e) {
        const text = e.target.result;
        try {
          const j = JSON.parse(text);
          const nice = JSON.stringify(j, null, 4);
          const ta = document.getElementById(taId);
          if(ta) ta.value = nice;
          alert("JSON imported successfully! Click SAVE to apply.");
        } catch(err) {
          alert("Invalid JSON file content!");
        }
      };
      reader.readAsText(file);
    }

    function importText(input, taId) {
      const file = input.files[0];
      if (!file) return;
      
      // Strict PHP check
      if (!file.name.toLowerCase().endsWith(".php")) {
        alert("Only PHP files are accepted!");
        input.value = ""; 
        return;
      }

      const reader = new FileReader();
      reader.onload = function(e) {
        const text = e.target.result;
        const ta = document.getElementById(taId);
        if(ta) ta.value = text;
        alert("File imported successfully! Click SAVE to apply.");
      };
      reader.readAsText(file);
    }
  </script>

  <?php if($view==="cookies"): ?>
    <div class="card">
      <h3>🍪 Cookies (JSON)</h3>
      <div class="mini">Backups are automatically saved to <code>/BackupCok</code> when you click SAVE.</div>
    </div>

    <div class="card">
      <div style="margin-bottom:10px">
        <input type="file" id="impC" accept=".json" style="display:none" onchange="importJson(this, 'cookiesTa')">
        <button type="button" class="btn" onclick="document.getElementById('impC').click()" style="background:#B39DDB;width:auto;border:none;box-shadow:0 4px 10px rgba(179,157,219,0.4)">📂 Import JSON</button>
      </div>
      <form method="post">
        <textarea id="cookiesTa" name="cookies_text" style="min-height:350px" placeholder="[ { 'name': '...' } ]"><?=h($cookies_now)?></textarea>
        <button class="btn" name="save_cookies" style="margin-top:10px">SAVE COOKIES</button>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="smile"): ?>
    <div class="card">
      <h3><img src="https://www.google.com/s2/favicons?domain=smile.one&sz=64" style="vertical-align:middle;width:28px;margin-right:5px;border-radius:50%"> Smile PHP Editor</h3>
      <div class="mini">Backups are automatically saved to <code>/BackupSmile</code> when you click SAVE.</div>
    </div>

    <div class="card">
      <div style="margin-bottom:10px">
        <input type="file" id="impS" accept=".php" style="display:none" onchange="importText(this, 'smileTa')">
        <button type="button" class="btn" onclick="document.getElementById('impS').click()" style="background:#607D8B;width:auto">📂 Import PHP</button>
      </div>
      <form method="post">
        <textarea id="smileTa" name="smile_text" style="min-height:450px"><?=h($smile_now)?></textarea>
        <button class="btn" name="save_smile" style="margin-top:10px">SAVE SMILE.PHP</button>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="smile_calc"): ?>
    <div class="card">
      <h3>🧮 Smile One Price Calculator</h3>
      <div class="mini">Calculate selling prices based on Base Cost (MMK) and Profit %. Changes here do NOT affect the live JSON files.</div>
      
      <div class="row" style="margin-top:20px; align-items:end">
        <div>
           <label style="font-weight:bold;color:var(--p-dim)">Global Profit % (Optional)</label>
           <input type="number" id="globalProfit" placeholder="e.g. 10" oninput="applyGlobalProfit()">
        </div>
        <div>
           <button class="btn" onclick="applyGlobalProfit()">Apply to All Rows</button>
        </div>
      </div>
    </div>

    <script>
      function calcPrice(id){
        let cost = parseFloat(document.getElementById('cost_'+id).value) || 0;
        let prof = parseFloat(document.getElementById('prof_'+id).value) || 0;
        if(cost > 0){
          let sell = cost + (cost * prof / 100);
          sell = Math.ceil(sell); // Round up
          document.getElementById('res_'+id).innerText = sell.toLocaleString() + " MMK";
        } else {
          document.getElementById('res_'+id).innerText = "-";
        }
      }

      function applyGlobalProfit(){
        let gp = document.getElementById('globalProfit').value;
        let inputs = document.querySelectorAll('.profit-input');
        inputs.forEach(inp => {
          inp.value = gp;
          let id = inp.id.replace('prof_', '');
          calcPrice(id);
        });
      }
    </script>

    <div class="card">
      <h3>💎 Mobile Legends</h3>
      <div class="table-wrap">
        <table>
          <tr>
            <th>Item</th>
            <th>Current Price</th>
            <th>Base Cost (MMK)</th>
            <th>Profit %</th>
            <th>New Price</th>
          </tr>
          <?php 
            $ml_list = @json_decode($ml, true);
            if(is_array($ml_list)):
              foreach($ml_list as $i=>$item): 
                $id = "ml_".$i;
          ?>
          <tr>
            <td><?=h($item['name'])?></td>
            <td><?=h($item['price'])?></td>
            <td><input type="number" id="cost_<?=$id?>" oninput="calcPrice('<?=$id?>')" placeholder="Cost"></td>
            <td><input type="number" id="prof_<?=$id?>" class="profit-input" oninput="calcPrice('<?=$id?>')" placeholder="%"></td>
            <td id="res_<?=$id?>" style="font-weight:bold;color:var(--p-dim)">-</td>
          </tr>
          <?php endforeach; endif; ?>
        </table>
      </div>
    </div>

    <div class="card">
      <h3>🔫 PUBG UC</h3>
      <div class="table-wrap">
        <table>
          <tr>
            <th>Item</th>
            <th>Current Price</th>
            <th>Base Cost (MMK)</th>
            <th>Profit %</th>
            <th>New Price</th>
          </tr>
          <?php 
            $uc_list = @json_decode($uc, true);
            if(is_array($uc_list)):
              foreach($uc_list as $i=>$item): 
                $id = "uc_".$i;
          ?>
          <tr>
            <td><?=h($item['name'])?></td>
            <td><?=h($item['price'])?></td>
            <td><input type="number" id="cost_<?=$id?>" oninput="calcPrice('<?=$id?>')" placeholder="Cost"></td>
            <td><input type="number" id="prof_<?=$id?>" class="profit-input" oninput="calcPrice('<?=$id?>')" placeholder="%"></td>
            <td id="res_<?=$id?>" style="font-weight:bold;color:var(--p-dim)">-</td>
          </tr>
          <?php endforeach; endif; ?>
        </table>
      </div>
    </div>
  <?php endif; ?>

  <?php if($view==="bot"): ?>
    <div class="card">
      <h3>🧩 bot.php Manager</h3>
      <div class="mini">Save/Upload လုပ်တိုင်း <code>/backup</code> ထဲ backup သိမ်းပေးမယ် ✅</div>
    </div>

    <div class="card" style="border:2px solid #FFD54F">
      <h3>🔑 Bot Token</h3>
      <form method="post">
        <input name="new_token" value="<?=h(BOT_TOKEN)?>" placeholder="123456:ABC-DEF..." required>
        <button class="btn" name="save_token" style="margin-top:10px;background:#FFD54F;color:#555;border:none">UPDATE TOKEN</button>
      </form>
    </div>

    <div class="card">
      <h3>✍️ Edit & Save</h3>
      <form method="post">
        <textarea name="bot_text" style="min-height:420px"><?=h($bot_now)?></textarea>
        <button class="btn" name="bot_save_text" style="margin-top:10px">SAVE bot.php</button>
      </form>
    </div>

    <div class="card">
      <h3>📤 Upload bot.php</h3>
      <form method="post" enctype="multipart/form-data">
        <input type="file" name="bot_file" accept=".php,text/plain" required>
        <button class="btn" name="bot_upload_file" style="margin-top:10px">UPLOAD & REPLACE</button>
      </form>
      <div class="mini">Max <?=h(MAX_PHP_MB)?>MB • PHP မဟုတ်ရင် reject လုပ်မယ်</div>
    </div>
  <?php endif; ?>

  <?php if($view==="history"): ?>
    <div class="card"><h3>📜 Global History</h3></div>
    <div class="card">
      <div style="margin-bottom:15px; display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:10px">
         <div>
            <a href="?download_history=1" class="btn" style="width:auto; background:var(--p-dim); font-size:14px; padding:8px 15px; text-decoration:none; display:inline-block">📥 Download History (TXT)</a>
         </div>
         <div style="font-weight:bold; color:var(--p-dim)">Total Records: <span id="totalRows">0</span></div>
      </div>

      <div style="overflow-x:auto">
      <table style="width:100%; border-collapse:collapse">
        <thead>
        <tr style="background:var(--bg); text-align:left">
            <th style="padding:10px">Time</th>
            <th style="padding:10px">Status</th>
            <th style="padding:10px">User</th>
            <th style="padding:10px">Item</th>
            <th style="padding:10px">Amount</th>
            <th style="padding:10px">Info</th>
        </tr>
        </thead>
        <tbody id="historyBody"></tbody>
      </table>
      </div>

      <div class="pagination-controls" style="margin-top:20px; display:flex; justify-content:center; gap:15px; align-items:center">
          <button class="page-btn" onclick="changePage(-1)">❮ Prev</button>
          <span id="pageInfo" style="font-weight:bold; color:#555; font-size:15px">Page 1 of 1</span>
          <button class="page-btn" onclick="changePage(1)">Next ❯</button>
      </div>

      <?php
          $rows=[];
          foreach($hist as $cid=>$list){
            if(!is_array($list)) continue;
            foreach($list as $r){
              $r["cid"] = $cid;
              // Pre-calculate user name for JS
              $r["uName"] = $users[$cid]["name"] ?? ($users[$cid]["username"] ? "@".$users[$cid]["username"] : $cid);
              $rows[] = $r;
            }
          }
          
          // Sort descending by time
          usort($rows, function($a, $b){
             $t1 = DateTime::createFromFormat("H:i d.m.Y", $a["time"]??'');
             $t2 = DateTime::createFromFormat("H:i d.m.Y", $b["time"]??'');
             if(!$t1) return 1; if(!$t2) return -1;
             return $t2 <=> $t1;
          });
      ?>

      <script>
        const historyData = <?= json_encode($rows) ?>;
        let curPage = 1;
        const rowsPerPage = 10;

        function renderHistory(){
            const tbody = document.getElementById('historyBody');
            tbody.innerHTML = "";
            document.getElementById('totalRows').innerText = historyData.length;

            const totalPages = Math.ceil(historyData.length / rowsPerPage) || 1;
            if(curPage < 1) curPage = 1;
            if(curPage > totalPages) curPage = totalPages;

            document.getElementById('pageInfo').innerText = "Page " + curPage + " of " + totalPages;

            const start = (curPage - 1) * rowsPerPage;
            const end = start + rowsPerPage;
            const pageData = historyData.slice(start, end);

            if(pageData.length === 0){
                tbody.innerHTML = "<tr><td colspan='6' style='padding:20px;text-align:center;color:#999'>No history found</td></tr>";
                return;
            }

            pageData.forEach(r => {
                let st = r.status || "success";
                let isFail = st === "fail";
                let color = isFail ? "#FFEBEE" : "#fff";
                let stBadge = isFail ? "<span style='color:red'>❌ Fail</span>" : "<span style='color:green'>✅ Success</span>";
                let info = isFail ? (r.error || "-") : (r.sn || "-");
                let amt = r.amount ? parseInt(r.amount).toLocaleString() : "0";
                let orderItem = r.order || r.item || "-";
                
                let tr = `<tr style="border-bottom:1px solid #eee; background:${color}">
                    <td style="padding:10px; font-size:13px">${r.time || "-"}</td>
                    <td style="padding:10px">${stBadge}</td>
                    <td style="padding:10px">
                        <div style="font-weight:bold; color:var(--text)">${r.uName}</div>
                        <div class="mini">${r.cid}</div>
                    </td>
                    <td style="padding:10px">${orderItem}</td>
                    <td style="padding:10px; font-weight:bold">${amt}</td>
                    <td style="padding:10px; font-size:12px; color:#666; max-width:150px; overflow:hidden; text-overflow:ellipsis" title="${info}">${info}</td>
                </tr>`;
                tbody.innerHTML += tr;
            });
        }

        function changePage(d){
            const totalPages = Math.ceil(historyData.length / rowsPerPage) || 1;
            let newPage = curPage + d;
            if(newPage >= 1 && newPage <= totalPages){
                curPage = newPage;
                renderHistory();
            }
        }

        function downloadHistory(){
            if(historyData.length === 0) { alert("No history to download!"); return; }
            let txt = "Time | Status | CID | User | Item | Amount | Info\n";
            txt += "--------------------------------------------------------------------------------\n";
            historyData.forEach(r => {
                let st = r.status || "success";
                let info = st === "fail" ? (r.error||"") : (r.sn||"");
                let u = r.uName.replace(/\|/g, ""); // sanitize pipe
                let item = (r.order||r.item||"").replace(/\|/g, "");
                txt += `${r.time} | ${st} | ${r.cid} | ${u} | ${item} | ${r.amount} | ${info}\n`;
            });
            
            const blob = new Blob([txt], { type: 'text/plain' });
            const a = document.createElement('a');
            a.href = URL.createObjectURL(blob);
            a.download = "history_" + new Date().toISOString().slice(0,10) + ".txt";
            a.click();
        }

        // Init
        renderHistory();
      </script>
      <style>
        .page-btn {
            background: white;
            border: 2px solid var(--border);
            color: var(--p-dim);
            padding: 8px 20px;
            border-radius: 25px;
            cursor: pointer;
            font-weight: bold;
            font-family: 'Fredoka', sans-serif;
            transition: all 0.2s;
            display: flex;
            align-items: center;
        }
        .page-btn:hover {
            background: var(--p);
            color: white;
            border-color: var(--p);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 188, 212, 0.3);
        }
        .page-btn:active {
            transform: scale(0.95);
        }
      </style>
    </div>
  <?php endif; ?>

</div>
</body>
</html>