<?php
session_start();
error_reporting(0);
date_default_timezone_set("Asia/Yangon");

$passFile = __DIR__ . "/password.json";
$tokenFile = __DIR__ . "/token.json";
$supportFile = __DIR__ . "/support_admins.json";
define('BOT_TOKEN', '8220682200:AAGznEgojTjh8XHVbV6ApAAgDa-UERJyxOg');

// Helper: Validate Telegram Web App Data
function checkTelegramAuthorization($auth_data) {
    if (!isset($auth_data['hash'])) return false;
    $check_hash = $auth_data['hash'];
    unset($auth_data['hash']);
    $data_check_arr = [];
    foreach ($auth_data as $key => $value) {
        $data_check_arr[] = $key . '=' . $value;
    }
    sort($data_check_arr);
    $data_check_string = implode("\n", $data_check_arr);
    // 4. Calculate Secret Key
    // Telegram Logic: HMAC_SHA256(key="WebAppData", message=BOT_TOKEN)
    $secret_key = hash_hmac('sha256', BOT_TOKEN, "WebAppData", true);
    
    // 5. Calculate Hash
    // key is $secret_key
    // data is $data_check_string
    $hash = hash_hmac('sha256', $data_check_string, $secret_key);
    if (strcmp($hash, $check_hash) !== 0) {
        // Fallback: Try with bin2hex (sometimes needed depending on PHP version/libs)
        // If the first check fails, we try the bin2hex method just in case the previous "fix" was actually breaking it for this specific env.
        // However, standard HMAC-SHA256 returns raw binary if raw_output is true, or hex if false.
        // hash_hmac('sha256', ..., ..., true) returns RAW BINARY.
        // bin2hex(raw) -> HEX STRING.
        // Telegram sends HEX STRING.
        
        // Let's debug specifically what we have.
        // $secret_key was generated with raw_output=true (BINARY).
        // $hash was generated with raw_output=false (HEX STRING default).
        
        // WAIT! The official Telegram docs say:
        // secret_key = HMAC_SHA256(bot_token, "WebAppData") <-- RAW BINARY
        // hash = HMAC_SHA256(secret_key, data_check_string) <-- HEX STRING
        
        // My previous code:
        // $secret_key = hash_hmac('sha256', BOT_TOKEN, "WebAppData", true); // CORRECT (True = Raw)
        // $hash = hash_hmac('sha256', $data_check_string, $secret_key);     // CORRECT (Default = Hex)
        
        // If this is failing, maybe the data string is constructed wrong?
        // Let's log the detailed data string to debug_login.log to see if keys are weird.
        
        file_put_contents("debug_login.log", date("Y-m-d H:i:s") . " Hash Mismatch.\nCalc: $hash\nRecv: $check_hash\nDataString: \n$data_check_string\n\n", FILE_APPEND);
        return false;
    }
    if ((time() - $auth_data['auth_date']) > 86400) {
        file_put_contents("debug_login.log", date("Y-m-d H:i:s") . " Data Expired.\n", FILE_APPEND);
        return false;
    }
    return $auth_data;
}

// Handle TG Web App Login
if (isset($_POST['tg_init_data'])) {
    // Manual parsing to avoid parse_str quirks (dots to underscores, etc.)
    $init_data = $_POST['tg_init_data'];
    $auth_data = [];
    $pairs = explode('&', $init_data);
    foreach ($pairs as $pair) {
        if (strpos($pair, '=') === false) continue;
        list($key, $value) = explode('=', $pair, 2);
        $auth_data[$key] = urldecode($value);
    }
    
    // Log for debugging
    // file_put_contents("debug_login_raw.log", print_r($auth_data, true));
 
    $check = checkTelegramAuthorization($auth_data);
    if ($check) {
        $user_data = json_decode($auth_data['user'], true);
        
        // Final fallback for missing 'id' in user_data (rare)
        if (!isset($user_data['id'])) {
             echo json_encode(['ok' => false, 'error' => 'User ID missing in auth data']);
             exit;
        }

        $_SESSION['user_tg_id'] = $user_data['id'];
        
        // Save User Info to Session
        $_SESSION['user_name'] = trim(($user_data['first_name'] ?? '') . ' ' . ($user_data['last_name'] ?? ''));
        $_SESSION['user_photo'] = $user_data['photo_url'] ?? '';

        // Update users.json
        $uFile = __DIR__ . "/data/users.json";
        $all_users = file_exists($uFile) ? json_decode(file_get_contents($uFile), true) : [];
        if (!is_array($all_users)) $all_users = [];
        
        if (!isset($all_users[$user_data['id']])) {
            $all_users[$user_data['id']] = ['bal' => 0];
        }
        $all_users[$user_data['id']]['name'] = $_SESSION['user_name'];
        $all_users[$user_data['id']]['photo'] = $_SESSION['user_photo'];
        $all_users[$user_data['id']]['username'] = $user_data['username'] ?? '';
        
        // Simple lock mechanism
        file_put_contents($uFile, json_encode($all_users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);

        echo json_encode(['ok' => true]);
    } else {
        $debug_msg = "Invalid Data";
        if(file_exists("debug_login.log")){
            $debug_msg .= " (Check debug_login.log)";
        }
        echo json_encode(['ok' => false, 'error' => $debug_msg]);
    }
    exit;
}

// Helper: Telegram Send
function send_tg_msg($cid, $text, $token){
    if(!$token) return false;
    $url = "https://api.telegram.org/bot$token/sendMessage";
    $data = [
        "chat_id" => $cid,
        "text" => $text,
        "parse_mode" => "HTML",
        "disable_web_page_preview" => true
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER=>1, CURLOPT_POST=>1, CURLOPT_POSTFIELDS=>$data, CURLOPT_TIMEOUT=>10]);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

// Helper: Telegram Send Photo
function send_tg_photo($cid, $photo_path, $caption, $token){
    if(!$token) return false;
    $url = "https://api.telegram.org/bot$token/sendPhoto";
    
    // Use realpath to ensure curl can find the file on Windows
    $real_path = realpath($photo_path);
    if(!$real_path) $real_path = $photo_path;

    $cfile = new CURLFile($real_path);
    // Let curl auto-detect mime type from the file extension of our temp file
    
    $data = [
        "chat_id" => $cid,
        "photo" => $cfile,
        "caption" => $caption,
        "parse_mode" => "HTML"
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => 1, 
        CURLOPT_POST => 1, 
        CURLOPT_POSTFIELDS => $data, 
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false // Fix for local Windows SSL issues
    ]);
    $res = curl_exec($ch);
    
    // Debug Logging
    if(curl_errno($ch)){
        file_put_contents("debug_photo.log", date("Y-m-d H:i:s") . " Curl Error: " . curl_error($ch) . "\n", FILE_APPEND);
    } else {
        file_put_contents("debug_photo.log", date("Y-m-d H:i:s") . " Response: " . $res . "\n", FILE_APPEND);
    }
    
    curl_close($ch);
    return $res;
}

// Handle Support Message
if (isset($_POST['send_support']) && isset($_SESSION['user_tg_id'])) {
    $msg = trim($_POST['support_msg']);
    $uid = $_SESSION['user_tg_id'];
    
    if(strlen($msg) > 500){
        $support_error = "Message is too long! Max 500 characters.";
    }

    $photo_attached = false;
    $photo_path = null;
    $temp_file_created = false;

    // Handle Photo Upload
    if(isset($_FILES['support_photo'])){
        if($_FILES['support_photo']['error'] === UPLOAD_ERR_OK){
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];
            $ext = strtolower(pathinfo($_FILES['support_photo']['name'], PATHINFO_EXTENSION));
            if(in_array($ext, $allowed)){
                if($_FILES['support_photo']['size'] <= 5 * 1024 * 1024){ // 5MB limit
                    // Move to a temporary file with correct extension
                    $temp_name = 'temp_img_' . time() . '_' . rand(1000,9999) . '.' . $ext;
                    if(move_uploaded_file($_FILES['support_photo']['tmp_name'], $temp_name)){
                        $photo_path = $temp_name;
                        $photo_attached = true;
                        $temp_file_created = true;
                    } else {
                        $support_error = "Failed to save uploaded image!";
                    }
                } else {
                    $support_error = "Image too large (Max 5MB)!";
                }
            } else {
                $support_error = "Invalid image format (JPG, PNG, GIF only)!";
            }
        } elseif($_FILES['support_photo']['error'] !== UPLOAD_ERR_NO_FILE){
            $err_code = $_FILES['support_photo']['error'];
            if($err_code == UPLOAD_ERR_INI_SIZE || $err_code == UPLOAD_ERR_FORM_SIZE){
                $support_error = "Image too large (Server Limit)!";
            } else {
                $support_error = "Upload failed (Error Code: $err_code)";
            }
        }
    }
    
    if (!isset($support_error) && (!empty($msg) || $photo_attached)) {
        // Use defined BOT_TOKEN
        $token = defined('BOT_TOKEN') ? BOT_TOKEN : null;
        
        // Load Support Admins
        $admins = @json_decode(@file_get_contents($supportFile), true);
        if (!is_array($admins)) $admins = [];
        
        if ($token && !empty($admins)) {
            $formatted_msg = "📩 <b>New Support Message</b>\n\n";
            $formatted_msg .= "From: User (ID: <code>$uid</code>)\n";
            if(!empty($msg)) $formatted_msg .= "Message:\n$msg";
            else $formatted_msg .= "Message: [Photo Only]";
            
            foreach ($admins as $admin_id) {
                if($photo_attached){
                    send_tg_photo($admin_id, $photo_path, $formatted_msg, $token);
                } else {
                    send_tg_msg($admin_id, $formatted_msg, $token);
                }
            }
            $support_status = "Message sent to support! ✅";
        } else {
            $support_error = "Support system offline (No Token/Admins).";
        }
        
        // Clean up temp file
        if($temp_file_created && file_exists($photo_path)){
            @unlink($photo_path);
        }
        
    } elseif(!isset($support_error)) {
        $support_error = "Message cannot be empty!";
    }
}

// Handle Login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    $inputPass = $_POST['password'];
    
    // Read stored password
    $storedData = @json_decode(@file_get_contents($passFile), true);
    $storedPass = $storedData['password'] ?? 'AutoBot2025';

    if ($inputPass === $storedPass) {
        $_SESSION['admin_auth'] = true;
        header("Location: admin.php");
        exit;
    } else {
        $error = "Incorrect Password!";
    }
}

// Handle User Login (TG ID)
if (isset($_POST['tg_id_login'])) {
    $tg_id = trim($_POST['tg_id_login']);
    if (!empty($tg_id)) {
        $_SESSION['user_tg_id'] = $tg_id;
        header("Location: index.php");
        exit;
    }
}
// Handle User Logout
if (isset($_GET['logout_user'])) {
    unset($_SESSION['user_tg_id']);
    header("Location: index.php");
    exit;
}

// User Data Loading
$user_id = $_SESSION['user_tg_id'] ?? null;
$user_info = [];
$user_history = [];
if ($user_id) {
    // Load User Balance
    $uFile = __DIR__ . "/data/users.json";
    if (file_exists($uFile)) {
        $all_users = json_decode(file_get_contents($uFile), true);
        $user_info = $all_users[$user_id] ?? [];
    }
    // Load History
    $hFile = __DIR__ . "/data/history.json";
    if (file_exists($hFile)) {
        $all_hist = json_decode(file_get_contents($hFile), true);
        $user_history = $all_hist[$user_id] ?? [];
        $user_history = array_reverse($user_history); // Newest first
    }
}

// Read Prices
$prices_ml = [];
$mlFile = __DIR__ . "/prices.json";
if (file_exists($mlFile)) {
    $prices_ml = json_decode(file_get_contents($mlFile), true);
}

// Read PUBG UC Prices
$prices_uc = [];
$ucFile = __DIR__ . "/pubg_prices.json";
if (file_exists($ucFile)) {
    $tmp = json_decode(file_get_contents($ucFile), true);
    if(isset($tmp['pubg_uc'])) $tmp = $tmp['pubg_uc'];
    $prices_uc = is_array($tmp) ? $tmp : [];
}

// Read PUBG CODE Prices
$prices_code = [];
$codeFile = __DIR__ . "/pubg_code_prices.json";
if (file_exists($codeFile)) {
    $tmp = json_decode(file_get_contents($codeFile), true);
    if(isset($tmp['pubg_code'])) $tmp = $tmp['pubg_code'];
    $prices_code = is_array($tmp) ? $tmp : [];
}

// Read TopUp Message
$topup_message = "";
$tmFile = __DIR__ . "/topup_msg.json";
if (file_exists($tmFile)) {
    $tm_data = json_decode(file_get_contents($tmFile), true);
    $topup_message = $tm_data['message'] ?? "";
}

// Read Payment Methods
$payment_methods = [];
$pmFile = __DIR__ . "/payment_methods.json";
if (file_exists($pmFile)) {
    $payment_methods = json_decode(file_get_contents($pmFile), true);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AutoTopUp BOT - Home</title>
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --p: #00C853;          /* Vibrant Green */
            --p-dim: #009624;      /* Darker Green */
            --bg: #121212;         /* Dark Background */
            --panel: #1E1E1E;      /* Dark Panel */
            --border: #333333;     /* Dark Border */
            --text: #FFFFFF;       /* White Text */
            --shadow: 0 4px 20px rgba(0, 200, 83, 0.15);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0; padding: 0;
            font-family: 'Fredoka', sans-serif;
            background: var(--bg);
            color: var(--text);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .container {
            width: 100%;
            max-width: 800px;
            padding: 20px;
            margin-top: 20px;
        }
        .card {
            background: var(--panel);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            border: 1px solid #333;
            animation: fadeIn 0.5s ease;
        }
        h1, h2 { margin: 0 0 15px 0; color: var(--p); text-align: center; text-shadow: 0 0 15px rgba(0, 200, 83, 0.5); }
        .logo {
            width: 80px; height: 80px;
            background: rgba(0, 200, 83, 0.1);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border: 1px solid var(--p);
            color: white;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 40px;
            margin: 0 auto 15px auto;
            box-shadow: 0 0 20px rgba(0, 200, 83, 0.4);
        }
        p { line-height: 1.6; text-align: center; color: #CCC; }

        /* Table */
        table { width: 100%; border-collapse: separate; border-spacing: 0 8px; }
        th { text-align: left; padding: 12px; color: var(--p); border-bottom: 2px dashed var(--border); }
        td { background: #2C2C2C; padding: 12px; font-weight: 500; color: #FFF; }
        tr td:first-child { border-top-left-radius: 10px; border-bottom-left-radius: 10px; }
        tr td:last-child { border-top-right-radius: 10px; border-bottom-right-radius: 10px; text-align: right; color: var(--p); font-weight: 700; }
        
        /* Login Form */
        .login-box { max-width: 400px; margin: 0 auto; }
        input {
            width: 100%; padding: 15px;
            border: 2px solid var(--border);
            border-radius: 15px;
            font-family: inherit; font-size: 16px;
            margin-bottom: 15px;
            outline: none; transition: 0.3s;
            background: #2C2C2C;
            color: white;
        }
        input:focus { border-color: var(--p); box-shadow: 0 0 0 4px rgba(0, 200, 83, 0.1); }
        button {
            width: 100%; padding: 15px;
            background: var(--p); color: white;
            border: none; border-radius: 50px;
            font-size: 16px; font-weight: bold;
            cursor: pointer; transition: 0.3s;
            box-shadow: 0 5px 15px rgba(0, 200, 83, 0.3);
        }
        button:hover { background: var(--p-dim); transform: translateY(-2px); }
        .error { color: #FF5252; text-align: center; margin-bottom: 10px; font-weight: bold; }

        /* Custom Select */
        .custom-select-container { position: relative; width: 100%; font-family: 'Fredoka', sans-serif; user-select: none; margin-bottom: 20px; }
        .custom-select-trigger { 
            background: rgba(44, 44, 44, 0.6);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(0, 200, 83, 0.3);
            border-radius: 12px; padding: 12px; display: flex; align-items: center; cursor: pointer; transition: all 0.3s; color: white; 
            box-shadow: 0 0 15px rgba(0, 200, 83, 0.1);
        }
        .custom-select-trigger:hover { border-color: var(--p); box-shadow: 0 0 20px rgba(0, 200, 83, 0.3); }
        .custom-select-trigger img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; object-fit: cover; border: 1px solid #555; }
        .custom-select-trigger span { font-weight: 600; color: #FFF; flex-grow: 1; font-size: 15px; }
        .custom-select-trigger .arrow { color: #AAA; font-size: 12px; transition: transform 0.3s; }
        .custom-options { position: absolute; top: 115%; left: 0; right: 0; background: #2C2C2C; border: 2px solid var(--border); border-radius: 12px; box-shadow: 0 8px 24px rgba(0,0,0,0.5); opacity: 0; visibility: hidden; transform: translateY(-10px); transition: all 0.3s; z-index: 100; overflow-y: auto; max-height: 300px; }
        .custom-options.open { opacity: 1; visibility: visible; transform: translateY(0); }
        .custom-option { padding: 12px; display: flex; align-items: center; cursor: pointer; transition: background 0.2s; border-bottom: 1px solid #333; color: white; }
        .custom-option:last-child { border-bottom: none; }
        .custom-option:hover { background: #383838; }
        .custom-option img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; border: 1px solid #555; }
        .custom-option.selected { background: #383838; font-weight: bold; color: var(--p); }
        .custom-select-container.active .arrow { transform: rotate(180deg); }

        @keyframes fadeIn { from{opacity:0;transform:translateY(10px)} to{opacity:1;transform:translateY(0)} }

        /* Modal */
        .modal {
            display: none; position: fixed; z-index: 1000; left: 0; top: 0;
            width: 100%; height: 100%; overflow: auto;
            background-color: rgba(0,0,0,0.7);
            animation: fadeIn 0.3s;
        }
        .modal-content {
            background-color: #1E1E1E; margin: 10% auto; padding: 25px;
            border: 1px solid #333; width: 90%; max-width: 600px;
            border-radius: 20px; box-shadow: 0 5px 20px rgba(0,0,0,0.5);
            position: relative;
            color: white;
        }
        .close {
            color: #AAA; float: right; font-size: 28px; font-weight: bold;
            cursor: pointer; transition: 0.3s;
        }
        .close:hover { color: #FFF; }

        /* Premium Emoji */
        .e {
            display: inline-block;
            font-style: normal;
            font-size: 1.1em;
            filter: drop-shadow(0 0 6px rgba(0, 200, 83, 0.5));
            transform-origin: center;
            transition: transform 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            margin-right: 4px;
        }
        h1:hover .e, h2:hover .e, h3:hover .e, button:hover .e, .logo:hover .e {
            transform: scale(1.2) rotate(10deg);
            filter: drop-shadow(0 0 10px rgba(0, 200, 83, 0.8));
        }
    </style>
</head>
<body>

    <div class="container">
        <!-- Intro Section -->
        <div class="card">
            <div class="logo"><span class='e'>🤖</span></div>
            <h1>AutoTopUp BOT</h1>
            <p>Welcome to our automated top-up service! <span class='e'>🚀</span><br>
            Fast, secure, and 24/7 instant delivery for all your gaming needs.<br>
            Enjoy the best rates and seamless experience.</p>
        </div>

        <!-- User Dashboard / Login -->
        <?php if ($user_id): ?>
            <?php 
                $dName = $_SESSION['user_name'] ?? $user_info['name'] ?? "User";
                $dPhoto = $_SESSION['user_photo'] ?? $user_info['photo'] ?? "";
            ?>
            <div class="card">
                <h2><span class='e'>👤</span> User Dashboard</h2>
                
                <div style="display:flex; align-items:center; justify-content:center; gap:15px; margin-bottom:20px;">
                    <?php if($dPhoto): ?>
                        <img src="<?= htmlspecialchars($dPhoto) ?>" style="width:65px; height:65px; border-radius:50%; border:3px solid var(--p); object-fit:cover; box-shadow: 0 4px 10px rgba(0,0,0,0.1);">
                    <?php else: ?>
                        <div style="width:65px; height:65px; border-radius:50%; background:var(--p); color:white; display:flex; align-items:center; justify-content:center; font-size:28px; font-weight:bold; border:3px solid var(--p-dim); box-shadow: 0 4px 10px rgba(0,0,0,0.1);">
                            <?= strtoupper(substr($dName, 0, 1)) ?>
                        </div>
                    <?php endif; ?>
                    <div style="text-align:left;">
                        <div style="font-weight:bold; font-size:18px; color:white; margin-bottom:3px;"><?= htmlspecialchars($dName) ?></div>
                        <div style="font-size:13px; color:#CCC; font-family:monospace; background:#333; padding:2px 8px; border-radius:10px; display:inline-block;">ID: <?= htmlspecialchars($user_id) ?></div>
                    </div>
                </div>
                
                <div style="background:#2C2C2C; padding:15px; border-radius:15px; text-align:center; margin-bottom:20px;">
                    <div style="font-size:14px; color:#AAA; margin-bottom:5px;">Your Balance</div>
                    <div style="font-size:24px; font-weight:bold; color:var(--p);">
                        <?= number_format($user_info['bal'] ?? $user_info['balance_mmk'] ?? 0) ?> Ks
                    </div>
                    <button onclick="toggleTopUp()" style="background:var(--p); margin-top:15px; width:auto; padding:10px 25px; border-radius:30px; box-shadow:0 4px 10px rgba(0,200,83,0.3)">
                        <span class='e'>💰</span> Top Up Balance
                    </button>
                </div>

                <!-- Top Up Modal -->
                <div id="topupModal" class="modal">
                    <div class="modal-content">
                        <span class="close" onclick="toggleTopUp()">&times;</span>
                        <h2><span class='e'>💰</span> Top Up Balance</h2>
                        <div style="line-height:1.6; color:#CCC">
                            <?= nl2br($topup_message) ?> 
                        </div>

                        <?php if(!empty($payment_methods)): ?>
                            <h3 style="margin-top:20px; border-bottom:1px dashed #555; padding-bottom:10px"><span class='e'>💳</span> Payment Methods</h3>
                            <div style="overflow-x:auto">
                                <table style="font-size:14px; min-width:300px">
                                    <thead><tr><th>Method</th><th>Number</th><th>Name</th><th>Note</th></tr></thead>
                                    <tbody>
                                        <?php foreach($payment_methods as $pm): ?>
                                            <tr>
                                                <td style="font-weight:bold; color:var(--p)"><?= htmlspecialchars($pm['name']??"") ?></td>
                                                <td style="font-family:monospace; font-size:15px; cursor:pointer" onclick="copyText('<?= htmlspecialchars($pm['no']??"") ?>')">
                                                    <?= htmlspecialchars($pm['no']??"") ?> <span class='e'>📋</span>
                                                </td>
                                                <td><?= htmlspecialchars($pm['acc_name']??"") ?></td>
                                                <td style="font-style:italic; color:#AAA"><?= htmlspecialchars($pm['note']??"") ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <p style="font-size:12px; color:#777; margin-top:5px">* Click on number to copy</p>
                        <?php endif; ?>
                        
                        <div style="text-align:center; margin-top:20px">
                            <button onclick="toggleTopUp()" style="background:var(--p-dim); width:auto; padding:10px 30px">Close</button>
                        </div>
                    </div>
                </div>

                <h3><span class='e'>📜</span> TopUp History</h3>
                <?php if (!empty($user_history)): ?>
                    <?php
                        // Pagination Logic
                        $limit = 10;
                        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                        if ($page < 1) $page = 1;
                        $total_items = count($user_history);
                        $total_pages = ceil($total_items / $limit);
                        $offset = ($page - 1) * $limit;
                        $paged_history = array_slice($user_history, $offset, $limit);
                    ?>
                    <div style="overflow-x:auto;">
                        <table>
                            <thead>
                                <tr>
                                    <th>Time</th>
                                    <th>SN</th>
                                    <th>Game ID</th>
                                    <th>Item</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($paged_history as $h): ?>
                                    <tr>
                                        <td style="font-size:14px; color:#CCC;"><?= htmlspecialchars($h['time'] ?? '-') ?></td>
                                        <td style="font-size:13px; font-family:monospace; color:#AAA;"><?= htmlspecialchars($h['sn'] ?? '-') ?></td>
                                        <td style="font-weight:500; color:#FFF"><?= htmlspecialchars($h['uid_show'] ?? '-') ?></td>
                                        <td style="font-weight:bold; color:#FFF"><?= htmlspecialchars($h['order'] ?? '-') ?></td>
                                        <td style="color:var(--p); font-weight:bold;"><?= number_format($h['amount'] ?? 0) ?> Ks</td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination Controls -->
                    <?php if ($total_pages > 1): ?>
                        <div style="display:flex; justify-content:center; gap:10px; margin-top:15px;">
                            <?php if ($page > 1): ?>
                                <a href="?page=<?= $page - 1 ?>" style="text-decoration:none; padding:8px 15px; background:var(--p); color:white; border-radius:5px; font-weight:bold;">&laquo; Prev</a>
                            <?php else: ?>
                                <span style="padding:8px 15px; background:#555; color:white; border-radius:5px; font-weight:bold; cursor:not-allowed;">&laquo; Prev</span>
                            <?php endif; ?>

                            <span style="padding:8px 15px; background:#333; color:white; border-radius:5px; font-weight:bold;">
                                Page <?= $page ?> of <?= $total_pages ?>
                            </span>

                            <?php if ($page < $total_pages): ?>
                                <a href="?page=<?= $page + 1 ?>" style="text-decoration:none; padding:8px 15px; background:var(--p); color:white; border-radius:5px; font-weight:bold;">Next &raquo;</a>
                            <?php else: ?>
                                <span style="padding:8px 15px; background:#555; color:white; border-radius:5px; font-weight:bold; cursor:not-allowed;">Next &raquo;</span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <p>No transaction history found.</p>
                <?php endif; ?>

                <!-- Support Box -->
                <div style="margin-top:30px; border-top:2px dashed #555; padding-top:20px;">
                    <h3><span class='e'>📩</span> Support Box</h3>
                    <p>Send a message to admin (Report issues / Help)</p>
                    
                    <?php if(isset($support_status)): ?>
                        <div style="background:#1B5E20; color:#fff; padding:10px; border-radius:10px; margin-bottom:10px; text-align:center; font-weight:bold"><?= $support_status ?></div>
                    <?php endif; ?>
                    <?php if(isset($support_error)): ?>
                        <div style="background:#B71C1C; color:#fff; padding:10px; border-radius:10px; margin-bottom:10px; text-align:center; font-weight:bold"><?= $support_error ?></div>
                    <?php endif; ?>

                    <form method="post" enctype="multipart/form-data">
                        <textarea name="support_msg" maxlength="500" rows="4" placeholder="Write your message here (Max 500 chars)..." style="width:100%; padding:15px; border:2px solid #555; background:#2C2C2C; color:white; border-radius:15px; font-family:inherit; resize:vertical; outline:none; transition:0.3s" oninput="document.getElementById('char-count').textContent = this.value.length + '/500'"></textarea>
                        <div id="char-count" style="text-align:right; font-size:12px; color:#AAA; margin-top:5px; font-weight:bold">0/500</div>
                        
                        <div style="margin-top:10px; display:flex; align-items:center; gap:10px">
                            <label for="support_photo" style="cursor:pointer; background:#333; padding:10px 15px; border-radius:10px; color:white; font-size:14px; font-weight:bold; border:1px dashed var(--p); display:flex; align-items:center; gap:5px; transition:0.3s">
                                <span class='e'>📷</span> Attach Photo
                                <input type="file" name="support_photo" id="support_photo" accept="image/*" style="display:none" onchange="document.getElementById('file-name').textContent = this.files[0] ? this.files[0].name : ''">
                            </label>
                            <span id="file-name" style="font-size:13px; color:#AAA; max-width:150px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis"></span>
                        </div>

                        <button name="send_support" style="background:var(--p); margin-top:15px"><span class='e'>📨</span> Send Message</button>
                    </form>
                </div>

                <a href="?logout_user=1" style="display:block; text-align:center; margin-top:20px; color:#FF5252; text-decoration:none; font-weight:bold;">Logout</a>
            </div>
        <?php else: ?>
            <div class="card login-box">
                <h2><span class='e'>👤</span> User Login</h2>
                <form method="POST">
                    <input type="number" name="tg_id_login" placeholder="Enter Telegram ID to check History" required>
                    <button type="submit" style="background:var(--p);">Check History</button>
                </form>
            </div>
        <?php endif; ?>

        <!-- Price Table -->
        <div class="card">
            <h2><span class='e'>💎</span> Price List</h2>
            
            <!-- Custom Select UI -->
            <div class="custom-select-container" id="guestPriceSel">
                <div class="custom-select-trigger" onclick="toggleGuestSelect()">
                    <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64" id="selImg">
                    <span id="selText">ML Prices</span>
                    <div class="arrow">▼</div>
                </div>
                <div class="custom-options" id="guestOptions">
                    <div class="custom-option selected" onclick="selectGuestOption('ml', 'ML Prices', 'https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64')">
                        <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64"> ML Prices
                    </div>
                    <div class="custom-option" onclick="selectGuestOption('uc', 'PUBG UC Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                        <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG UC Prices
                    </div>
                    <div class="custom-option" onclick="selectGuestOption('code', 'PUBG CODE Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                        <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG CODE Prices
                    </div>
                </div>
            </div>

            <!-- ML Table -->
            <div id="table_ml" class="price-table">
                <?php if (!empty($prices_ml)): ?>
                    <table>
                        <thead><tr><th>Item Name</th><th>Price (MMK)</th></tr></thead>
                        <tbody>
                            <?php foreach ($prices_ml as $p): ?>
                                <tr>
                                    <td><?= htmlspecialchars($p['name'] ?? 'Unknown') ?></td>
                                    <td><?= number_format($p['price'] ?? 0) ?> Ks</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No prices available.</p>
                <?php endif; ?>
            </div>

            <!-- UC Table -->
            <div id="table_uc" class="price-table" style="display:none">
                <?php if (!empty($prices_uc)): ?>
                    <table>
                        <thead><tr><th>Item Name</th><th>Price (MMK)</th></tr></thead>
                        <tbody>
                            <?php foreach ($prices_uc as $p): ?>
                                <tr>
                                    <td><?= htmlspecialchars($p['name'] ?? 'Unknown') ?></td>
                                    <td><?= number_format($p['price'] ?? 0) ?> Ks</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No prices available.</p>
                <?php endif; ?>
            </div>

            <!-- CODE Table -->
            <div id="table_code" class="price-table" style="display:none">
                <?php if (!empty($prices_code)): ?>
                    <table>
                        <thead><tr><th>Item Name</th><th>Price (MMK)</th></tr></thead>
                        <tbody>
                            <?php foreach ($prices_code as $p): ?>
                                <tr>
                                    <td><?= htmlspecialchars($p['name'] ?? 'Unknown') ?></td>
                                    <td><?= number_format($p['price'] ?? 0) ?> Ks</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No prices available.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Admin Login -->
        <div class="card login-box">
            <h2>Admin Login</h2>
            <?php if (isset($error)): ?>
                <div class="error"><?= $error ?></div>
            <?php endif; ?>
            <form method="POST">
                <input type="password" name="password" placeholder="Enter Admin Password" required>
                <button type="submit">Login to Panel</button>
            </form>
        </div>
    </div>

    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    <script>
    // TG Auto Login
    (function(){
        const tg = window.Telegram.WebApp;
        tg.expand();
        const isLoggedIn = <?= $user_id ? 'true' : 'false' ?>;
        
        if (!isLoggedIn && tg.initData) {
            // Hide login forms
            document.querySelectorAll('.login-box').forEach(el => el.style.display = 'none');
            
            // Show loading
            const loading = document.createElement('div');
            loading.innerHTML = '<h3><span class="e">🔄</span> Auto-logging in...</h3>';
            loading.style.cssText = 'text-align:center; padding:20px; color:#E91E63; background:white; border-radius:15px; margin:20px; box-shadow:0 5px 15px rgba(0,0,0,0.1);';
            const container = document.querySelector('.container');
            if(container) container.insertBefore(loading, container.children[1]); // Insert after header

            fetch('index.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'tg_init_data=' + encodeURIComponent(tg.initData)
            })
            .then(r => r.json())
            .then(d => {
                if (d.ok) {
                    location.reload();
                } else {
                    loading.innerText = 'Login Failed: ' + (d.error || 'Unknown');
                    loading.style.color = 'red';
                    setTimeout(() => {
                        loading.remove();
                        document.querySelectorAll('.login-box').forEach(el => el.style.display = 'block');
                    }, 2000);
                }
            })
            .catch(e => {
                console.error(e);
                loading.remove();
                document.querySelectorAll('.login-box').forEach(el => el.style.display = 'block');
            });
        }
    })();

    function toggleGuestSelect() {
        document.getElementById('guestOptions').classList.toggle('open');
        document.getElementById('guestPriceSel').classList.toggle('active');
    }

    function selectGuestOption(val, text, imgUrl) {
        // Update trigger UI
        document.getElementById('selImg').src = imgUrl;
        document.getElementById('selText').innerText = text;

        // Update options styling
        document.querySelectorAll('.custom-option').forEach(opt => opt.classList.remove('selected'));
        event.currentTarget.classList.add('selected');

        toggleGuestSelect();

        // Switch Table
        document.querySelectorAll('.price-table').forEach(t => t.style.display = 'none');
        document.getElementById('table_' + val).style.display = 'block';
    }

    // Close on click outside
    document.addEventListener('click', function(e) {
        if (!e.target.closest('#guestPriceSel')) {
            const opts = document.getElementById('guestOptions');
            const sel = document.getElementById('guestPriceSel');
            if(opts && opts.classList.contains('open')) {
                opts.classList.remove('open');
                sel.classList.remove('active');
            }
        }
    });

    function toggleTopUp() {
        var modal = document.getElementById("topupModal");
        if (modal.style.display === "block") {
            modal.style.display = "none";
        } else {
            modal.style.display = "block";
        }
    }
    
    // Close modal if clicked outside (Global)
    window.onclick = function(event) {
        var modal = document.getElementById("topupModal");
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }

    function copyText(text) {
        navigator.clipboard.writeText(text).then(function() {
            // Create/Show Toast
            var toast = document.getElementById("copy_toast");
            if(!toast){
                toast = document.createElement("div");
                toast.id = "copy_toast";
                toast.style.cssText = "position:fixed; bottom:30px; left:50%; transform:translateX(-50%); background:rgba(0,0,0,0.8); color:white; padding:12px 24px; border-radius:25px; z-index:9999; font-size:14px; box-shadow:0 4px 15px rgba(0,0,0,0.2); transition:opacity 0.3s";
                document.body.appendChild(toast);
            }
            toast.innerText = "Copied: " + text;
            toast.style.opacity = "1";
            toast.style.display = "block";
            
            setTimeout(function(){ 
                toast.style.opacity = "0"; 
                setTimeout(function(){ toast.style.display = "none"; }, 300);
            }, 2000);
        }, function(err) {
            console.error('Async: Could not copy text: ', err);
        });
    }
    </script>
</body>
</html>