$jsonPath = "cookies.json"

if (-not (Test-Path $jsonPath)) {
    Write-Host "❌ cookies.json not found!" -ForegroundColor Red
    exit
}

try {
    $cookies = Get-Content $jsonPath | ConvertFrom-Json
} catch {
    Write-Host "❌ cookies.json is not valid JSON!" -ForegroundColor Red
    exit
}

$foundCF = $false
$foundSess = $false
$foundUID = $false

Write-Host "Analyzing cookies.json..." -ForegroundColor Cyan

foreach ($c in $cookies) {
    if ($c.name -eq "cf_clearance") {
        $foundCF = $true
        Write-Host "✅ Found 'cf_clearance' (Expires: $($c.expirationDate))" -ForegroundColor Green
    }
    if ($c.name -eq "PHPSESSID" -or $c.name -eq "session_id") {
        $foundSess = $true
        Write-Host "✅ Found Session Cookie ($($c.name))" -ForegroundColor Green
    }
    if ($c.name -eq "uid" -or $c.name -match "user") {
        $foundUID = $true
        Write-Host "✅ Found User Cookie ($($c.name))" -ForegroundColor Green
    }
}

if (-not $foundCF) {
    Write-Host "⚠️  MISSING 'cf_clearance' cookie!" -ForegroundColor Yellow
    Write-Host "   -> This is required to bypass Cloudflare."
}

if (-not $foundSess) {
    Write-Host "⚠️  MISSING Session cookie (PHPSESSID)!" -ForegroundColor Yellow
    Write-Host "   -> You might not be logged in."
}

if ($foundCF -and $foundSess) {
    Write-Host "`n🎉 cookies.json looks good! Try running /smile in the bot." -ForegroundColor Cyan
} else {
    Write-Host "`n❌ Please re-export cookies from your browser." -ForegroundColor Red
}
