<?php
if(session_status()===PHP_SESSION_NONE) session_start();
ob_start();
error_reporting(0);
date_default_timezone_set("Asia/Yangon");
//line 1511 sai api key
/* ===== CONFIG ===== */
define("PASSWORD_FILE", __DIR__."/password.json");
define("TOKEN_FILE",__DIR__."/token.json");
$tk_data = @json_decode(@file_get_contents(TOKEN_FILE), true);
define("BOT_TOKEN", $tk_data["token"] ?? "8220682200:AAGznEgojTjh8XHVbV6ApAAgDa-UERJyxOg");

define("UFILE",__DIR__."/data/users.json");
define("HFILE",__DIR__."/data/history.json");

define("ML_FILE",__DIR__."/prices.json");
define("PUBG_UC_FILE",__DIR__."/pubg_prices.json");
define("PUBG_CODE_FILE",__DIR__."/pubg_code_prices.json");

define("COOKIES_FILE",__DIR__."/cookies.json");
define("BACKUP_COK_DIR",__DIR__."/BackupCok");

define("SMILE_FILE",__DIR__."/smile.php");
define("BACKUP_SMILE_DIR",__DIR__."/BackupSmile");
define("BACKUP_ADM_DIR",__DIR__."/BackupAdm");
define("ADMIN_FILE", __FILE__);

define("BOT_FILE",__DIR__."/bot.php");
define("BACKUP_DIR",__DIR__."/backup");
define("SUPPORT_ADMINS_FILE", __DIR__."/support_admins.json");
define("TOPUP_MSG_FILE", __DIR__."/topup_msg.json");
define("BALANCE_MSG_FILE", __DIR__."/balance_msg.json");
define("PAYMENT_METHODS_FILE", __DIR__."/payment_methods.json");
define("NOTIFY_MSG_FILE", __DIR__."/notify_msg.json");
define("NOTIFY_FOOTER_FILE", __DIR__."/notify_footer.json");
define("SAI_KEY_FILE", __DIR__."/sai_api_key.json");
define("BACKUP_SAI_DIR",__DIR__."/BackupSaiApi");
define("SMILE_API_CONFIG_FILE", __DIR__."/smile_api_config.json");
define("BACKUP_SMILE_API_DIR", __DIR__."/BackupUrlApi");
define("INDEX_FILE", __DIR__."/index.php");
define("BACKUP_APP_DIR", __DIR__."/BackupApp");
define("THEME_FILE", __DIR__."/theme_config.json");
define("TOPUP_CODES_FILE", __DIR__."/data/topup_codes.json");
define("MENU_FILE", __DIR__."/data/menu.json");

/* ===== THEME HANDLER ===== */
// Helper for Hex to RGBA
if (!function_exists('hex2rgba')) {
    function hex2rgba($color, $opacity = false) {
        $default = 'rgb(0,0,0)';
        if(empty($color)) return $default; 
        if ($color[0] == '#' ) {
            $color = substr( $color, 1 );
        }
        if (strlen($color) == 6) {
                $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
        } elseif ( strlen( $color ) == 3 ) {
                $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
        } else { return $default; }
        $rgb =  array_map('hexdec', $hex);
        if($opacity){
            if(abs($opacity) > 1) $opacity = 1.0;
            $output = 'rgba('.implode(",",$rgb).','.$opacity.')';
        } else {
            $output = 'rgb('.implode(",",$rgb).')';
        }
        return $output;
    }
}

if (isset($_POST['save_theme']) && isset($_SESSION['admin_auth'])) {
    $new_theme = [
        "name" => "Custom",
        "p" => $_POST['p'] ?? "#E91E63",
        "p_dim" => $_POST['p_dim'] ?? "#C2185B",
        "bg" => $_POST['bg'] ?? "#121212",
        "panel" => $_POST['panel'] ?? "#1E1E1E",
        "text" => $_POST['text'] ?? "#F8BBD0",
        "border" => $_POST['border'] ?? "#333333",
        "shadow" => "0 4px 20px " . hex2rgba($_POST['p'] ?? "#E91E63", 0.2)
    ];
    file_put_contents(THEME_FILE, json_encode($new_theme, JSON_PRETTY_PRINT));
    $msg = "Theme updated successfully!";
}

define("MAX_IMG_MB",10);
define("MAX_PHP_MB",2);
define("BC_DELAY_MS",80);

/* ===== AUTHENTICATION ===== */
// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit;
}

// Login Handler
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    $inputPass = $_POST['password'];
    $storedData = @json_decode(@file_get_contents(PASSWORD_FILE), true);
    $storedPass = $storedData['password'] ?? 'AutoBot2025';

    if ($inputPass === $storedPass) {
        $_SESSION['admin_auth'] = true;
        header("Location: admin.php");
        exit;
    } else {
        $loginErr = "Incorrect Password!";
    }
}

// GUEST VIEW (Start Page)
if (empty($_SESSION['admin_auth'])) {
    $prices_ml = file_exists(ML_FILE) ? json_decode(file_get_contents(ML_FILE), true) : [];
    
    $tmp_uc = file_exists(PUBG_UC_FILE) ? json_decode(file_get_contents(PUBG_UC_FILE), true) : [];
    if(isset($tmp_uc['pubg_uc'])) $tmp_uc = $tmp_uc['pubg_uc'];
    $prices_uc = is_array($tmp_uc) ? $tmp_uc : [];

    $tmp_code = file_exists(PUBG_CODE_FILE) ? json_decode(file_get_contents(PUBG_CODE_FILE), true) : [];
    if(isset($tmp_code['pubg_code'])) $tmp_code = $tmp_code['pubg_code'];
    $prices_code = is_array($tmp_code) ? $tmp_code : [];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AutoTopUp BOT - Home</title>
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --p: #E91E63; --p-dim: #C2185B; --bg: #121212;
            --panel: #1E1E1E; --text: #F8BBD0; --border: #333333;
            --shadow: 0 4px 20px rgba(233, 30, 99, 0.2);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0; padding: 0; font-family: 'Fredoka', sans-serif;
            background: var(--bg); color: var(--text);
            min-height: 100vh; display: flex; flex-direction: column; align-items: center;
        }
        .container { width: 100%; max-width: 800px; padding: 20px; margin-top: 20px; }
        .card {
            background: var(--panel); border-radius: 20px; padding: 30px;
            margin-bottom: 25px; box-shadow: var(--shadow); border: 1px solid #333;
            animation: fadeIn 0.5s ease;
        }
        h1, h2 { margin: 0 0 15px 0; color: var(--p); text-align: center; }
        .logo {
            width: 80px; height: 80px; background: var(--p); color: white;
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            font-size: 40px; margin: 0 auto 15px auto; box-shadow: 0 5px 15px rgba(233, 30, 99, 0.4);
        }
        p { line-height: 1.6; text-align: center; color: #BBB; }
        table { width: 100%; border-collapse: separate; border-spacing: 0 8px; }
        th { text-align: left; padding: 12px; color: var(--p); border-bottom: 2px dashed var(--border); }
        td { background: #2C2C2C; padding: 12px; font-weight: 500; }
        tr td:first-child { border-top-left-radius: 10px; border-bottom-left-radius: 10px; }
        tr td:last-child { border-top-right-radius: 10px; border-bottom-right-radius: 10px; text-align: right; color: var(--p); font-weight: 700; }
        input {
            width: 100%; padding: 15px; border: 2px solid var(--border);
            border-radius: 15px; font-family: inherit; font-size: 16px;
            margin-bottom: 15px; outline: none; transition: 0.3s;
            background: #2C2C2C; color: var(--text);
        }
        input:focus { border-color: var(--p); box-shadow: 0 0 0 4px rgba(233, 30, 99, 0.1); }
        button {
            width: 100%; padding: 15px; background: var(--p); color: white;
            border: none; border-radius: 50px; font-size: 16px; font-weight: bold;
            cursor: pointer; transition: 0.3s; box-shadow: 0 5px 15px rgba(233, 30, 99, 0.3);
        }
        button:hover { background: var(--p-dim); transform: translateY(-2px); }
        .error { color: #FF5252; text-align: center; margin-bottom: 10px; font-weight: bold; }
        
        /* Start Bot Button */
        .start-btn {
            display: flex; align-items: center; justify-content: center; gap: 10px;
            width: 100%; padding: 16px; 
            background: linear-gradient(45deg, #FF4081, #E91E63);
            color: white; font-size: 18px; font-weight: bold;
            border-radius: 50px; text-decoration: none;
            box-shadow: 0 8px 20px rgba(233, 30, 99, 0.4);
            transition: transform 0.2s, box-shadow 0.2s;
            margin-bottom: 10px; margin-top: 10px;
        }
        .start-btn:hover { transform: translateY(-3px); box-shadow: 0 12px 25px rgba(233, 30, 99, 0.5); }
        .start-btn:active { transform: scale(0.98); }

        /* Custom Select */
        .custom-select-container { position: relative; width: 100%; font-family: 'Fredoka', sans-serif; user-select: none; margin-bottom: 20px; }
        .custom-select-trigger { background: #2C2C2C; border: 2px solid var(--border); border-radius: 12px; padding: 12px; display: flex; align-items: center; cursor: pointer; transition: all 0.3s; color: var(--text); }
        .custom-select-trigger:hover { border-color: var(--p); box-shadow: 0 4px 12px rgba(0,0,0,0.2); }
        .custom-select-trigger img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; object-fit: cover; border: 1px solid #555; }
        .custom-select-trigger span { font-weight: 600; color: var(--text); flex-grow: 1; font-size: 15px; }
        .custom-select-trigger .arrow { color: #AAA; font-size: 12px; transition: transform 0.3s; }
        .custom-options { position: absolute; top: 115%; left: 0; right: 0; background: #2C2C2C; border: 2px solid var(--border); border-radius: 12px; box-shadow: 0 8px 24px rgba(0,0,0,0.3); opacity: 0; visibility: hidden; transform: translateY(-10px); transition: all 0.3s; z-index: 100; overflow-y: auto; max-height: 300px; }
        .custom-options.open { opacity: 1; visibility: visible; transform: translateY(0); }
        .custom-option { padding: 12px; display: flex; align-items: center; cursor: pointer; transition: background 0.2s; border-bottom: 1px solid #333; color: var(--text); }
        .custom-option:last-child { border-bottom: none; }
        .custom-option:hover { background: #333; }
        .custom-option img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; border: 1px solid #555; }
        .custom-option.selected { background: #333; font-weight: bold; color: var(--p); }
        .custom-select-container.active .arrow { transform: rotate(180deg); }

        @keyframes fadeIn { from{opacity:0;transform:translateY(10px)} to{opacity:1;transform:translateY(0)} }
    </style>
</head>
<body>
    <div class="container">
        <div class="card" style="max-width:420px;margin:0 auto">
            <h2>Admin Login</h2>
            <?php if (isset($loginErr)): ?>
                <div class="error"><?= $loginErr ?></div>
            <?php endif; ?>

            <form method="POST">
               <div class="mini" style="text-align:center; margin-top:8px; color:#FFCDD2">Don’t share password ✅</div>
                <input type="password" name="password" placeholder="Enter Admin Password" required>
                <button type="submit" title="Donot share pass etc.. fill yourself">Login to Panel</button>
               
            </form>
            <?php 
              $guest_user_count = 0; 
              $uf = __DIR__."/data/users.json";
              if(file_exists($uf)){
                $tmp = @json_decode(@file_get_contents($uf), true);
                if(is_array($tmp)) $guest_user_count = count($tmp);
              }
            ?>
            <div style="display:flex; gap:10px; margin-top:10px; align-items:center; justify-content:center">
              <button type="button" onclick="document.getElementById('guestUserBlock').style.display = (document.getElementById('guestUserBlock').style.display === 'none' ? 'block' : 'none')" style="width:auto; padding:8px 14px; background:var(--p); color:white; border:none; border-radius:12px; font-weight:bold"><span class="e">👥</span> Total Users</button>
            </div>
            
            <div id="guestUserBlock" style="display:none; margin-top:12px; background:var(--panel); border:1px solid var(--border); border-radius:15px; padding:15px; text-align:center">
              <div style="font-size:12px; color:#90A4AE; font-weight:bold; letter-spacing:0.5px">Total Users</div>
              <div style="font-size:28px; font-weight:bold; color:var(--p)"><?= number_format($guest_user_count) ?></div>
            </div>
        </div>
    </div>
    
</body>
</html>
<?php
    exit; // Stop Admin Panel execution
}

/* ===== BASIC ===== */
function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,"UTF-8"); }
function jr($f){
  if(!file_exists($f)) return [];
  $j=@json_decode(@file_get_contents($f),true);
  return is_array($j)?$j:[];
}
function jw($f,$d){
  @mkdir(dirname($f),0777,true);
  $tmp=$f.".tmp";
  @file_put_contents($tmp,json_encode($d,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE),LOCK_EX);
  @rename($tmp,$f);
}
function read_text($f,$fallback="[]"){
  if(!file_exists($f)) return $fallback;
  $t=trim((string)@file_get_contents($f));
  return ($t==="")?$fallback:$t;
}
function write_text_atomic($f,$txt){
  @mkdir(dirname($f),0777,true);
  $tmp=$f.".tmp";
  @file_put_contents($tmp,$txt,LOCK_EX);
  @rename($tmp,$f);
  return true;
}


/* ===== Telegram ===== */
function tg_api($method,$data,$multipart=false){
  $url="https://api.telegram.org/bot".BOT_TOKEN."/".$method;
  $ch=curl_init($url);
  curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>1,CURLOPT_POST=>1,CURLOPT_POSTFIELDS=>$data,CURLOPT_TIMEOUT=>35,CURLOPT_CONNECTTIMEOUT=>10]);
  if($multipart) curl_setopt($ch,CURLOPT_HTTPHEADER,["Expect:"]);
  $res=curl_exec($ch); $err=curl_error($ch); curl_close($ch);
  if($res===false||$res==="") return ["ok"=>0,"description"=>$err?: "empty_response"];
  $j=@json_decode($res,true);
  return is_array($j)?$j:["ok"=>0,"description"=>"bad_json","raw"=>$res];
}
function tg_text($cid,$text){
  $text=trim((string)$text); if($text==="") $text=" ";
  return tg_api("sendMessage",["chat_id"=>$cid,"text"=>$text,"parse_mode"=>"HTML","disable_web_page_preview"=>true],false);
}
function tg_photo_file($cid,$filePath,$caption=""){
  $caption=trim((string)$caption);
  if(mb_strlen($caption)>1024) $caption=mb_substr($caption,0,1020)."...";
  $mime=function_exists("mime_content_type")?@mime_content_type($filePath):"image/jpeg"; if(!$mime) $mime="image/jpeg";
  $cf=new CURLFile($filePath,$mime,basename($filePath));
  return tg_api("sendPhoto",["chat_id"=>$cid,"photo"=>$cf,"caption"=>$caption,"parse_mode"=>"HTML"],true);
}
function dl_tmp($url,&$e=null){
  $e=null; $url=trim((string)$url);
  if($url===""){ $e="empty_url"; return null; }
  $tmp=tempnam(sys_get_temp_dir(),"adm_"); if(!$tmp){ $e="tmp_fail"; return null; }
  $fp=@fopen($tmp,"w"); if(!$fp){ @unlink($tmp); $e="fp_fail"; return null; }
  $ch=curl_init($url);
  curl_setopt_array($ch,[CURLOPT_FILE=>$fp,CURLOPT_FOLLOWLOCATION=>1,CURLOPT_TIMEOUT=>25,CURLOPT_CONNECTTIMEOUT=>10,
    CURLOPT_USERAGENT=>"Mozilla/5.0",CURLOPT_SSL_VERIFYPEER=>0,CURLOPT_SSL_VERIFYHOST=>0]);
  $ok=curl_exec($ch); $cerr=curl_error($ch); $code=curl_getinfo($ch,CURLINFO_HTTP_CODE); curl_close($ch); fclose($fp);
  $sz=@filesize($tmp);
  if(!$ok||$code<200||$code>=300||$sz<200){ @unlink($tmp); $e="download_fail code=$code err=$cerr"; return null; }
  if($sz>MAX_IMG_MB*1024*1024){ @unlink($tmp); $e="file_too_large"; return null; }
  return $tmp;
}
function tg_send_any($cid,$text,$imgUrl="",$imgFileTmp=null){
  if($imgFileTmp && file_exists($imgFileTmp)) return tg_photo_file($cid,$imgFileTmp,$text);
  $imgUrl=trim((string)$imgUrl);
  if($imgUrl!==""){
    $e=null; $tmp=dl_tmp($imgUrl,$e); if(!$tmp) return ["ok"=>0,"description"=>"img_download_failed: ".$e];
    $r=tg_photo_file($cid,$tmp,$text); @unlink($tmp); return $r;
  }
  return tg_text($cid,$text);
}
function ks($n){ return number_format((int)round((float)$n))." MMK"; }

/* ===== EXTERNAL BALANCES ===== */
function get_pubg_balance($key){
    $url = "https://saigameshop.com/Autogameshop/Gameshopbot/api.php?action=balance";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["X-API-KEY: $key"]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    $res = curl_exec($ch);
    curl_close($ch);
    $j = @json_decode($res, true);
    // Assuming response is {"ok":true, "balance": 1234} or similar. 
    // If user provided raw output { "ok": false, ... } for error, we handle that.
    if(isset($j['balance'])) return "$".number_format($j['balance']);
    if(isset($j['message'])) return $j['message'];
    return "Error";
}

function get_smile_balance(){
    if(!file_exists(COOKIES_FILE)) return "No Cookies";
    $cok = @file_get_contents(COOKIES_FILE);
    $cookies = @json_decode($cok, true);
    if(!is_array($cookies)) return "Bad Cookies";
    
    $cStr = "";
    $region = "";
    
    foreach($cookies as $cookie){
        // Handle Cookie-Editor format (Array of Objects)
        if(is_array($cookie) && isset($cookie['name'], $cookie['value'])){
            $name = $cookie['name'];
            $value = $cookie['value'];
            
            // Logic from smile.php: Decode -> Unserialize -> Encode
            $decoded = urldecode($value);
            if (strpos($decoded, 'a:2:{') === 0) {
                $unserialized = @unserialize($decoded);
                if ($unserialized !== false && isset($unserialized[1])) {
                    $value = $unserialized[1];
                } else {
                    $value = $decoded;
                }
            } else {
                $value = $decoded;
            }
            
            $cStr .= $name . '=' . urlencode($value) . '; ';
            
            // Detect region
            if($name === 'website_path'){
                // website_path is usually simple text like "/br"
                if(strpos($value, '/') !== false && strlen($value) < 10) $region = rtrim($value, '/');
            }
        } 
        // Handle simple Key-Value format (Legacy support)
        elseif(!is_int($cookie) && is_scalar($cookie)){
            $cStr .= "$cookie=" . urlencode((string)$cookies[$cookie] ?? "") . "; "; 
        }
    }
    
    // Robust Headers
    $headers = [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: en-US,en;q=0.9',
        'Cache-Control: no-cache',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1',
        'sec-ch-ua: "Not A(Brand";v="99", "Google Chrome";v="121", "Chromium";v="121"',
        'sec-ch-ua-mobile: ?0',
        'sec-ch-ua-platform: "Windows"',
        'Sec-Fetch-Site: none',
        'Sec-Fetch-Mode: navigate',
        'Sec-Fetch-User: ?1',
        'Sec-Fetch-Dest: document'
    ];

    $exec = function($url) use ($cStr, $headers) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_COOKIE, $cStr);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate, br'); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $html = curl_exec($ch);
        $info = curl_getinfo($ch);
        curl_close($ch);
        return ['html'=>$html, 'info'=>$info];
    };

    // 1. Try Homepage (Balance often in header)
    $target_url = "https://www.smile.one" . $region . "/";
    $res = $exec($target_url);
    
    // Check 1: Header coin-num
    if(preg_match('/class="coin-num"[^>]*>\s*([\d,]+)/i', $res['html'], $m)){
        return $m[1]." SC";
    }

    // 2. Try Customer Center
    $target_url2 = "https://www.smile.one" . $region . "/customer/center";
    $res2 = $exec($target_url2);
    
    // Check 2: Customer Center coin-num
    if(preg_match('/class="coin-num"[^>]*>\s*([\d,]+)/i', $res2['html'], $m)){
        return $m[1]." SC";
    }

    // 2b. Explicitly Try BR (Requested by user)
    if($region !== "/br"){
         $resBR = $exec("https://www.smile.one/br/customer/center");
         if(preg_match('/class="coin-num"[^>]*>\s*([\d,]+)/i', $resBR['html'], $m)){
            return $m[1]." SC (BR)";
         }
    }

    // 3. Fallback: Try Global Homepage if Region Failed (404/Redirect)
    if($region !== "" && ($res['info']['http_code'] == 404 || $res2['info']['http_code'] == 404)){
        $res3 = $exec("https://www.smile.one/");
        if(preg_match('/class="coin-num"[^>]*>\s*([\d,]+)/i', $res3['html'], $m)){
            return $m[1]." SC";
        }
        $lastHtml = $res3['html'];
        $lastCode = $res3['info']['http_code'];
        $lastUrl = "https://www.smile.one/";
    } else {
        $lastHtml = $res2['html'] ? $res2['html'] : $res['html'];
        $lastCode = $res2['info']['http_code'] ? $res2['info']['http_code'] : $res['info']['http_code'];
        $lastUrl = $res2['html'] ? $target_url2 : $target_url;
    }

    // Diagnostics
    if(strpos($lastHtml, 'login') !== false && strpos($lastHtml, 'customer/center') === false){
         // If we see 'login' text and we are NOT on the login page itself (which implies we were redirected there)
         return "Login Required";
    }
    
    $title = preg_match('/<title>(.*?)<\/title>/i', $lastHtml, $tm) ? $tm[1] : 'No Title';
    return "Fail: $title ($lastCode) URL: $lastUrl";
}

/* ===== BOT.PHP MANAGER ===== */
function ensure_backup_dir(){ @mkdir(BACKUP_DIR,0777,true); }
function backup_file($path){
  if(!file_exists($path)) return null;
  ensure_backup_dir();
  $bn=basename($path);
  $dst=BACKUP_DIR."/".$bn.".".date("Ymd_His").".bak";
  @copy($path,$dst);
  return $dst;
}
function looks_like_php($txt){
  $t=ltrim((string)$txt);
  return (stripos($t,"<?php")!==false); // simple check
}

/* ===== DOWNLOAD HISTORY (TXT) ===== */
if(isset($_GET['download_history'])){
  $h = jr(HFILE);
  $u = jr(UFILE);
  
  $rows = [];
  foreach($h as $cid=>$list){
    if(!is_array($list)) continue;
    foreach($list as $r){
      $r["cid"] = $cid;
      // Pre-calc user info
      $r["uName"] = $u[$cid]["name"] ?? ($u[$cid]["username"] ? "@".$u[$cid]["username"] : $cid);
      $rows[] = $r;
    }
  }

  // Sort descending by time
  usort($rows, function($a, $b){
     $t1 = DateTime::createFromFormat("H:i d.m.Y", $a["time"]??'');
     $t2 = DateTime::createFromFormat("H:i d.m.Y", $b["time"]??'');
     if(!$t1) return 1; if(!$t2) return -1;
     return $t2 <=> $t1;
  });

  // Prepare output
  header('Content-Type: text/plain; charset=utf-8');
  header('Content-Disposition: attachment; filename="history_'.date('Y-m-d_H-i').'.txt"');
  
  // Header
  echo sprintf("%-18s | %-10s | %-12s | %-20s | %-25s | %-12s | %s\n", 
               "Time", "Status", "User ID", "User", "Item", "Amount", "Info");
  echo str_repeat("-", 130) . "\n";

  foreach($rows as $r){
    $st = $r["status"] ?? "success";
    $isFail = ($st === "fail");
    $info = $isFail ? ($r["error"]??"") : ($r["sn"]??"");
    $item = $r["order"] ?? ($r["item"] ?? "-");
    $amt = number_format($r["amount"]??0);
    
    // Clean strings for text file (remove newlines/pipes)
    $cleanUser = str_replace(['|',"\n","\r"], '', $r["uName"]);
    $cleanItem = str_replace(['|',"\n","\r"], '', $item);
    $cleanInfo = str_replace(['|',"\n","\r"], ' ', $info);
    
    echo sprintf("%-18s | %-10s | %-12s | %-20s | %-25s | %-12s | %s\n",
      $r["time"]??"-",
      strtoupper($st),
      $r["cid"],
      mb_strimwidth($cleanUser, 0, 20, "..."),
      mb_strimwidth($cleanItem, 0, 25, "..."),
      $amt,
      $cleanInfo
    );
  }
  exit;
}

/* ===== INIT ===== */

if(isset($_POST["save_token"])){
  $nt = trim($_POST["new_token"]??"");
  if($nt && strlen($nt)>20){
    write_text_atomic(TOKEN_FILE, json_encode(["token"=>$nt]));
    
    // Update bot.php (Requested by user)
    if(file_exists(BOT_FILE)){
        $b_content = file_get_contents(BOT_FILE);
        // Replace $BOT="...";
        $pattern = '/\$BOT\s*=\s*"[^"]*"\s*;/';
        $replacement = '$BOT="'.$nt.'";';
        if(preg_match($pattern, $b_content)){
            $b_content = preg_replace($pattern, $replacement, $b_content);
            file_put_contents(BOT_FILE, $b_content);
        }
    }
    
    header("Location: ?view=api_keys"); exit;
  }
}

$users=jr(UFILE); if(!is_array($users)) $users=[];
$hist =jr(HFILE); if(!is_array($hist))  $hist=[];

$view=$_GET["view"]??"dashboard";
$q=trim($_GET["q"]??"");
$msg=""; $err=""; $info="";

/* ===== STATS ===== */
$todayStr = date("d.m.Y");
$stats = [
  "users" => count($users),
  "balance" => 0,
  "orders_total" => 0,
  "sales_total" => 0,
  "orders_today" => 0,
  "sales_today" => 0
];

$allOrders = [];

foreach($users as $u){
  $stats["balance"] += (float)($u["bal"]??0);
}

foreach($hist as $cid=>$orders){
  if(!is_array($orders)) continue;
  foreach($orders as $o){
    $stats["orders_total"]++;
    $amt = (float)($o["amount"]??0);
    $stats["sales_total"] += $amt;
    
    $o["cid"] = $cid;
    $ud = $users[$cid] ?? [];
    $o["u_name"] = $ud["username"] ? "@".$ud["username"] : ($ud["name"] ?? $cid);
    $allOrders[] = $o;
    
    $parts = explode(" ", $o["time"]??'');
    if(isset($parts[1]) && $parts[1]===$todayStr){
        $stats["orders_today"]++;
        $stats["sales_today"] += $amt;
    }
  }
}

usort($allOrders, function($a, $b){
    $t1 = DateTime::createFromFormat("H:i d.m.Y", $a["time"]??'');
    $t2 = DateTime::createFromFormat("H:i d.m.Y", $b["time"]??'');
    if(!$t1) return 1; if(!$t2) return -1;
    return $t2 <=> $t1;
});
$recentOrders = array_slice($allOrders, 0, 10);

/* ===== ACTIONS ===== */

/* Universal API Proxy Check */
if(isset($_POST['proxy_api_check'])){
    // Clean buffer to output only JSON
    if (ob_get_length()) ob_end_clean();
    header('Content-Type: application/json');

    $url = trim($_POST['url'] ?? '');
    $method = strtoupper(trim($_POST['method'] ?? 'GET'));
    $headersTxt = trim($_POST['headers'] ?? '');

    if(!$url){
        echo json_encode(['error' => 'URL missing']);
        exit;
    }

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    // If user provided a User-Agent in headers, it will be set below.
    // Otherwise, set a default one to avoid blocking.
    if(stripos($headersTxt, 'User-Agent') === false){
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64)");
    }

    if($method === 'POST'){
        curl_setopt($ch, CURLOPT_POST, true);
        // Simple POST support (no body input yet in UI, but ready)
    }

    if($headersTxt){
        $headers = [];
        $lines = explode("\n", $headersTxt);
        foreach($lines as $line){
            $t = trim($line);
            if($t) $headers[] = $t;
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    }

    $res = curl_exec($ch);
    $info = curl_getinfo($ch);
    $err = curl_error($ch);
    curl_close($ch);

    echo json_encode([
        'status_code' => $info['http_code'],
        'error' => $err,
        'response' => $res,
        'info' => $info
    ]);
    exit;
}

/* Balance + auto notify */
if(isset($_POST["add_bal"])){
  $cid=trim($_POST["cid"]??"");
  $amt=(int)($_POST["amt"]??0);
  if(!preg_match("/^\d{1,30}$/",$cid)) $err="User ID မမှန်ပါ";
  else{
    if(!isset($users[$cid])) $users[$cid]=["bal"=>0,"join"=>date("Y-m-d H:i:s")];
    $old=(int)($users[$cid]["bal"]??0);
    $new=max(0,$old+$amt);
    $users[$cid]["bal"]=$new;
    if(empty($users[$cid]["join"])) $users[$cid]["join"]=date("Y-m-d H:i:s");
    jw(UFILE,$users);

    $deltaTxt=($amt>=0?"+":"").ks(abs($amt));
    $nf = jr(NOTIFY_FOOTER_FILE);
    $footer = $nf['footer'] ?? "Thank U Very Much 💞!";
    $text="💰 <b>Wallet Update</b>\n━━━━━━━━━━━━━━\n🆔 <code>$cid</code>\nBalance Change Done : <b>$deltaTxt</b>\nOld: <b>".ks($old)."</b>\nNew: <b>".ks($new)."</b>\n\n".$footer;
    $doNotify=!empty($_POST["send_notify"]);
    if($doNotify) tg_text($cid,$text);

    $msg=$doNotify ? "Balance Updated ✅ ($cid, notified)" : "Balance Updated ✅ ($cid)";
  }
}

if(isset($_POST["add_bal_all"])){
  $amt=(int)($_POST["amt_all"]??0);
  $bonus=(float)($_POST["bonus_percent_all"]??0);
  $doNotify=!empty($_POST["send_notify_all"]);
  $count=0;
  foreach($users as $cid=>$ud){
    $old=(int)($ud["bal"]??0);
    $delta = $amt + ($amt * $bonus / 100.0);
    $new=max(0,$old+$delta);
    $users[$cid]["bal"]=$new;
    if(empty($users[$cid]["join"])) $users[$cid]["join"]=date("Y-m-d H:i:s");
    $count++;
    if($doNotify){
      $deltaTxt=($delta>=0?"+":"").ks(abs($delta));
      $nf = jr(NOTIFY_FOOTER_FILE);
      $footer = $nf['footer'] ?? "🙏 🙏 အားပေးမှု အတွက်ကျေးဇူးပါရှင့် 💞!";
      $text="💰 <b>Wallet Update</b>\n━━━━━━━━━━━━━━\n🆔 <code>$cid</code>\nBalance Change Done : <b>$deltaTxt</b>\nOld: <b>".ks($old)."</b>\nNew: <b>".ks($new)."</b>\n\n".$footer;
      tg_text($cid,$text);
    }
  }
  jw(UFILE,$users);
  $msg = $doNotify ? "Applied to ALL users ✅ ($count, notified)" : "Applied to ALL users ✅ ($count)";
}

if(isset($_POST["deduct_all_bal"])){
  $cid=trim($_POST["cid"]??"");
  if(!preg_match("/^\d{1,30}$/",$cid)) $err="User ID မမှန်ပါ";
  else{
    if(!isset($users[$cid])) $users[$cid]=["bal"=>0,"join"=>date("Y-m-d H:i:s")];
    $old=(int)($users[$cid]["bal"]??0);
    $new=0;
    $users[$cid]["bal"]=$new;
    if(empty($users[$cid]["join"])) $users[$cid]["join"]=date("Y-m-d H:i:s");
    jw(UFILE,$users);
    $deltaTxt="-".ks(abs($old));
    $nf = jr(NOTIFY_FOOTER_FILE);
    $footer = $nf['footer'] ?? "🙏 🙏 အားပေးမှု အတွက်ကျေးဇူးပါရှင့် 💞!";
    $text="💰 <b>Wallet Update</b>\n━━━━━━━━━━━━━━\n🆔 <code>$cid</code>\nBalance Change Done : <b>$deltaTxt</b>\nOld: <b>".ks($old)."</b>\nNew: <b>".ks($new)."</b>\n\n".$footer;
    $doNotify=!empty($_POST["send_notify"]);
    if($doNotify) tg_text($cid,$text);
    $msg=$doNotify ? "Deducted ALL balance ✅ ($cid, notified)" : "Deducted ALL balance ✅ ($cid)";
  }
}

if(isset($_POST["toggle_ban"])){
  $cid=trim($_POST["cid"]??"");
  if(!preg_match("/^\d{1,30}$/",$cid)) $err="User ID Invalid";
  else{
    if(!isset($users[$cid])) $users[$cid]=["bal"=>0,"join"=>date("Y-m-d H:i:s")];
    $isBanned = !empty($users[$cid]["banned"]);
    $users[$cid]["banned"] = !$isBanned;
    jw(UFILE,$users);
    $msg = $users[$cid]["banned"] ? "User BANNED ⛔ ($cid)" : "User UNBANNED ✅ ($cid)";
  }
}

/* Save prices */
if(isset($_POST["save_price"])){
  $file=$_POST["file"]??"";
  $json=trim($_POST["json"]??"");
  $arr=@json_decode($json,true);
  if(!$file) $err="File missing";
  elseif(!is_array($arr)) $err="JSON မမှန်ပါ";
  else{ jw($file,$arr); $msg="Saved ✅"; }
}

/* Save Topup Codes */
if(isset($_POST["save_topup_codes"])){
    $json = trim($_POST["topup_codes_json"] ?? "");
    $arr = @json_decode($json, true);
    if(!is_array($arr)){
        $err = "Invalid JSON format for Topup Codes";
    } else {
        jw(TOPUP_CODES_FILE, $arr);
        $msg = "Topup Codes Saved ✅";
    }
}

/* Generate Topup Codes */
if(isset($_POST['gen_code_amount']) && isset($_POST['gen_code_qty'])){
    $amt = (int)$_POST['gen_code_amount'];
    $qty = (int)$_POST['gen_code_qty'];
    if($amt > 0 && $qty > 0){
        $codes = jr(TOPUP_CODES_FILE);
        $count = 0;
        for($i=0; $i<$qty; $i++){
            $code = strtoupper(substr(md5(uniqid(rand(), true)), 0, 10));
            $codes[$code] = ["amount" => $amt];
            $count++;
        }
        jw(TOPUP_CODES_FILE, $codes);
        $msg = "Generated $count codes of ".ks($amt)." ✅";
    } else {
        $err = "Invalid amount or quantity";
    }
}

/* Notify one */
if(isset($_POST["notify_one"])){
  $cid=trim($_POST["n_cid"]??"");
  $text=trim($_POST["n_text"]??"");
  $imgUrl=trim($_POST["n_img_url"]??"");
  $imgTmp=null;

  if(!empty($_FILES["n_img_file"]["tmp_name"]) && is_uploaded_file($_FILES["n_img_file"]["tmp_name"])){
    $sz=(int)($_FILES["n_img_file"]["size"]??0);
    if($sz>MAX_IMG_MB*1024*1024) $err="Image too large (max ".MAX_IMG_MB."MB)";
    else $imgTmp=$_FILES["n_img_file"]["tmp_name"];
  }
  if(!$err){
    if($cid===""||!preg_match("/^\d+$/",$cid)) $err="User ID မမှန်ပါ";
    elseif($text==="" && $imgUrl==="" && !$imgTmp) $err="Message သို့ Photo ထည့်ပါ";
    else{
      $r=tg_send_any($cid,$text,$imgUrl,$imgTmp);
      if(!empty($r["ok"])) $msg="Notify sent ✅ ($cid)";
      else $err="Notify failed ($cid): ".h($r["description"]??"send_failed");
    }
  }
}

/* Broadcast all */
$fails=[];
if(isset($_POST["broadcast_all"])){
  $text=trim($_POST["b_text"]??"");
  $imgUrl=trim($_POST["b_img_url"]??"");
  $delay=(int)($_POST["b_delay"]??BC_DELAY_MS);
  if($delay<0) $delay=0; if($delay>2000) $delay=2000;

  $imgTmp=null; $shared=null;
  if(!empty($_FILES["b_img_file"]["tmp_name"]) && is_uploaded_file($_FILES["b_img_file"]["tmp_name"])){
    $sz=(int)($_FILES["b_img_file"]["size"]??0);
    if($sz>MAX_IMG_MB*1024*1024) $err="Image too large (max ".MAX_IMG_MB."MB)";
    else $imgTmp=$_FILES["b_img_file"]["tmp_name"];
  }

  if(!$err){
    if(!$users) $err="users မရှိသေးပါ";
    elseif($text==="" && $imgUrl==="" && !$imgTmp) $err="Message သို့ Photo ထည့်ပါ";
    else{
      if(!$imgTmp && $imgUrl!==""){ $e=null; $shared=dl_tmp($imgUrl,$e); if(!$shared) $err="Image download failed: ".$e; }
      if(!$err){
        $ok=0;$fail=0;
        foreach(array_keys($users) as $cid){
          if(!preg_match("/^\d+$/",$cid)) continue;
          $useFile=$imgTmp?:$shared;
          $r=tg_send_any($cid,$text,"",$useFile);
          if(!empty($r["ok"])) $ok++;
          else{ $fail++; $fails[]=["cid"=>$cid,"desc"=>$r["description"]??"send_failed"]; }
          usleep($delay*1000);
        }
        if($shared) @unlink($shared);
        $info="Broadcast DONE ✅ | OK:$ok FAIL:$fail TOTAL:".count($users);
      }
    }
  }
}

/* ===== NEW: COOKIES EDITOR ===== */
if(isset($_POST["check_cookies"])){
  $res = get_smile_balance(); // This returns string like "120 SC" or "Login Fail"
  if(strpos($res, "SC") !== false || strpos($res, "Coins") !== false){
    $msg = "Connection Successful! Balance: " . $res . " ✅";
  } else {
    $err = "Connection Failed: " . $res . " ❌ (Cookies might be expired or invalid)";
    
    // Detailed Debug
    if(file_exists(COOKIES_FILE)){
        $cok = @file_get_contents(COOKIES_FILE);
        $cookies = @json_decode($cok, true);
        if(is_array($cookies)){
            $cStr = "";
            foreach($cookies as $k=>$v){
                if(is_array($v) && isset($v['name']) && isset($v['value'])) $cStr .= $v['name']."=".$v['value']."; ";
                elseif(!is_int($k) && is_scalar($v)) $cStr .= "$k=$v; ";
            }
            $ch = curl_init("https://www.smile.one/customer/center");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_COOKIE, $cStr);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36");
            curl_setopt($ch, CURLOPT_HEADER, true); // Capture headers
            $raw = curl_exec($ch);
            $info = curl_getinfo($ch);
            curl_close($ch);
            
            $header_size = $info['header_size'];
            $header = substr($raw, 0, $header_size);
            $body = substr($raw, $header_size);
            
            // Analyze
            $debug_info = "HTTP Code: " . $info['http_code'] . "\n";
            $debug_info .= "Redirect URL: " . ($info['redirect_url'] ?? 'None') . "\n";
            $debug_info .= "Title: " . (preg_match('/<title>(.*?)<\/title>/i', $body, $m) ? $m[1] : 'Not found') . "\n";
            if(strpos($body, 'login') !== false) $debug_info .= "Page contains 'login' text (Likely redirected)\n";
            if(strpos($body, 'Just a moment') !== false) $debug_info .= "Cloudflare Challenge Detected\n";
            
            $err .= "\n\nDebug Info:\n" . $debug_info;
        }
    }
  }
}

if(isset($_POST["save_cookies"])){
  $txt = trim($_POST["cookies_text"]??"");
  if($txt===""){
    $err = "Cookies content empty";
  } elseif(json_decode($txt)===null){
    $err = "Invalid JSON format";
  } else {
    // Backup
    if(file_exists(COOKIES_FILE)){
      @mkdir(BACKUP_COK_DIR, 0777, true);
      $bk = BACKUP_COK_DIR . "/cookies_" . date("Ymd_His") . ".json";
      @copy(COOKIES_FILE, $bk);
    }
    // Save
    if(write_text_atomic(COOKIES_FILE, $txt)){
      $msg = "Cookies saved & backed up ✅";
    } else {
      $err = "Failed to save cookies";
    }
  }
}

/* ===== COOKIE STATUS CHECKER ===== */
if(isset($_POST["check_cookies_status"])){
    $res = get_smile_balance();
    if(strpos($res, "SC") !== false){
        $cookie_status = "ACTIVE";
        $cookie_class = "ok";
        $cookie_bal = $res;
        $cookie_msg = "Cookies are working! Region check complete.";
    } else {
        $cookie_status = "EXPIRED";
        $cookie_class = "err";
        $cookie_bal = "Error";
        $cookie_msg = "Cookies are invalid or expired. ($res)";
    }
}

/* ===== SETTINGS: SUPPORT ADMINS ===== */
if(isset($_POST['add_support_admin'])){
    $new_id = trim($_POST['new_admin_id']);
    if($new_id){
        $admins = jr(SUPPORT_ADMINS_FILE);
        if(!in_array($new_id, $admins)){
            $admins[] = $new_id;
            jw(SUPPORT_ADMINS_FILE, $admins);
            $msg = "Support Admin ID added!";
        } else {
            $err = "ID already exists!";
        }
    }
}
if(isset($_POST['del_support_admin'])){
    $del_id = $_POST['del_support_admin'];
    $admins = jr(SUPPORT_ADMINS_FILE);
    $key = array_search($del_id, $admins);
    if($key !== false){
        unset($admins[$key]);
        jw(SUPPORT_ADMINS_FILE, array_values($admins));
        $msg = "Support Admin ID removed!";
    }
}

/* Change Password */
if(isset($_POST['change_pass'])){
  $old = $_POST['old_pass'] ?? '';
  $new = $_POST['new_pass'] ?? '';
  
  $storedData = @json_decode(@file_get_contents(PASSWORD_FILE), true);
  $currentPass = $storedData['password'] ?? 'AutoBot2025';

  if($old !== $currentPass){
    $err = "Old password incorrect!";
  } elseif(empty($new)){
    $err = "New password cannot be empty!";
  } else {
    jw(PASSWORD_FILE, ["password" => $new]);
    $msg = "Password updated successfully! ✅";
  }
}

/* ===== NEW: SMILE.PHP EDITOR ===== */
if(isset($_POST["save_smile"])){
  $txt = trim($_POST["smile_text"]??"");
  if($txt===""){
    $err = "smile.php content empty";
  } elseif(!looks_like_php($txt)){
    $err = "Content must be valid PHP (<?php)";
  } else {
    // Backup
    if(file_exists(SMILE_FILE)){
      @mkdir(BACKUP_SMILE_DIR, 0777, true);
      $bk = BACKUP_SMILE_DIR . "/smile_" . date("Ymd_His") . ".php";
      @copy(SMILE_FILE, $bk);
    }
    // Save
    if(write_text_atomic(SMILE_FILE, $txt)){
      $msg = "smile.php saved & backed up ✅";
    } else {
      $err = "Failed to save smile.php";
    }
  }
}

/* ===== NEW: SMILE API URL EDITOR ===== */
if(isset($_POST["save_smile_api_url"])){
    $url = trim($_POST["smile_api_url"] ?? "");
    if(empty($url)){
        $err = "API URL cannot be empty!";
    } else {
        // Backup
        if(file_exists(SMILE_API_CONFIG_FILE)){
            @mkdir(BACKUP_SMILE_API_DIR, 0777, true);
            $bk = BACKUP_SMILE_API_DIR . "/api_url_" . date("Ymd_His") . ".json";
            @copy(SMILE_API_CONFIG_FILE, $bk);
        }
        
        // Save
        $data = ["url" => $url];
        if(write_text_atomic(SMILE_API_CONFIG_FILE, json_encode($data, JSON_PRETTY_PRINT))){
            $msg = "API URL saved & backed up ✅";
        } else {
            $err = "Failed to save API URL";
        }
    }
}

/* ===== NEW: INDEX.PHP (BOT APP) EDITOR ===== */
if(isset($_POST["save_app"])){
  $txt = trim($_POST["app_text"]??"");
  if($txt===""){
    $err = "index.php content empty";
  } elseif(!looks_like_php($txt)){
    $err = "Content must be valid PHP (<?php)";
  } else {
    // Backup
    if(file_exists(INDEX_FILE)){
      @mkdir(BACKUP_APP_DIR, 0777, true);
      $bk = BACKUP_APP_DIR . "/index_" . date("Ymd_His") . ".php";
      @copy(INDEX_FILE, $bk);
    }
    // Save
    if(write_text_atomic(INDEX_FILE, $txt)){
      $msg = "index.php saved & backed up ✅";
    } else {
      $err = "Failed to save index.php";
    }
  }
}

/* ===== NEW: BOT.PHP UPDATE (Upload / Edit) ===== */
if(isset($_POST["bot_save_text"])){
  $txt=(string)($_POST["bot_text"]??"");
  if(trim($txt)==="") $err="bot.php content empty";
  elseif(!looks_like_php($txt)) $err="PHP code မဟုတ်သလိုပဲ (<?php မတွေ့ဘူး)";
  else{
    backup_file(BOT_FILE);
    write_text_atomic(BOT_FILE,$txt);
    $msg="bot.php saved ✅";
  }
}
if(isset($_POST["bot_upload_file"])){
  if(empty($_FILES["bot_file"]["tmp_name"]) || !is_uploaded_file($_FILES["bot_file"]["tmp_name"])) $err="Upload file မတွေ့ဘူး";
  else{
    $sz=(int)($_FILES["bot_file"]["size"]??0);
    if($sz > MAX_PHP_MB*1024*1024) $err="bot.php too large (max ".MAX_PHP_MB."MB)";
    else{
      $raw=@file_get_contents($_FILES["bot_file"]["tmp_name"]);
      if(!$raw || !looks_like_php($raw)) $err="Upload ဖိုင်က PHP မဟုတ်သလိုပဲ";
      else{
        backup_file(BOT_FILE);
        write_text_atomic(BOT_FILE,$raw);
        $msg="bot.php upload saved ✅";
      }
    }
  }
}

/* ===== VPS MANAGER ===== */
/*
if(isset($_POST['save_vps_key'])){
    $k = trim($_POST['vps_key']);
    $ip = trim($_POST['vps_ip']);
    
    if($k){
        $cur = jr(VPS_FILE);
        $cur['api_key'] = $k;
        $cur['vps_ip'] = $ip;
        jw(VPS_FILE, $cur);
        $msg = "VPS Settings saved! ✅";
    } else {
        $err = "API Key cannot be empty!";
    }
}

if(isset($_POST['change_vps_pass'])){
    $new_pass = trim($_POST['vps_new_pass']);
    if(strlen($new_pass) < 8){
        $err = "Password must be at least 8 chars!";
    } else {
        $cur = jr(VPS_FILE);
        $cur['vps_pass'] = $new_pass;
        jw(VPS_FILE, $cur);
        
        // Mock API Call
        $msg = "VPS Password change request sent! (Simulated) ✅";
    }
}
*/

/* ===== NEW: TOPUP MSG EDITOR ===== */
if(isset($_POST["save_topup_msg"])){
  $txt = trim($_POST["topup_msg_text"]??"");
  if($txt===""){
    $err = "TopUp message cannot be empty";
  } else {
    $data = ["message" => $txt];
    jw(TOPUP_MSG_FILE, $data);
    $msg = "TopUp message saved ✅";
  }
}

if(isset($_POST["save_balance_msg"])){
  $txt = trim($_POST["balance_msg_text"]??"");
  // Allow empty to clear it
  $data = ["message" => $txt];
  jw(BALANCE_MSG_FILE, $data);
  $msg = "Balance message saved ✅";
}

if(isset($_POST["save_notify_msg"])){
  $txt = trim($_POST["notify_msg_text"]??"");
  $data = ["message" => $txt];
  jw(NOTIFY_MSG_FILE, $data);
  $msg = "Notify message saved ✅";
}

if(isset($_POST["clear_notify_msg"])){
  @unlink(NOTIFY_MSG_FILE);
  $msg = "Notify message deleted 🗑";
}

if(isset($_POST["save_notify_footer"])){
  $txt = trim($_POST["notify_footer_text"]??"");
  $data = ["footer" => $txt];
  jw(NOTIFY_FOOTER_FILE, $data);
  $msg = "Notify footer saved ✅";
}

if(isset($_POST["clear_notify_footer"])){
  @unlink(NOTIFY_FOOTER_FILE);
  $msg = "Notify footer deleted 🗑";
}

/* ===== NEW: PAYMENT METHODS ===== */
if(isset($_POST['add_payment_method'])){
    $pm_name = trim($_POST['pm_name']??"");
    $pm_no = trim($_POST['pm_no']??"");
    $pm_acc_name = trim($_POST['pm_acc_name']??"");
    $pm_note = trim($_POST['pm_note']??"");
    
    if($pm_name && $pm_no){
        $pms = jr(PAYMENT_METHODS_FILE);
        $pms[] = [
            "id" => uniqid(),
            "name" => $pm_name,
            "no" => $pm_no,
            "acc_name" => $pm_acc_name,
            "note" => $pm_note
        ];
        jw(PAYMENT_METHODS_FILE, $pms);
        $msg = "Payment method added! ✅";
    } else {
        $err = "Method Name and Number are required!";
    }
}

if(isset($_POST['del_payment_method'])){
    $del_id = $_POST['del_id'];
    $pms = jr(PAYMENT_METHODS_FILE);
    $new_pms = [];
    foreach($pms as $p){
        if(($p['id']??"") !== $del_id) $new_pms[] = $p;
    }
    jw(PAYMENT_METHODS_FILE, $new_pms);
    $msg = "Payment method deleted! 🗑";
}

/* ===== NEW: LOGS ===== */
if(isset($_POST["clear_logs"])){
  file_put_contents(__DIR__."/smile_debug.log", "");
  $msg = "Logs cleared ✅";
}

/* ===== NEW: SAI API KEY MANAGER ===== */
if(isset($_POST["save_api_keys"])){
    $sai_key = trim($_POST["sai_api_key"]??"");
    if($sai_key === ""){
        $err = "API Key cannot be empty";
    } else {
        // Backup
        if(file_exists(SAI_KEY_FILE)){
            @mkdir(BACKUP_SAI_DIR, 0777, true);
            $bk = BACKUP_SAI_DIR . "/sai_key_" . date("Ymd_His") . ".json";
            @copy(SAI_KEY_FILE, $bk);
        }
        
        // Save
        $data = ["key" => $sai_key];
        jw(SAI_KEY_FILE, $data);
        $msg = "API Key saved & backed up ✅";
    }
}

/* ===== LOAD UI TEXT ===== */
$tm_data = jr(TOPUP_MSG_FILE);
$topup_msg_now = $tm_data['message'] ?? "";

$bm_data = jr(BALANCE_MSG_FILE);
$balance_msg_now = $bm_data['message'] ?? "";

$nm_data = jr(NOTIFY_MSG_FILE);
$notify_msg_now = $nm_data['message'] ?? "";

$nf_data = jr(NOTIFY_FOOTER_FILE);
$notify_footer_now = $nf_data['footer'] ?? "🙏 🙏 အားပေးမှု အတွက်ကျေးဇူးပါရှင့် 💞!";

$pms_now = jr(PAYMENT_METHODS_FILE);

$ml = read_text(ML_FILE);
$uc = read_text(PUBG_UC_FILE);
$pc = read_text(PUBG_CODE_FILE);
$cookies_now = read_text(COOKIES_FILE, "[]");
$smile_now = file_exists(SMILE_FILE) ? (string)file_get_contents(SMILE_FILE) : "<?php\n// smile.php not found\n";
$bot_now = file_exists(BOT_FILE) ? (string)file_get_contents(BOT_FILE) : "<?php\n// bot.php not found\n";
$app_now = file_exists(INDEX_FILE) ? (string)file_get_contents(INDEX_FILE) : "<?php\n// index.php not found\n";

$warn=[];
if(!file_exists(ML_FILE))        $warn[]="prices.json (ML) not found";
if(!file_exists(PUBG_UC_FILE))   $warn[]="pubg_prices.json (UC) not found";
if(!file_exists(PUBG_CODE_FILE)) $warn[]="pubg_code_prices.json (CODE) not found";
if(!file_exists(COOKIES_FILE))   $warn[]="cookies.json not found";
if(!file_exists(SMILE_FILE))     $warn[]="smile.php not found";
if(!file_exists(BOT_FILE))       $warn[]="bot.php not found";

$tabs=[
  "dashboard"=>"<span class='e'>📊</span> Dashboard",
  "users"=>"<span class='e'>👤</span> Users",
  "admin_manager"=>"<span class='e'>🛠</span> Admin Manager",
  "history"=>"<span class='e'>📜</span> History",
  "logs"=>"<span class='e'>📝</span> Smile API Logs",
  "calculator"=>"<span class='e'>🧮</span> Calculator",
  "settings"=>"<span class='e'>⚙️</span> Settings",
  "theme"=>"<span class='e'>🎨</span> Theme Manager",
  "topup_codes"=>"<span class='e'>🎫</span> Topup Codes",
  "bot_menu"=>"<span class='e'>🤖</span> Bot Menu"
];

$theme = file_exists(THEME_FILE) ? json_decode(file_get_contents(THEME_FILE), true) : [
    "p" => "#E91E63", "p_dim" => "#C2185B", "bg" => "#121212", 
    "panel" => "#1E1E1E", "text" => "#F8BBD0", "border" => "#333333", 
    "shadow" => "0 4px 20px rgba(233, 30, 99, 0.15)"
];
?>
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin</title>
<style>
/* DYNAMIC THEME */
@import url('https://fonts.googleapis.com/css2?family=Fredoka:wght@300;400;600&display=swap');

:root{
  --p: <?= $theme['p'] ?? '#E91E63' ?>;
  --p-dim: <?= $theme['p_dim'] ?? '#C2185B' ?>;
  --bg: <?= $theme['bg'] ?? '#121212' ?>;
  --bg-2: <?= isset($theme['bg']) ? hex2rgba($theme['bg'], 0.5) : '#1A1A1A' ?>;
  --panel: <?= $theme['panel'] ?? '#1E1E1E' ?>;
  --border: <?= $theme['border'] ?? '#333333' ?>;
  --text: <?= $theme['text'] ?? '#F8BBD0' ?>;
  --text-dim: <?= isset($theme['text']) ? hex2rgba($theme['text'], 0.7) : '#F48FB1' ?>;
  --shadow: <?= $theme['shadow'] ?? '0 4px 20px rgba(233, 30, 99, 0.15)' ?>;
}

*{
  box-sizing:border-box;
  -webkit-tap-highlight-color: transparent;
}

body{
  margin:0;
  font-family: 'Roboto', sans-serif;
  background-color: var(--bg);
  background-image: 
    radial-gradient(#880E4F 15%, transparent 16%),
    radial-gradient(#880E4F 15%, transparent 16%);
  background-size: 30px 30px;
  background-position: 0 0, 15px 15px;
  color: var(--text);
}

a{color:var(--p);text-decoration:none; transition:0.3s; font-weight:600}
a:hover{color:#FF4081; text-shadow:0 2px 5px rgba(255, 64, 129, 0.3)}
a:active{transform: scale(0.95);}

/* Button Touch Effects */
button, .btn, .btn-sm, .page-btn, .tab, .modal-btn, .custom-select-trigger {
  cursor: pointer;
  touch-action: manipulation;
  user-select: none;
  transition: transform 0.1s, background 0.2s, box-shadow 0.2s !important;
}

button:active, .btn:active, .btn-sm:active, .page-btn:active, .tab:active, .modal-btn:active, .custom-select-trigger:active {
  transform: scale(0.95) !important;
  box-shadow: 0 2px 10px rgba(0,0,0,0.1) !important;
}

.card, .stat-card, .user-preview {
  transition: transform 0.3s, box-shadow 0.3s;
}
.card:active, .stat-card:active, .user-preview:active {
  transform: scale(0.98);
}

/* Input Focus Effects */
input:focus, textarea:focus, select:focus {
  transform: scale(1.01);
}


.top{
  position:sticky; top:0; z-index:99;
  background: rgba(30, 30, 30, 0.85); /* Glass Dark */
  backdrop-filter: blur(15px);
  -webkit-backdrop-filter: blur(15px);
  border-bottom: 1px solid rgba(233, 30, 99, 0.2);
  padding:15px;
  box-shadow: var(--shadow);
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.brand{display:flex;align-items:center;gap:15px}
.dot{
  width:15px; height:15px; background:var(--p);
  border-radius: 50%;
  box-shadow: 0 0 10px var(--p);
  animation: pulse 2s infinite;
}
@keyframes pulse { 0%{transform:scale(1)} 50%{transform:scale(1.2)} 100%{transform:scale(1)} }

.mini{opacity:.7;font-size:13px; letter-spacing:0.5px}

.wrap{
  max-width: 1200px;
  width: 95%;
  margin: auto;
  padding: 25px 0;
}

.tabbar{display:flex;flex-wrap:wrap;gap:10px;margin-top:0;}
.tab{
  padding:10px 20px;
  background: var(--panel);
  border: 1px solid var(--border);
  color: var(--text);
  border-radius: 50px;
  font-weight: 500;
  transition: 0.3s;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
}
.tab:hover{
  background: var(--p);
  color: white;
  transform: translateY(-2px);
  border-color: var(--p);
}
.tab.act{
  background: var(--p);
  color: white;
  border-color: var(--p);
  box-shadow: 0 5px 15px rgba(233, 30, 99, 0.4);
}

/* Responsive */
@media (max-width: 900px) {
  .menu-btn { display: none !important; }
  .tabbar { display: none !important; }
  .mobile-nav-select { display: block !important; }
  .row { grid-template-columns: 1fr !important; }
  .stat-grid { grid-template-columns: 1fr 1fr; }
  .top { padding-bottom: 5px; flex-wrap: wrap; }
  .brand { width: 100%; margin-bottom: 10px; justify-content: center; }
}


@keyframes fadeInMenu { from { opacity: 0; } to { opacity: 1; } }
@keyframes slideInTab { 
  from { opacity: 0; transform: translateY(20px); } 
  to { opacity: 1; transform: translateY(0); } 
}


@media (max-width: 480px) {
  .stat-grid { grid-template-columns: 1fr; }
}

@keyframes slideDown {
  from { opacity: 0; transform: translateY(-10px); }
  to { opacity: 1; transform: translateY(0); }
}

/* User Preview Card */
.user-preview {
  display: flex;
  align-items: center;
  gap: 15px;
  background: #2C2C2C;
  padding: 15px;
  border-radius: 15px;
  margin-top: 10px;
  border: 1px dashed var(--p);
  animation: fadeIn 0.3s ease;
}
@keyframes fadeIn { from{opacity:0;transform:translateY(5px)} to{opacity:1;transform:translateY(0)} }

.user-preview .avatar {
  min-width: 50px; width: 50px; height: 50px;
  background: var(--p);
  color: #fff;
  border-radius: 50%;
  display: flex; align-items: center; justify-content: center;
  font-size: 24px;
  font-weight: bold;
  box-shadow: 0 4px 10px rgba(233, 30, 99, 0.3);
}
.user-preview .details { display: flex; flex-direction: column; }
.user-preview .name { font-weight: bold; font-size: 16px; color: var(--p); }
.user-preview .sub { font-size: 13px; opacity: 0.8; color: var(--text); }

/* Table Responsive Wrapper */
.table-wrap { 
  overflow-x: auto; 
  -webkit-overflow-scrolling: touch; 
  border-radius: 15px;
}

/* Small Action Buttons */
.btn-sm {
  padding: 6px 14px;
  font-size: 12px;
  border-radius: 20px;
  display: inline-block;
  margin: 2px;
  text-decoration: none !important;
  color: white !important;
  font-weight: bold;
  box-shadow: 0 3px 6px rgba(0,0,0,0.1);
  transition: 0.2s;
}
.btn-sm:hover { transform: translateY(-2px); box-shadow: 0 5px 10px rgba(0,0,0,0.2); }
.btn-sm.blue { background: var(--p); }
.btn-sm.orange { background: var(--p-dim); }
.btn-sm.red { background: linear-gradient(45deg, #f44336, #e57373); }
.btn-sm.green { background: linear-gradient(45deg, #4CAF50, #81C784); }

.card{
  background: var(--panel);
  border-radius: 25px;
  padding: 25px;
  margin: 20px 0;
  box-shadow: var(--shadow);
  border: 1px solid #333;
}

/* Custom Select */
.custom-select-wrapper {
  position: relative;
  display: block;
  width: 100%;
}
.custom-select-wrapper select {
  width: 100%;
  padding: 12px 15px;
  border-radius: 12px;
  border: 2px solid var(--border);
  background: #2C2C2C;
  color: var(--text);
  font-size: 15px;
  font-weight: 600;
  appearance: none;
  cursor: pointer;
  transition: 0.3s;
  outline: none;
}
.custom-select-wrapper::after {
  content: '▼';
  font-size: 12px;
  color: var(--p);
  position: absolute;
  right: 15px;
  top: 50%;
  transform: translateY(-50%);
  pointer-events: none;
}
.custom-select-wrapper select:hover {
  border-color: var(--p);
  box-shadow: 0 4px 10px rgba(233, 30, 99, 0.15);
}

/* Beautiful Modal */
.modal-overlay {
  position: fixed; top: 0; left: 0; width: 100%; height: 100%;
  background: rgba(0,0,0,0.8);
  backdrop-filter: blur(8px);
  z-index: 1000;
  display: none;
  justify-content: center;
  align-items: center;
  opacity: 0;
  transition: opacity 0.3s;
}
.modal-overlay.show { display: flex; opacity: 1; }
.modal-box {
  background: #1E1E1E;
  padding: 30px;
  border-radius: 25px;
  width: 90%;
  max-width: 400px;
  text-align: center;
  box-shadow: 0 20px 50px rgba(0,0,0,0.5);
  transform: scale(0.9);
  transition: transform 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
}
.modal-overlay.show .modal-box { transform: scale(1); }
.modal-icon { font-size: 40px; margin-bottom: 15px; animation: pop 0.5s; }
@keyframes pop { 0%{transform:scale(0)} 80%{transform:scale(1.2)} 100%{transform:scale(1)} }
.modal-title { font-size: 22px; font-weight: bold; color: var(--p); margin-bottom: 10px; }
.modal-desc { font-size: 16px; color: #BBB; margin-bottom: 25px; line-height: 1.6; }
.modal-btns { display: flex; gap: 15px; justify-content: center; }
.modal-btn { flex: 1; padding: 12px; border-radius: 50px; font-weight: bold; cursor: pointer; border: none; transition: 0.2s; font-size: 15px; }
.modal-btn.yes { background: var(--p); color: #fff; box-shadow: 0 4px 15px rgba(233, 30, 99, 0.4); }
.modal-btn.yes:hover { background: var(--p-dim); transform: translateY(-2px); }
.modal-btn.no { background: #333; color: #DDD; }
.modal-btn.no:hover { background: #444; }

/* Custom Select with Images */
.mobile-nav-select { display: none; margin-bottom: 20px; }
.custom-select-container { position: relative; width: 100%; font-family: 'Fredoka', sans-serif; user-select: none; }
.custom-select-trigger { 
  background: rgba(44, 44, 44, 0.6);
  backdrop-filter: blur(10px);
  -webkit-backdrop-filter: blur(10px);
  border: 1px solid rgba(233, 30, 99, 0.3);
  border-radius: 12px; padding: 12px; display: flex; align-items: center; cursor: pointer; transition: all 0.3s; color: var(--text); 
  box-shadow: 0 0 15px rgba(233, 30, 99, 0.1);
}
.custom-select-trigger:hover { border-color: var(--p); box-shadow: 0 0 20px rgba(233, 30, 99, 0.3); }
.custom-select-trigger img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; object-fit: cover; border: 1px solid #555; }
.custom-select-trigger span { font-weight: 600; color: var(--text); flex-grow: 1; font-size: 15px; }
.custom-select-trigger .arrow { color: #AAA; font-size: 12px; transition: transform 0.3s; }
.custom-options { position: absolute; top: 115%; left: 0; right: 0; background: #2C2C2C; border: 2px solid var(--border); border-radius: 12px; box-shadow: 0 8px 24px rgba(0,0,0,0.3); opacity: 0; visibility: hidden; transform: translateY(-10px); transition: all 0.3s; z-index: 100; overflow-y: auto; max-height: 60vh; }
.custom-options.open { opacity: 1; visibility: visible; transform: translateY(0); }
.custom-option { padding: 12px; display: flex; align-items: center; cursor: pointer; transition: background 0.2s; border-bottom: 1px solid #333; color: var(--text); }
.custom-option:last-child { border-bottom: none; }
.custom-option:hover { background: #333; }
.custom-option img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; border: 1px solid #555; }
.custom-option.selected { background: #333; font-weight: bold; color: var(--p); }
.custom-select-container.active .arrow { transform: rotate(180deg); }

h3{
  margin:0 0 20px 0;
  color: var(--p);
  text-shadow: 0 0 10px rgba(233, 30, 99, 0.4);
  font-size: 24px;
  border-bottom: 2px dashed var(--border);
  padding-bottom: 10px;
  text-align: center;
}

input,textarea,button,select{
  width:100%; padding:15px;
  background: #2C2C2C;
  border: 2px solid var(--border);
  color: var(--text);
  font-family: inherit;
  font-size: 15px;
  outline: none;
  margin-bottom: 10px;
  border-radius: 15px;
  transition: 0.3s;
}
input:focus,textarea:focus,select:focus{
  border-color: var(--p);
  box-shadow: 0 0 0 4px rgba(233, 30, 99, 0.2);
}

/* Flexible Row for Inputs */
.row {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
}
.row > * {
  flex: 1 1 300px;
}

.btn {
  background: var(--p);
  color: white; /* Changed from black to white */
  border: none;
  font-weight: bold;
  cursor: pointer;
  letter-spacing: 1px;
  border-radius: 50px;
  box-shadow: 0 5px 15px rgba(233, 30, 99, 0.4);
}
.btn:hover{
  background: var(--p-dim);
  transform: translateY(-3px);
  box-shadow: 0 8px 20px rgba(136, 14, 79, 0.5);
}

.btn-back {
  display: inline-flex;
  align-items: center;
  gap: 8px;
  background: transparent;
  color: var(--p);
  border: 2px solid var(--p);
  padding: 10px 20px;
  border-radius: 50px;
  text-decoration: none;
  font-weight: bold;
  font-size: 14px;
  transition: all 0.3s ease;
  width: auto;
  box-shadow: none;
  margin-bottom: 0;
}
.btn-back:hover {
  background: var(--p);
  color: white;
  transform: translateX(-5px);
  box-shadow: 0 5px 15px rgba(233, 30, 99, 0.3);
}
.btn-back .e {
  font-size: 18px;
  transition: transform 0.3s;
}
.btn-back:hover .e {
  transform: translateX(-3px);
}

/* Status Colors */
.ok{border-left: 5px solid #E91E63; background: #3A2C2C; color: #FF80AB}
.bad{border-left: 5px solid #FF5252; background: #3A2C2C; color: #FF8A80}
.info{border-left: 5px solid #2196F3; background: #2C323A; color: #90CAF9}

table{width:100%;border-collapse:separate; border-spacing: 0 10px; font-size:15px}
th{text-align:left; color:var(--p); padding:15px; border-bottom:2px solid var(--border)}
td{padding:15px; background: #2C2C2C; border-top: 1px solid #333; border-bottom: 1px solid #333; color: var(--text)}
tr td:first-child{border-top-left-radius: 15px; border-bottom-left-radius: 15px; border-left: 1px solid #333}
tr td:last-child{border-top-right-radius: 15px; border-bottom-right-radius: 15px; border-right: 1px solid #333}
tr:hover td{background: #333; transform: scale(1.01); transition: 0.2s}

code{
  background: #333;
  border: 1px solid #444;
  color: #FF4081;
  padding: 4px 8px;
  font-size: 14px;
  border-radius: 8px;
  font-family: 'Fredoka', sans-serif;
}

.stat-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:15px;margin-bottom:20px}
.stat-card{
  background: var(--panel);
  padding:15px;
  border-radius: 15px;
  box-shadow: var(--shadow);
  position:relative;
  overflow:hidden;
  transition: 0.3s;
  text-align: center;
  border: 1px solid #333;
}
.stat-card:hover{transform: translateY(-3px); border-color: var(--p)}

.stat-val{font-size:24px; color:var(--p); font-weight:bold; margin:5px 0}
.stat-lbl{font-size:12px; color:#AAA; text-transform:uppercase; letter-spacing:1px}

/* Settings View Logout Button */
.settings-logout-btn {
    background: #3A2C2C !important;
    color: #FF5252 !important;
    border: 2px solid #FF5252 !important;
    border-radius: 15px !important;
    padding: 15px 30px !important;
    font-weight: 700 !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    gap: 10px !important;
    transition: all 0.3s !important;
    margin: 0 auto !important;
    text-decoration: none !important;
}
.settings-logout-btn:hover {
    background: #FF5252 !important;
    color: white !important;
    border-color: #FF5252 !important;
    transform: translateY(-2px) !important;
    box-shadow: 0 5px 15px rgba(244, 67, 54, 0.3) !important;
}
.settings-logout-btn:active {
    transform: scale(0.95) !important;
}

/* Premium Emoji */
.e {
  display: inline-block;
  font-style: normal;
  font-size: 1.1em;
  filter: drop-shadow(0 0 6px rgba(233, 30, 99, 0.5));
  transform-origin: center;
  transition: transform 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
  margin-right: 4px;
}
.tab:hover .e, .btn:hover .e, h3:hover .e {
  transform: scale(1.2) rotate(10deg);
  filter: drop-shadow(0 0 10px rgba(233, 30, 99, 0.8));
}

/* Scrollbar */
::-webkit-scrollbar{width:10px}
::-webkit-scrollbar-track{background:var(--bg)}
::-webkit-scrollbar-thumb{background:var(--border); border-radius:10px}
::-webkit-scrollbar-thumb:hover{background:var(--p)}
</style>
</head>
<body>

<div class="top">
  <script>
    const allUsers = <?=json_encode($users)?>;
    function checkUser(cid, divId){
      const d = document.getElementById(divId);
      if(!d) return;
      if(allUsers[cid]){
        const u = allUsers[cid];
        const n = u.username ? "@"+u.username : (u.name || "Unknown");
        const bal = u.bal || 0;
        const letter = (n.replace('@','').charAt(0) || '?').toUpperCase();
        
        d.innerHTML = `
          <div class="user-preview">
            <div class="avatar">${letter}</div>
            <div class="details">
              <div class="name">${n}</div>
              <div class="sub">User ID: <b onclick="navigator.clipboard.writeText('${cid}').then(()=>showToast('Copied ID: ${cid}'))" style="cursor:pointer;border-bottom:1px dashed #999" title="Click to copy">${cid}</b> • Bal: <b>${bal} Ks</b></div>
            </div>
          </div>
        `;
        d.style.display = "block";
      } else {
        d.innerHTML = "";
        d.style.display = "none";
      }
    }
    // Auto run if value exists
    window.addEventListener('load', ()=>{
       let b = document.getElementById('bal_cid'); if(b && b.value) checkUser(b.value, 'bal_info');
       let n = document.getElementById('not_cid'); if(n && n.value) checkUser(n.value, 'not_info');
    });
  </script>
  <script>
    function showToast(msg){
      let t=document.getElementById('adm_toast');
      if(!t){
        t=document.createElement('div');
        t.id='adm_toast';
        t.style.position='fixed';
        t.style.left='50%';
        t.style.bottom='20px';
        t.style.transform='translateX(-50%)';
        t.style.background='linear-gradient(135deg, var(--p), var(--p-dim))';
        t.style.color='white';
        t.style.padding='10px 16px';
        t.style.borderRadius='12px';
        t.style.boxShadow='var(--shadow)';
        t.style.zIndex='9999';
        t.style.fontWeight='bold';
        t.style.display='none';
        document.body.appendChild(t);
      }
      t.textContent='✅ '+msg;
      t.style.opacity='0';
      t.style.display='block';
      setTimeout(function(){ t.style.transition='opacity 0.2s, transform 0.2s'; t.style.opacity='1'; t.style.transform='translateX(-50%) translateY(-6px)'; },10);
      setTimeout(function(){ t.style.opacity='0'; t.style.transform='translateX(-50%) translateY(0)'; },1800);
      setTimeout(function(){ t.style.display='none'; },2200);
    }
    function copyCode(val, el){
      navigator.clipboard.writeText(val).then(function(){
        showToast('Copied: '+val);
        if(el){
          var o = el.innerHTML;
          el.innerHTML = '✅ Copied';
          el.style.background = 'linear-gradient(45deg, #4CAF50, #81C784)';
          el.style.color = '#fff';
          setTimeout(function(){ el.innerHTML = o; el.style.background='rgba(255,255,255,0.06)'; el.style.color=''; }, 1200);
        }
      });
    }
  </script>
  <div class="brand">
    <div class="dot"></div>
    <div>
      <b style="font-size: 20px;">Admin Panel</b><br>
      <span class="mini">Theme: <b>Pink</b> • Users: <b><?=count($users)?></b></span>
    </div>
    <div style="margin-left:auto; display:flex; align-items:center; gap:8px; font-size:13px; font-weight:bold">
        <span id="topApiIndicator" style="display:flex; align-items:center; gap:5px; background:#263238; color:#B0BEC5; padding:5px 10px; border-radius:15px; border:1px solid #37474F">
            <span id="topApiDot" style="color:#78909C">●</span> 
            <span id="topApiText">Checking API...</span>
        </span>
        <button type="button" class="btn-sm" style="background:var(--p); color:white; border:none; padding:8px 12px; border-radius:12px" onclick="location.reload()"><span class="e">🔄</span> Refresh</button>
    </div>
  </div>

  <script>
    // Auto check Smile API status on page load
    window.addEventListener('load', function(){
        const topDot = document.getElementById('topApiDot');
        const topText = document.getElementById('topApiText');
        const topInd = document.getElementById('topApiIndicator');
        
        <?php
          $smile_api_conf_js = file_exists(SMILE_API_CONFIG_FILE) ? json_decode(file_get_contents(SMILE_API_CONFIG_FILE), true) : [];
          $current_api_url_js = $smile_api_conf_js['url'] ?? "https://auto-topup.cloud/AIBee/smile.php";
        ?>
        const apiUrl = "<?= $current_api_url_js ?>";

        fetch(apiUrl + '?action=status')
        .then(r => r.json())
        .then(d => {
            if(d.status === 'online'){
                topDot.style.color = "#4CAF50"; // Green Dot
                topText.innerText = "API Online";
                topText.style.color = "#FFF";
                topInd.style.borderColor = "#2E7D32";
                topInd.style.background = "rgba(76, 175, 80, 0.2)";
            } else {
                topDot.style.color = "#F44336"; // Red Dot
                topText.innerText = "API Error";
            }
        })
        .catch(e => {
            topDot.style.color = "#F44336";
            topText.innerText = "API Offline";
        });
    });
  </script>

  <!-- Mobile Nav Selector -->
  <div class="custom-select-container mobile-nav-select" id="customNavSel">
    <div class="custom-select-trigger" onclick="toggleCustomNav()">
      <span id="navSelText" style="display:flex;align-items:center">
        <?php 
          if($view === "smile") echo '<img src="https://www.google.com/s2/favicons?domain=smile.one&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> Smile API Editor';
          else echo $tabs[$view] ?? "Menu";
        ?>
      </span>
      <div class="arrow">▼</div>
    </div>
    <div class="custom-options" id="customNavOptions">
      <?php foreach($tabs as $k=>$n): ?>
        <div class="custom-option <?=($view===$k?"selected":"")?>" onclick="window.location.href='?view=<?=$k?>'">
          <?php 
            if($k === "smile") echo '<img src="https://www.google.com/s2/favicons?domain=smile.one&sz=64"> Smile API Editor';
            else echo $n; 
          ?>
        </div>
      <?php endforeach; ?>
      <div class="custom-option" onclick="window.location.href='?logout=1'" style="color:#FF5252; border-top:1px solid #333">
          🚪 Logout
      </div>
    </div>
  </div>

  <div class="tabbar" id="mainMenu">
    <?php foreach($tabs as $k=>$n): ?>
      <a class="tab <?=($view===$k?"act":"")?>" href="?view=<?=$k?>"><?=$n?></a>
    <?php endforeach; ?>
    <a class="tab" href="?logout=1" style="background:#3A2C2C; color:#FF5252; border-color:#FF5252; margin-left:auto">🚪 Logout</a>
  </div>
</div>

<div class="wrap">
  <?php if($msg):?><div class="card ok">✅ <?=h($msg)?></div><?php endif;?>
  <?php if($info):?><div class="card info">ℹ️ <?=h($info)?></div><?php endif;?>
  <?php if($err):?><div class="card bad">❌ <?=h($err)?></div><?php endif;?>
  <?php if($warn):?><div class="card bad">⚠️ <?=h(implode(" | ",$warn))?></div><?php endif;?>

  <?php if($view==="dashboard"): ?>
    
    <!-- External Balances -->
    <div class="stat-grid" style="margin-bottom:15px">
      <div class="stat-card" style="border-left:5px solid #FF9800;background:#1E1E1E">
        <div class="stat-lbl" style="color:#FFB74D">Smile One Balance</div>
        <div class="stat-val" style="color:#FF9800"><?=get_smile_balance()?></div>
      </div>
      <div class="stat-card" style="border-left:5px solid #9C27B0;background:#1E1E1E">
        <div class="stat-lbl" style="color:#E1BEE7">PUBG API Balance</div>
        <?php
             $sai_key_data = jr(SAI_KEY_FILE);
             $sai_key_current = $sai_key_data['key'] ?? "5d270c847f8d7c4538a0bcb875dc83f0";
        ?>
        <div class="stat-val" style="color:#BA68C8"><?=get_pubg_balance($sai_key_current)?></div>
      </div>
    </div>

    <div class="stat-grid">
      <div class="stat-card" style="border-left:5px solid var(--p)">
        <div class="stat-lbl">Total Users</div>
        <div class="stat-val"><?=number_format($stats["users"])?></div>
      </div>
      <div class="stat-card" style="border-left:5px solid var(--p)">
        <div class="stat-lbl">User Balance</div>
        <div class="stat-val"><?=number_format($stats["balance"])?> Ks</div>
      </div>
      <div class="stat-card" style="border-left:5px solid var(--p)">
        <div class="stat-lbl">Total Sales</div>
        <div class="stat-val"><?=number_format($stats["sales_total"])?> Ks</div>
      </div>
      <div class="stat-card" style="border-left:5px solid var(--p)">
        <div class="stat-lbl">Orders (All)</div>
        <div class="stat-val"><?=number_format($stats["orders_total"])?></div>
      </div>
      <div class="stat-card" style="border-left:4px solid var(--p)">
        <div class="stat-lbl">Today Sales</div>
        <div class="stat-val"><?=number_format($stats["sales_today"])?> Ks</div>
      </div>
      <div class="stat-card" style="border-left:4px solid var(--p)">
        <div class="stat-lbl">Today Orders</div>
        <div class="stat-val"><?=number_format($stats["orders_today"])?></div>
      </div>
    </div>
    
    <div class="card">
      <h3><span class='e'>🕒</span> Recent Orders</h3>
      <div class="table-wrap">
      <table>
        <tr><th>Time</th><th>User</th><th>Item</th><th>Amount</th><th>Status</th></tr>
        <?php foreach($recentOrders as $o): ?>
          <tr>
            <td><?=h($o["time"])?></td>
            <td><?=h($o["u_name"])?></td>
            <td><?=h($o["order"])?></td>
            <td><?=h(ks($o["amount"]))?></td>
            <td><span class="mini">✅ Success</span></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$recentOrders) echo "<tr><td colspan='5'>No orders yet</td></tr>"; ?>
      </table>
      </div>
    </div>

    <div class="row">
        <div class="card">
            <h3><span class='e'>📈</span> Quick Actions</h3>
            <div class="mini">Select a tab above to manage content.</div>
        </div>
        <div class="card">
            <h3><span class='e'>🗓</span> System Info</h3>
            <div class="mini">
                Time: <?=date("Y-m-d H:i:s")?><br>
                PHP: <?=phpversion()?><br>
                Memory: <?=round(memory_get_usage()/1024/1024,2)?> MB
            </div>
        </div>
    </div>
  <?php endif; ?>


  <?php if($view==="json_creator"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <?php
      $dataDir = __DIR__ . "/data";
      @mkdir($dataDir, 0777, true);
      if(isset($_POST["create_json"])){
        $name = trim((string)($_POST["json_name"] ?? ""));
        $name = preg_replace("/[^a-zA-Z0-9._-]/","",$name);
        if($name === "") $name = "new.json";
        if(strtolower(substr($name, -5)) !== ".json") $name .= ".json";
        $path = $dataDir . "/" . $name;
        $raw = (string)($_POST["json_content"] ?? "{}");
        $raw = trim($raw) === "" ? "{}" : $raw;
        $dec = @json_decode($raw, true);
        if($dec === null && trim($raw) !== "null"){
          echo "<div class='alert error'>Invalid JSON content</div>";
        } elseif(file_exists($path)){
          echo "<div class='alert error'>File already exists: ".h($name)."</div>";
        } else {
          $pretty = json_encode($dec, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
          write_text_atomic($path, $pretty);
          echo "<div class='alert success'>Created ".h($name)." in data/</div>";
        }
      } elseif(isset($_POST["upload_json"]) && isset($_FILES["json_file"]) && $_FILES["json_file"]["error"] === UPLOAD_ERR_OK){
        $orig = (string)($_FILES["json_file"]["name"] ?? "");
        $name = preg_replace("/[^a-zA-Z0-9._-]/","",$orig);
        if($name === "") $name = "upload.json";
        if(strtolower(substr($name, -5)) !== ".json") $name .= ".json";
        $path = $dataDir . "/" . $name;
        $tmp = $_FILES["json_file"]["tmp_name"];
        $text = @file_get_contents($tmp);
        $dec = @json_decode((string)$text, true);
        if($dec === null && trim((string)$text) !== "null"){
          echo "<div class='alert error'>Invalid JSON file</div>";
        } else {
          $pretty = json_encode($dec, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
          $overwrite = isset($_POST["overwrite"]);
          if(file_exists($path) && !$overwrite){
            echo "<div class='alert error'>File already exists: ".h($name)."</div>";
          } else {
            write_text_atomic($path, $pretty);
            echo "<div class='alert success'>Uploaded ".h($name)." to data/</div>";
          }
        }
      }
      $files = glob($dataDir . "/*.json");
    ?>
    <div class="card">
      <h3><span class="e">🗂</span> JSON File Creator</h3>
      <div class="mini">Create new JSON files under data/. Only .json is allowed.</div>
    </div>
    <div class="card">
      <form method="post">
        <div style="display:flex; gap:10px; flex-wrap:wrap">
          <div style="flex:1; min-width:200px">
            <label style="font-size:12px; color:#AAA">File name</label>
            <input type="text" name="json_name" placeholder="example.json" style="width:100%">
          </div>
          <div style="flex-basis:100%">
            <label style="font-size:12px; color:#AAA">Initial JSON</label>
            <textarea name="json_content" style="width:100%; height:220px; font-family:'Consolas',monospace; background:#1e1e1e; color:#a6accd; border:1px solid #333; border-radius:8px">{}</textarea>
          </div>
        </div>
        <div style="margin-top:12px">
          <button class="btn" name="create_json" style="width:auto; padding:10px 20px">Create JSON</button>
        </div>
      </form>
    </div>
    <div class="card">
      <h3 style="margin-top:0"><span class="e">⬆</span> Upload JSON to data/</h3>
      <form method="post" enctype="multipart/form-data" style="display:flex; gap:10px; align-items:flex-end; flex-wrap:wrap">
        <div style="flex:1; min-width:200px">
          <label style="font-size:12px; color:#AAA">Choose .json file</label>
          <input type="file" name="json_file" accept=".json,application/json" style="width:100%">
        </div>
        <div style="flex:0">
          <label style="font-size:12px; color:#AAA">Options</label>
          <div><input type="checkbox" name="overwrite"> Overwrite if exists</div>
        </div>
        <button class="btn" name="upload_json" style="width:auto; padding:10px 20px">Upload JSON</button>
      </form>
    </div>
    <div class="card">
      <h4 style="margin-top:0">Existing data/*.json</h4>
      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Name</th>
              <th>Size</th>
              <th>Modified</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($files as $f): ?>
            <tr>
              <td><?= h(basename($f)) ?></td>
              <td><?= number_format(@filesize($f)) ?> B</td>
              <td><?= date("Y-m-d H:i:s", @filemtime($f)) ?></td>
            </tr>
            <?php endforeach; ?>
            <?php if(!$files): ?>
            <tr><td colspan="3" style="text-align:center; opacity:0.7">No JSON files found</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  <?php endif; ?>

  <?php if($view==="users"): ?>
    <div class="card">
      <h3><span class='e'>👤</span> Users</h3>
      <form method="get">
        <input type="hidden" name="view" value="users">
        <div class="row">
          <input name="q" placeholder="Search ID..." value="<?=h($q)?>">
          <button class="btn">Search</button>
        </div>
      </form>
    </div>
    <div class="card">
      <div class="table-wrap">
        <table>
          <tr><th>User Details</th><th>Game Info</th><th>Balance</th><th>Actions</th></tr>
          <?php
            $show=$users;
            if($q!==""){ $show=[]; foreach($users as $cid=>$ud){ if(strpos((string)$cid,$q)!==false) $show[$cid]=$ud; } }
            // Filter out groups (negative IDs)
            $show = array_filter($show, function($k) { return $k > 0; }, ARRAY_FILTER_USE_KEY);
            
            uasort($show,function($a,$b){ return (int)($b["bal"]??0) <=> (int)($a["bal"]??0); });
            $hist = jr(HFILE);
            
            $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
            $perPage = 50;
            $total = count($show);
            $pages = ceil($total / $perPage);
            $offset = ($page - 1) * $perPage;
            $slice = array_slice($show, $offset, $perPage, true);
            
            foreach($slice as $cid=>$ud){
              $fname = h($ud["name"]??"");
              $lname = h($ud["lastname"]??"");
              $uname = h($ud["username"]??"");
              $fullname = trim("$fname $lname");
              if(!$fullname) $fullname = "Unknown";

              $hlist = isset($hist[$cid]) && is_array($hist[$cid]) ? $hist[$cid] : [];
              $last = $hlist ? $hlist[count($hlist)-1] : [];
              $uid_show = isset($last["uid_show"]) ? h($last["uid_show"]) : "-";
              $in_name = isset($last["name"]) ? h($last["name"]) : "-";
              
              $joinDate = $ud["join"] ?? "-";
              $link = $uname ? "https://t.me/".$uname : "tg://user?id=".$cid;

              echo "<tr>
                <td>
                    <div style='font-weight:bold; color:var(--p); font-size:1.05em'>$fullname</div>
                    ".($uname ? "<a href='".h($link)."' target='_blank' style='font-size:0.85em; color:var(--text); opacity:0.9; margin-bottom:2px; display:block; text-decoration:none'>@$uname</a>" : "")."
                    <div class='mini' style='margin-top:3px'>
                        ID: <span onclick=\"navigator.clipboard.writeText('".h($cid)."').then(()=>showToast('Copied ID: ".h($cid)."'))\" style='cursor:pointer;border-bottom:1px dashed #777' title='Click to copy'>".h($cid)."</span>
                    </div>
                    <div class='mini'>Joined: ".h($joinDate)."</div>
                </td>
                <td>
                    <div style='font-size:0.85em; line-height:1.5'>
                        <div style='display:flex; gap:6px'>
                           <span style='opacity:0.6; min-width:60px'>UID:</span> 
                           <span style='font-family:monospace; font-weight:bold; color:#E91E63'>$uid_show</span>
                        </div>
                        <div style='display:flex; gap:6px'>
                           <span style='opacity:0.6; min-width:60px'>Name:</span> 
                           <span style='font-weight:bold; color:#FF9800'>$in_name</span>
                        </div>
                    </div>
                </td>
                <td><b>".h(ks($ud["bal"]??0))."</b></td>
                <td>
                  <div style='display:flex; flex-wrap:wrap; gap:4px'>
                    <a href='?view=balance&cid=".h($cid)."' class='btn-sm blue'>💰 Topup</a> 
                    <a href='?view=notify&cid=".h($cid)."' class='btn-sm orange'>🔔 Msg</a>
                    <button class='btn-sm ".(!empty($ud["banned"])?"green":"red")."' style='width:auto;border:none;cursor:pointer' onclick=\"return openBanConfirm('".h($cid)."', ".(!empty($ud["banned"])?1:0).")\">
                        ".(!empty($ud["banned"])?"✅ Unban":"🚫 Ban")."
                    </button>
                  </div>
                </td>
              </tr>";
            }
            if(!$show) echo "<tr><td colspan='4'>No users</td></tr>";
          ?>
        </table>
        <?php if($pages > 1): ?>
        <div style="margin-top:15px; display:flex; gap:5px; justify-content:center; flex-wrap:wrap">
            <?php for($i=1; $i<=$pages; $i++): ?>
                <a href="?view=users&q=<?=h($q)?>&page=<?=$i?>" class="btn-sm" style="<?=($i===$page)?'background:var(--p);color:white':'background:#333;color:#ccc'?>"><?=$i?></a>
            <?php endfor; ?>
        </div>
        <?php endif; ?>
      </div>
    </div>
  <?php endif; ?>

  <?php if($view==="balance"): ?>
    <div class="card">
      <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px">
        <a href="?view=admin_manager" class="btn-sm" style="background:transparent; border:1px solid var(--p); color:var(--p)!important">⬅ Back</a>
      </div>
      <h3><span class='e'>💰</span> User Balance Control</h3>
      <div class="mini" style="margin-top:5px; color:#B0BEC5">Update user wallet with a clear preview before sending notification.</div>
      <form method="post" id="form_single_balance">
        <div class="row" style="align-items:flex-start">
          <div style="display:flex; flex-direction:column; gap:4px; min-width:140px; flex:1">
            <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em">User ID</label>
            <input id="bal_cid" name="cid" placeholder="User ID" required inputmode="numeric" maxlength="30" pattern="-?\d{1,30}" value="<?=h($_GET['cid']??"")?>" oninput="this.value=this.value.replace(/[^\d-]/g,'').slice(0,30); checkUser(this.value, 'bal_info'); computeBalancePreview(); updateBanBtn()">
            <div id="bal_info" class="mini" style="margin-top:2px;color:#FFF;min-height:16px"></div>
          </div>
          <div style="display:flex; flex-direction:column; gap:4px; min-width:130px; flex:1">
            <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em">Amount</label>
            <input id="bal_amt" name="amt" placeholder="+5000 / -2000" required oninput="computeBalancePreview()">
            <div class="mini" style="color:#90A4AE; font-size:0.75em">Pos(+) / Neg(-)</div>
          </div>
          <div style="display:flex; flex-direction:column; gap:4px; min-width:130px; flex:1">
            <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em">Bonus %</label>
            <input id="bonus_pct" name="bonus_percent" placeholder="e.g. 10" style="border:2px solid var(--border); border-radius:12px; padding:10px; background:rgba(255,255,255,0.05); color:var(--text)" oninput="computeBalancePreview()">
            <div class="mini" style="color:#90A4AE; font-size:0.75em">Optional</div>
          </div>
          <div style="display:flex; flex-direction:column; gap:4px; min-width:100px; flex:1">
            <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em">Notify</label>
            <label style="display:flex; align-items:center; gap:6px; height:42px">
              <input type="checkbox" id="send_notify" name="send_notify" value="1" style="width:20px;height:20px" onchange="toggleUpdateBtn()">
              <span class="mini" style="color:#90A4AE">Send Msg</span>
            </label>
          </div>
        </div>
        <div id="bal_preview" style="margin-top:12px; background:linear-gradient(135deg, rgba(233,30,99,0.12), rgba(30,30,30,0.6)); border:1px solid var(--border); border-radius:15px; padding:15px; display:none">
          <div style="display:flex; flex-wrap:wrap; gap:15px; align-items:center">
            <div style="flex:1; min-width:220px">
              <div style="font-size:12px; color:#90A4AE; font-weight:bold; letter-spacing:0.5px">Effective Change</div>
              <div id="pv_delta" style="font-size:22px; font-weight:bold; color:var(--p)">+0 Ks</div>
            </div>
            <div style="flex:1; min-width:220px">
              <div style="font-size:12px; color:#90A4AE; font-weight:bold; letter-spacing:0.5px">Old Balance</div>
              <div id="pv_old" style="font-size:22px; font-weight:bold; color:#FFC107">0 Ks</div>
            </div>
            <div style="flex:1; min-width:220px">
              <div style="font-size:12px; color:#90A4AE; font-weight:bold; letter-spacing:0.5px">New Balance</div>
              <div id="pv_new" style="font-size:22px; font-weight:bold; color:#4CAF50">0 Ks</div>
            </div>
          </div>
        </div>
        <div style="display:flex; gap:10px; margin-top:10px; flex-wrap:wrap">
          <button class="btn" id="updateBtn" name="add_bal">UPDATE</button>
          <button type="button" class="btn-sm" style="background:#E57373;color:white;border:none;padding:10px 15px;border-radius:12px;font-weight:bold" onclick="return openBalanceConfirm('deduct')"><span class="e">🗑</span> DEDUCT ALL</button>
          <button type="button" id="btn_ban" class="btn-sm" style="background:#607D8B;color:white;border:none;padding:10px 15px;border-radius:12px;font-weight:bold;transition:all 0.2s; box-shadow:0 4px 6px rgba(0,0,0,0.1)" onclick="handleBalanceBan()"><span class="e">🚫</span> BAN / UNBAN</button>
        </div>
      </form>
      <script>
        function handleBalanceBan(){
          const c = document.getElementById('bal_cid')?.value?.trim();
          if(!c || typeof allUsers !== 'object' || !allUsers[c]) return;
          openBanConfirm(c, allUsers[c].banned);
        }
        function updateBanBtn(){
          const c = document.getElementById('bal_cid')?.value?.trim();
          const btn = document.getElementById('btn_ban');
          if(!btn) return;
          if(!c || typeof allUsers !== 'object' || !allUsers[c]){
             btn.innerHTML = '<span class="e">🚫</span> BAN / UNBAN';
             btn.style.background = '#607D8B';
             btn.style.boxShadow = 'none';
             return;
          }
          if(allUsers[c].banned){
             btn.innerHTML = '<span class="e">✅</span> UNBAN USER';
             btn.style.background = 'linear-gradient(45deg, #4CAF50, #81C784)';
             btn.style.boxShadow = '0 4px 15px rgba(76, 175, 80, 0.4)';
          } else {
             btn.innerHTML = '<span class="e">⛔</span> BAN USER';
             btn.style.background = 'linear-gradient(45deg, #F44336, #E57373)';
             btn.style.boxShadow = '0 4px 15px rgba(244, 67, 54, 0.4)';
          }
        }
        function mmkFormat(n){ try{ return Number(n).toLocaleString('en-US'); }catch(e){ return n; } }
        function computeBalancePreview(){
          const c = document.getElementById('bal_cid')?.value?.trim();
          const aRaw = document.getElementById('bal_amt')?.value?.trim();
          const bRaw = document.getElementById('bonus_pct')?.value?.trim();
          if(!c || !aRaw){ document.getElementById('bal_preview').style.display='none'; return; }
          let old = 0;
          if(typeof allUsers === 'object' && allUsers[c] && allUsers[c].bal !== undefined){
            old = parseFloat(allUsers[c].bal) || 0;
          }
          let amt = parseFloat(aRaw.replace(/[^\-\d.]/g,'')); if(isNaN(amt)) { document.getElementById('bal_preview').style.display='none'; return; }
          let bonus = parseFloat(bRaw); if(isNaN(bonus)) bonus = 0;
          let delta = amt + (amt * bonus / 100);
          let nw = Math.max(0, old + delta);
          document.getElementById('pv_delta').textContent = (delta>=0?'+':'') + mmkFormat(Math.round(delta)) + ' Ks';
          document.getElementById('pv_old').textContent = mmkFormat(Math.round(old)) + ' Ks';
          document.getElementById('pv_new').textContent = mmkFormat(Math.round(nw)) + ' Ks';
          document.getElementById('bal_preview').style.display = 'block';
        }
        function toggleUpdateBtn(){
          const c = document.getElementById('send_notify');
          const b = document.getElementById('updateBtn');
          if(!b) return;
          b.textContent = c && c.checked ? 'UPDATE & NOTIFY' : 'UPDATE';
        }
        window.addEventListener('load', computeBalancePreview);
        window.addEventListener('load', toggleUpdateBtn);
        window.addEventListener('load', updateBanBtn);
      </script>

      <div style="border-top:2px dashed var(--border); margin:20px 0;"></div>
      <h3><span class='e'>👥</span> All Users Balance Action</h3>
      <div class="mini" style="margin-top:5px; color:#B0BEC5">Apply the same change to every user.</div>
      <form method="post" id="form_bulk_balance">
        <div class="row" style="align-items:flex-start">
          <div style="display:flex; flex-direction:column; gap:4px; min-width:130px; flex:1">
            <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em">Amount</label>
            <input id="bal_amt_all" name="amt_all" placeholder="+1000 / -500" required>
          </div>
          <div style="display:flex; flex-direction:column; gap:4px; min-width:130px; flex:1">
            <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em">Bonus %</label>
            <input id="bonus_pct_all" name="bonus_percent_all" placeholder="e.g. 5" style="border:2px solid var(--border); border-radius:12px; padding:10px; background:rgba(255,255,255,0.05); color:var(--text)">
            <div class="mini" style="color:#90A4AE; font-size:0.75em">Optional</div>
          </div>
          <div style="display:flex; flex-direction:column; gap:4px; min-width:130px; flex:1">
            <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em">Notify All</label>
            <label style="display:flex; align-items:center; gap:6px; height:42px">
              <input type="checkbox" id="send_notify_all" name="send_notify_all" value="1" style="width:20px;height:20px">
              <span class="mini" style="color:#90A4AE">Send Msg to All</span>
            </label>
          </div>
        </div>
        <button type="button" class="btn" style="margin-top:10px" onclick="return openBalanceConfirm('bulk')">APPLY TO ALL</button>
      </form>
      <div id="balConfirmOverlay" style="position:fixed; inset:0; background:rgba(0,0,0,0.5); display:none; align-items:center; justify-content:center; z-index:9999" onclick="if(event.target===this){this.style.display='none'; pendingBalanceAction=null;}">
        <div style="width:95%; max-width:520px; background:var(--panel); border:1px solid var(--border); border-radius:18px; box-shadow: var(--shadow); overflow:hidden">
          <div style="display:flex; align-items:center; gap:10px; padding:16px; background:linear-gradient(135deg, var(--p), var(--p-dim)); color:white">
            <div style="font-size:24px"><span class="e">❓</span></div>
            <div style="font-weight:bold; font-size:16px">Confirm Action</div>
          </div>
          <div style="padding:16px; color:var(--text)">
            <div id="balConfirmMsg" style="font-size:14px; line-height:1.6"></div>
          </div>
          <div style="display:flex; gap:10px; padding:16px; background:rgba(255,255,255,0.05); border-top:1px solid var(--border)">
            <button type="button" id="balConfirmNo" style="flex:1; padding:10px; border-radius:12px; background:#424242; color:white; border:1px solid #616161">No</button>
            <button type="button" id="balConfirmYes" style="flex:1; padding:10px; border-radius:12px; background:var(--p); color:white; border:1px solid var(--p-dim)">Yes, Proceed</button>
          </div>
        </div>
      </div>
      <script>
        let pendingBalanceAction = null;
        function openBalanceConfirm(type){
          pendingBalanceAction = type;
          const ov = document.getElementById('balConfirmOverlay');
          const msg = document.getElementById('balConfirmMsg');
          const cid = document.getElementById('bal_cid')?.value?.trim();
          if(type==='deduct'){
            let old = 0; let name = '';
            if(cid && allUsers[cid]){ old = parseFloat(allUsers[cid].bal) || 0; name = allUsers[cid].username ? '@'+allUsers[cid].username : (allUsers[cid].name || cid); }
            msg.innerHTML = "<div style='font-weight:bold; color:var(--p-dim); margin-bottom:8px'><span class='e'>🗑</span> Deduct ALL Balance</div>"
              + "<div><b>User:</b> " + (name || 'Unknown') + "</div>"
              + "<div><b>User ID:</b> " + (cid || '-') + "</div>"
              + "<div><b>Old Balance:</b> " + mmkFormat(Math.round(old)) + " Ks</div>"
              + "<div><b>New Balance:</b> 0 Ks</div>";
          } else if(type==='bulk'){
            const aRaw = document.getElementById('bal_amt_all')?.value?.trim();
            const bRaw = document.getElementById('bonus_pct_all')?.value?.trim();
            let amt = parseFloat(aRaw?.replace(/[^\-\d.]/g,'')); if(isNaN(amt)) amt = 0;
            let bonus = parseFloat(bRaw); if(isNaN(bonus)) bonus = 0;
            const bonusAmt = amt * bonus / 100;
            const delta = amt + bonusAmt;
            const totalUsers = Object.keys(allUsers||{}).length;
            let bonusStr = "";
            if(bonus !== 0) {
                 bonusStr = " <span style='opacity:0.8; font-size:0.9em'>(incl. "+(bonusAmt>=0?'+':'')+mmkFormat(Math.round(bonusAmt))+" Ks bonus)</span>";
            }
            msg.innerHTML = "<div style='font-weight:bold; color:var(--p-dim); margin-bottom:8px'><span class='e'>👥</span> Apply to ALL Users</div>"
              + "<div><b>Users:</b> " + totalUsers + "</div>"
              + "<div><b>Amount:</b> " + (amt>=0?'+':'') + mmkFormat(Math.round(amt)) + " Ks</div>"
              + "<div><b>Bonus %:</b> " + mmkFormat(bonus) + "%</div>"
              + "<div><b>Effective Change per user:</b> " + (delta>=0?'+':'') + mmkFormat(Math.round(delta)) + " Ks" + bonusStr + "</div>";
          }
          ov.style.display = 'flex';
          return false;
        }
        document.getElementById('balConfirmNo').onclick = function(){
          document.getElementById('balConfirmOverlay').style.display='none';
          pendingBalanceAction=null;
        };
        document.getElementById('balConfirmYes').onclick = function(){
          const ov = document.getElementById('balConfirmOverlay');
          ov.style.display='none';
          if(pendingBalanceAction==='deduct'){
            const f = document.getElementById('form_single_balance');
            const h = document.createElement('input'); h.type='hidden'; h.name='deduct_all_bal'; h.value='1'; f.appendChild(h); f.submit();
          } else if(pendingBalanceAction==='bulk'){
            const f = document.getElementById('form_bulk_balance');
            const h = document.createElement('input'); h.type='hidden'; h.name='add_bal_all'; h.value='1'; f.appendChild(h); f.submit();
          }
          pendingBalanceAction=null;
        };
      </script>

      <hr style="border:0; border-top:2px dashed #eee; margin:20px 0">

      <form method="post">
        <label style="font-weight:bold;display:block;margin-bottom:5px;color:var(--p-dim)">Auto Notify Footer Text:</label>
        <div class="mini" style="margin-bottom:5px">Appended to the end of wallet update notifications</div>
        <textarea name="notify_footer_text" style="width:100%;height:140px;font-family:monospace;white-space:pre-wrap;padding:15px;border:2px solid var(--border);border-radius:15px;outline:none;resize:vertical;font-size:14px" placeholder="Enter footer text..."><?= htmlspecialchars($notify_footer_now) ?></textarea>
        <div class="row" style="margin-top:10px">
          <button name="save_notify_footer" class="btn" style="width:auto">💾 Save Footer</button>
          <button name="clear_notify_footer" class="btn-sm" style="background:#E57373; color:white; border:none; padding:8px 15px; border-radius:20px; font-weight:bold">🗑 Delete Saved</button>
        </div>
      </form>

      <div class="info" style="padding:15px;margin-top:15px;border-radius:10px;background:#FCE4EC;color:#880E4F;border:1px dashed #E91E63">
        <b>Tips:</b> You can use HTML tags like &lt;b&gt;, &lt;i&gt;, &lt;br&gt;, &lt;p&gt;, &lt;h3&gt; etc. to style the message.
      </div>
    </div>
  <?php endif; ?>

  <?php if($view==="notify"): ?>
    <div class="card">
      <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px">
        <a href="?view=admin_manager" class="btn-sm" style="background:transparent; border:1px solid var(--p); color:var(--p)!important">⬅ Back</a>
      </div>
      <h3><span class='e'>🔔</span> Notify (One User)</h3>
      <form method="post" enctype="multipart/form-data">
        <div>
          <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em; display:block; margin-bottom:4px">User ID</label>
          <input id="not_cid" name="n_cid" placeholder="User ID" required value="<?=h($_GET['cid']??"")?>" oninput="checkUser(this.value, 'not_info')">
          <div id="not_info" class="mini" style="margin-top:5px;color:#FFF;min-height:20px"></div>
        </div>
        <textarea name="n_text" placeholder="Message (Caption)" style="margin-top:10px"></textarea>
        <div class="row" style="margin-top:10px">
          <input name="n_img_url" placeholder="Image URL (optional)">
          <input type="file" name="n_img_file" accept="image/*">
        </div>
        <button class="btn" name="notify_one" style="margin-top:10px">SEND</button>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="broadcast"): ?>
    <div class="card">
      <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px">
        <a href="?view=admin_manager" class="btn-sm" style="background:transparent; border:1px solid var(--p); color:var(--p)!important">⬅ Back</a>
      </div>
      <h3><span class='e'>📣</span> Broadcast (ALL Users)</h3>
      <form method="post" enctype="multipart/form-data">
        <textarea name="b_text" placeholder="Message (Caption)"></textarea>
        <div class="row" style="margin-top:10px">
          <input name="b_img_url" placeholder="Image URL (optional)">
          <input type="file" name="b_img_file" accept="image/*">
        </div>
        <div class="row" style="margin-top:10px">
          <input name="b_delay" value="<?=h(BC_DELAY_MS)?>" placeholder="Delay ms">
          <input value="Users: <?=count($users)?>" readonly>
        </div>
        <button class="btn" name="broadcast_all" style="margin-top:10px">SEND BROADCAST</button>
      </form>
    </div>
    <?php if($fails): ?>
      <div class="card bad"><h3><span class='e'>❌</span> Failed</h3>
        <textarea readonly><?=h(json_encode($fails,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT))?></textarea>
      </div>
    <?php endif; ?>
  <?php endif; ?>

  <?php if($view==="admin_manager"): ?>
    <div class="card">
      <h3><span class='e'>🛠</span> Admin Manager</h3>
      <div class="mini">Advanced administrative tools and editors.</div>
    </div>
    
    <div class="grid-menu">
      <a href="?view=balance" class="menu-card">
        <div class="icon">💰</div>
        <div class="title">User Balance</div>
        <div class="desc">Manage User Wallets</div>
      </a>
      <a href="?view=notify" class="menu-card">
        <div class="icon">🔔</div>
        <div class="title">Notify User</div>
        <div class="desc">Send Individual Msg</div>
      </a>
      <a href="?view=broadcast" class="menu-card">
        <div class="icon">📣</div>
        <div class="title">Broadcast</div>
        <div class="desc">Send Message to All</div>
      </a>
      <a href="?view=prices" class="menu-card">
        <div class="icon">🎮</div>
        <div class="title">Prices Editor</div>
        <div class="desc">Manage ML, UC, and Code prices</div>
      </a>
      <a href="?view=topup_codes" class="menu-card">
        <div class="icon">🎫</div>
        <div class="title">Topup Codes</div>
        <div class="desc">Generate and Edit Codes</div>
      </a>
      <a href="?view=topup" class="menu-card">
        <div class="icon">💳</div>
        <div class="title">User Panel Manager</div>
        <div class="desc">Configure Topup page settings</div>
      </a>
      <a href="?view=cookies" class="menu-card">
        <div class="icon">🍪</div>
        <div class="title">Cookies Manager</div>
        <div class="desc">Manage Smile One cookies</div>
      </a>
      <a href="?view=smile" class="menu-card">
        <div class="icon"><img src="https://www.google.com/s2/favicons?domain=smile.one&sz=64" style="width:40px;height:40px;border-radius:50%;object-fit:cover"></div>
        <div class="title">Smile API Editor</div>
        <div class="desc">Configure Smile One API endpoints</div>
      </a>
      <a href="?view=app" class="menu-card">
        <div class="icon">📱</div>
        <div class="title">Bot App Editor</div>
        <div class="desc">Edit index.php source code</div>
      </a>
      <a href="?view=bot" class="menu-card">
        <div class="icon">🤖</div>
        <div class="title">Bot Editor</div>
        <div class="desc">Edit bot.php source code</div>
      </a>
      <a href="?view=api_keys" class="menu-card">
        <div class="icon">🔑</div>
        <div class="title">API Keys</div>
        <div class="desc">Manage SAI & Bot Tokens</div>
      </a>
      <a href="?view=bot_menu" class="menu-card">
        <div class="icon">🤖</div>
        <div class="title">Bot Menu</div>
        <div class="desc">Edit Bot Buttons</div>
      </a>
      <a href="?view=json_creator" class="menu-card">
        <div class="icon">🗂</div>
        <div class="title">JSON Creator</div>
        <div class="desc">Create data/*.json files</div>
      </a>
    </div>

    <style>
      .grid-menu {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(130px, 1fr));
        gap: 10px;
        margin-top: 15px;
      }
      .menu-card {
        background: var(--panel);
        border: 1px solid var(--border);
        border-radius: 12px;
        padding: 12px;
        text-align: center;
        text-decoration: none;
        color: var(--text);
        transition: transform 0.2s, box-shadow 0.2s;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        min-height: 100px;
      }
      .menu-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
        border-color: var(--p);
      }
      .menu-card .icon {
        font-size: 28px;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .menu-card .icon img {
        width: 28px;
        height: 28px;
        object-fit: contain;
      }
      .menu-card .title {
        font-weight: bold;
        font-size: 13px;
        margin-bottom: 4px;
        color: var(--p);
        line-height: 1.2;
      }
      .menu-card .desc {
        font-size: 10px;
        color: var(--p-dim);
        line-height: 1.2;
      }
      @media (max-width: 600px) {
        .grid-menu {
          grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
          gap: 8px;
        }
        .menu-card {
            padding: 10px;
            min-height: 90px;
        }
        .menu-card .icon {
            font-size: 24px;
        }
        .menu-card .icon img {
            width: 24px;
            height: 24px;
        }
        .menu-card .title {
            font-size: 12px;
        }
      }
    </style>
  <?php endif; ?>

  <?php if($view==="prices"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <div class="card">
      <h3><span class='e'>🎮</span> Prices (JSON)</h3>
      <div class="mini">Select a file to edit. Backup is recommended!</div>
    </div>

    <div class="card">
      <div style="margin-bottom:20px">
        <label style="font-weight:bold;color:var(--p-dim);display:block;margin-bottom:8px">Select Price File:</label>
        <div class="custom-select-wrapper">
          <!-- Hidden Original Select -->
          <select id="priceFileSelector" onchange="showPriceForm(this.value)" style="display:none">
            <option value="ml">ML Prices</option>
            <option value="uc">PUBG UC Prices</option>
            <option value="code">PUBG CODE Prices</option>
          </select>

          <!-- Custom Select UI -->
          <div class="custom-select-container" id="customPriceSel">
            <div class="custom-select-trigger" onclick="toggleCustomSelect()">
              <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64" id="selImg">
              <span id="selText">ML Prices</span>
              <div class="arrow">▼</div>
            </div>
            <div class="custom-options" id="customOptions">
              <div class="custom-option selected" onclick="selectCustomOption('ml', 'ML Prices', 'https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64')">
                <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64"> ML Prices
              </div>
              <div class="custom-option" onclick="selectCustomOption('uc', 'PUBG UC Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG UC Prices
              </div>
              <div class="custom-option" onclick="selectCustomOption('code', 'PUBG CODE Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG CODE Prices
              </div>
            </div>
          </div>
        </div>
      </div>

      <div style="display:flex; gap:10px; align-items:center; flex-wrap:wrap; padding-top:20px; border-top:2px dashed var(--border)">
        <strong>⚡ Bulk Update:</strong>
        <input type="number" id="bulkPercent" placeholder="%" style="width:80px; padding:8px; border-radius:15px; border:2px solid #333; background:#2C2C2C; color:white">
        <button class="btn" onclick="applyBulkPrice(1)" style="width:auto; padding:8px 15px; background:#E91E63; border:none; box-shadow:0 4px 10px rgba(233,30,99,0.3)">➕ ADD %</button>
        <button class="btn" onclick="applyBulkPrice(-1)" style="width:auto; padding:8px 15px; background:#FF5252; border:none; box-shadow:0 4px 10px rgba(255,82,82,0.3)">➖ DEDUCE %</button>
        <div class="mini" style="margin-left:auto">Updates prices in the box below (Click SAVE after)</div>
      </div>
    </div>

    <div id="form_ml" class="price-form">

    <div class="card"><form method="post">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
            <h3 style="margin:0;border:none;display:flex;align-items:center"><img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> ML</h3>
            <div>
                <input type="file" id="impML" accept=".json" style="display:none" onchange="importJson(this, 'mlTa')">
                <button type="button" class="btn" onclick="document.getElementById('impML').click()" style="width:auto;padding:5px 15px;font-size:13px">📂 Import JSON</button>
            </div>
        </div>
        <textarea id="mlTa" name="json" style="height:500px; resize:none; font-family:monospace"><?=h($ml)?></textarea>
        <input type="hidden" name="file" value="<?=h(ML_FILE)?>">
        <button class="btn" name="save_price" style="margin-top:10px">SAVE ML</button>
      </form></div>
    </div>

    <div id="form_uc" class="price-form" style="display:none">
      <div class="card"><form method="post">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
            <h3 style="margin:0;border:none;display:flex;align-items:center"><img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> PUBG UC</h3>
            <div>
                <input type="file" id="impUC" accept=".json" style="display:none" onchange="importJson(this, 'ucTa')">
                <button type="button" class="btn" onclick="document.getElementById('impUC').click()" style="width:auto;padding:5px 15px;font-size:13px">📂 Import JSON</button>
            </div>
        </div>
        <textarea id="ucTa" name="json" style="height:500px; resize:none; font-family:monospace"><?=h($uc)?></textarea>
        <input type="hidden" name="file" value="<?=h(PUBG_UC_FILE)?>">
        <button class="btn" name="save_price" style="margin-top:10px">SAVE UC</button>
      </form></div>
    </div>

    <div id="form_code" class="price-form" style="display:none">
      <div class="card"><form method="post">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
            <h3 style="margin:0;border:none;display:flex;align-items:center"><img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64" style="width:28px;height:28px;margin-right:10px;border-radius:50%"> PUBG CODE</h3>
            <div>
                <input type="file" id="impCode" accept=".json" style="display:none" onchange="importJson(this, 'codeTa')">
                <button type="button" class="btn" onclick="document.getElementById('impCode').click()" style="width:auto;padding:5px 15px;font-size:13px">📂 Import JSON</button>
            </div>
        </div>
        <textarea id="codeTa" name="json" style="height:500px; resize:none; font-family:monospace"><?=h($pc)?></textarea>
        <input type="hidden" name="file" value="<?=h(PUBG_CODE_FILE)?>">
        <button class="btn" name="save_price" style="margin-top:10px">SAVE CODE</button>
      </form></div>
    </div>

    <div id="confirmModal" class="modal-overlay">
      <div class="modal-box">
        <div class="modal-icon"><span class="e">🤔</span></div>
        <div class="modal-title">Confirm Action</div>
        <div class="modal-desc" id="modalMsg">Are you sure?</div>
        <div class="modal-btns">
          <button class="modal-btn no" onclick="closeModal()">Cancel</button>
          <button class="modal-btn yes" id="modalYesBtn">Yes, Proceed</button>
        </div>
      </div>
    </div>

    <script>
      let pendingBulkAction = null;

      function toggleCustomSelect() {
        document.getElementById('customOptions').classList.toggle('open');
        document.getElementById('customPriceSel').classList.toggle('active');
      }

      function selectCustomOption(val, text, imgUrl) {
        // Update hidden select
        const sel = document.getElementById('priceFileSelector');
        sel.value = val;
        sel.dispatchEvent(new Event('change')); // Trigger onchange for showPriceForm

        // Update trigger UI
        document.getElementById('selImg').src = imgUrl;
        document.getElementById('selText').innerText = text;

        // Update options styling
        document.querySelectorAll('.custom-option').forEach(opt => opt.classList.remove('selected'));
        event.currentTarget.classList.add('selected');

        toggleCustomSelect();
      }

      // Close on click outside
      document.addEventListener('click', function(e) {
        if (!e.target.closest('#customPriceSel')) {
          document.getElementById('customOptions').classList.remove('open');
          document.getElementById('customPriceSel').classList.remove('active');
        }
      });

      function applyBulkPrice(sign){
        let val = parseFloat(document.getElementById('bulkPercent').value);
        if(isNaN(val) || val <= 0){ alert("Please enter a valid positive percentage (e.g. 10)"); return; }
        
        let action = sign > 0 ? "increase" : "decrease";
        let msg = "Are you sure you want to <b>" + action + "</b> all prices by <b>" + val + "%</b>?";
        
        pendingBulkAction = { sign: sign, val: val };
        showModal(msg, executeBulkUpdate);
      }

      function executeBulkUpdate(){
        if(!pendingBulkAction) return;
        const { sign, val } = pendingBulkAction;
        
        const p = val * sign;
        const sel = document.getElementById('priceFileSelector').value;
        const div = document.getElementById('form_'+sel);
        const ta = div.querySelector('textarea');
        
        try {
          let j = JSON.parse(ta.value);
          if(!Array.isArray(j)){ alert("JSON root must be an array!"); return; }
          
          let c=0;
          j.forEach(x => {
            if(x.price !== undefined){
              let old = parseFloat(x.price);
              let nw = old + (old * p / 100);
              x.price = Math.round(nw);
              c++;
            }
          });
          
          ta.value = JSON.stringify(j, null, 4);
          let actionDone = sign > 0 ? "Increased" : "Decreased";
          
          // Re-use modal for success
          closeModal();
          setTimeout(() => {
             alert(actionDone+" "+c+" prices by "+val+"%. Review and click SAVE!");
          }, 200);

        } catch(e) {
          alert("Invalid JSON in text area! Fix it first.");
          closeModal();
        }
      }

      function showPriceForm(val){
        document.querySelectorAll('.price-form').forEach(el => el.style.display = 'none');
        document.getElementById('form_' + val).style.display = 'block';
      }
      
      const savedSel = localStorage.getItem('price_sel');
      if(savedSel && document.getElementById('form_' + savedSel)) {
        document.getElementById('priceFileSelector').value = savedSel;
        showPriceForm(savedSel);
      }
      document.getElementById('priceFileSelector').addEventListener('change', function(){
        localStorage.setItem('price_sel', this.value);
      });

      // Helper functions for Modal
      function showModal(msg, yesCallback){
        document.getElementById('modalMsg').innerHTML = msg;
        const yesBtn = document.getElementById('modalYesBtn');
        // Remove old listeners to prevent stacking
        let newBtn = yesBtn.cloneNode(true);
        yesBtn.parentNode.replaceChild(newBtn, yesBtn);
        
        newBtn.addEventListener('click', yesCallback);
        
        const m = document.getElementById('confirmModal');
        m.classList.add('show');
      }

      function closeModal(){
        document.getElementById('confirmModal').classList.remove('show');
      }
    </script>
  <?php endif; ?>

  <script>
    // Mobile Nav Selector
    function toggleCustomNav() {
      document.getElementById('customNavOptions').classList.toggle('open');
      document.getElementById('customNavSel').classList.toggle('active');
    }

    // Close Nav on click outside
    document.addEventListener('click', function(e) {
      if (!e.target.closest('#customNavSel')) {
        const opts = document.getElementById('customNavOptions');
        const sel = document.getElementById('customNavSel');
        if(opts && opts.classList.contains('open')) {
          opts.classList.remove('open');
          sel.classList.remove('active');
        }
      }
    });

    function importJson(input, taId) {
      const file = input.files[0];
      if (!file) return;
      
      // Strict JSON check (extension or mime)
      if (file.type !== "application/json" && !file.name.toLowerCase().endsWith(".json")) {
        alert("Only JSON files are accepted!");
        input.value = ""; 
        return;
      }

      const reader = new FileReader();
      reader.onload = function(e) {
        const text = e.target.result;
        try {
          const j = JSON.parse(text);
          const nice = JSON.stringify(j, null, 4);
          const ta = document.getElementById(taId);
          if(ta) ta.value = nice;
          alert("JSON imported successfully! Click SAVE to apply.");
        } catch(err) {
          alert("Invalid JSON file content!");
        }
      };
      reader.readAsText(file);
    }

    function importText(input, taId) {
      const file = input.files[0];
      if (!file) return;
      
      // Strict PHP check
      if (!file.name.toLowerCase().endsWith(".php")) {
        alert("Only PHP files are accepted!");
        input.value = ""; 
        return;
      }

      const reader = new FileReader();
      reader.onload = function(e) {
        const text = e.target.result;
        const ta = document.getElementById(taId);
        if(ta) ta.value = text;
        alert("File imported successfully! Click SAVE to apply.");
      };
      reader.readAsText(file);
    }
  </script>

  <?php if($view==="cookies"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <div class="card">
      <h3><span class='e'>🍪</span> Cookies (JSON)</h3>
      <div class="mini">Backups are automatically saved to <code>/BackupCok</code> when you click SAVE.</div>
    </div>

    <div class="card">
      <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px">
          <h3 style="margin:0"><span class='e'>🍪</span> Cookies Manager</h3>
          <div class="mini">Auto-backups to <code>/BackupCok</code></div>
      </div>

      <!-- Editor Area -->
      <form method="post" id="form_single_balance">
        <div style="position:relative">
            <textarea id="cookiesTa" name="cookies_text" style="width:100%; min-height:300px; padding:15px; border:2px solid #E1E8ED; border-radius:15px; font-family:'Consolas',monospace; font-size:13px; line-height:1.5; outline:none; transition:0.3s" placeholder="Paste your cookies JSON here..."><?=h($cookies_now)?></textarea>
            
            <!-- Quick Actions Overlay -->
            <div style="position:absolute; top:10px; right:10px; display:flex; gap:5px">
                <button type="button" onclick="navigator.clipboard.writeText(document.getElementById('cookiesTa').value).then(()=>alert('Copied!'))" 
                        style="background:rgba(255,255,255,0.9); border:1px solid #CFD8DC; padding:5px 10px; border-radius:8px; cursor:pointer; font-size:12px; font-weight:bold; color:#546E7A; backdrop-filter:blur(4px)">
                    📋 COPY
                </button>
                <button type="button" onclick="document.getElementById('cookiesTa').value=''" 
                        style="background:rgba(255,255,255,0.9); border:1px solid #FFCDD2; padding:5px 10px; border-radius:8px; cursor:pointer; font-size:12px; font-weight:bold; color:#E57373; backdrop-filter:blur(4px)">
                    🗑 CLEAR
                </button>
            </div>
        </div>

        <!-- Bottom Actions -->
        <div style="margin-top:15px; display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:15px">
            <div style="display:flex; gap:10px; align-items:center">
                 <input type="file" id="impC" accept=".json" style="display:none" onchange="importJson(this, 'cookiesTa')">
                 <button type="button" onclick="document.getElementById('impC').click()" style="background:#F5F7F8; color:#546E7A; border:1px solid #CFD8DC; border-radius:10px; padding:10px 20px; font-weight:bold; cursor:pointer; display:flex; align-items:center; gap:5px">
                    📂 Import JSON
                 </button>
                 <button type="button" onclick="navigator.clipboard.readText().then(t => document.getElementById('cookiesTa').value = t)" 
                         style="background:#FFF3E0; color:#EF6C00; border:1px solid #FFE0B2; border-radius:10px; padding:10px 20px; font-weight:bold; cursor:pointer; display:flex; align-items:center; gap:5px">
                     📥 Paste
                 </button>
            </div>
            
            <button name="save_cookies" class="btn" style="background:#E91E63; width:auto; padding:12px 35px; border-radius:30px; font-size:15px; box-shadow:0 5px 15px rgba(233,30,99,0.3)">
                💾 SAVE & BACKUP
            </button>
        </div>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="smile"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <div class="card">
      <h3><img src="https://www.google.com/s2/favicons?domain=smile.one&sz=64" style="vertical-align:middle;width:28px;margin-right:5px;border-radius:50%"> Smile API Editor</h3>
      <div class="mini">Backups are automatically saved to <code>/BackupSmile</code> when you click SAVE.</div>
    </div>

    <!-- API Link & Status -->
    <div class="card" style="background: linear-gradient(135deg, #fff 0%, #F3F8FF 100%); border:1px solid #E1E8ED">
      <h4 style="margin-top:0;color:var(--p-dim); display:flex; align-items:center; gap:8px">
        <img src="https://cdn-icons-png.flaticon.com/512/2015/2015069.png" width="24"> Smile One API Connection
      </h4>
      
      <?php
        $smile_api_conf = file_exists(SMILE_API_CONFIG_FILE) ? json_decode(file_get_contents(SMILE_API_CONFIG_FILE), true) : [];
        $current_api_url = $smile_api_conf['url'] ?? "https://auto-topup.cloud/AIBee/smile.php";
      ?>
      
      <div style="margin-bottom:15px">
         <label class="mini" style="display:block;margin-bottom:5px;font-weight:bold;color:#C2185B">API Endpoint URL</label>
         <form method="post" style="position:relative; display:flex; align-items:center; background:#F5F7F8; border:2px solid #CFD8DC; border-radius:12px; padding:5px; transition:0.3s" id="copyBox">
            <div style="padding:0 12px; color:#546E7A; font-size:18px">🔗</div>
            <input name="smile_api_url" id="smileApiUrl" value="<?=h($current_api_url)?>" 
                   style="border:none; outline:none; flex:1; padding:12px 5px; font-family:'Consolas', monospace; font-size:15px; font-weight:600; color:#263238; background:transparent; width:100%" 
                   placeholder="Enter API URL...">
            
            <button type="submit" name="save_smile_api_url" 
                    style="background:#E91E63; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; font-size:13px; cursor:pointer; margin-right:5px; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(233,30,99,0.3)">
                <span>SAVE</span>
            </button>

            <button type="button" onclick="copySmileApi()" 
                    style="background:var(--p); color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; font-size:13px; cursor:pointer; margin-right:5px; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(233,30,99,0.3)">
                <span id="copyBtnTxt">COPY</span>
                <span id="copyIcon" class="e">📋</span>
            </button>
            <button type="button" onclick="testSmileApi()" 
                    style="background:#C2185B; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; font-size:13px; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(194,24,91,0.3)">
                <span>TEST</span>
                <span class="e">🚀</span>
            </button>
         </form>
         <div class="mini" style="margin-top:5px; margin-left:5px; color:#90A4AE; display:flex; align-items:center; gap:10px" id="urlStatusContainer">
             <span>Click SAVE to store, COPY to use, or TEST to check below.</span>
             <button onclick="checkApiUrlStatus()" style="background:transparent; border:1px solid #CFD8DC; border-radius:12px; padding:2px 8px; font-size:11px; color:#78909C; cursor:pointer; display:flex; align-items:center; gap:4px">
                <span id="urlStatusIcon">●</span> Check URL Status
             </button>
         </div>
      </div>

      <script>
        function checkApiUrlStatus(){
            const icon = document.getElementById('urlStatusIcon');
            const url = document.getElementById('smileApiUrl').value;
            const container = document.getElementById('urlStatusContainer');
            
            icon.style.color = "#FF9800"; 
            icon.innerText = "⏳";
            
            fetch(url + '?action=status')
            .then(r => r.json())
            .then(d => {
                if(d.status === 'online'){
                    container.innerHTML = `
                        <div style="display:flex; align-items:center; justify-content:space-between; width:100%; color:#1B5E20; background:#E8F5E9; padding:8px 12px; border-radius:8px; border:1px solid #A5D6A7">
                            <div style="display:flex; align-items:center; gap:8px">
                                <span style="font-weight:bold; font-size:13px">● Online and Connect ✅</span>
                                <span style="color:#81C784">|</span>
                                <span style="font-family:monospace; font-size:13px; cursor:pointer; border-bottom:1px dashed #2E7D32" 
                                      onclick="navigator.clipboard.writeText('${url}').then(()=>{ this.style.color='#1B5E20'; this.innerText='Copied!'; setTimeout(()=>this.innerText='${url}', 1500); })" 
                                      title="Click to Copy">
                                    ${url}
                                </span>
                            </div>
                            <span style="font-size:14px; cursor:pointer" onclick="navigator.clipboard.writeText('${url}')"><span class='e'>📋</span></span>
                        </div>
                    `;
                } else {
                    icon.style.color = "#D32F2F";
                    icon.innerText = "●";
                    alert("API URL responded but status unknown.");
                }
            })
            .catch(e => {
                icon.style.color = "#D32F2F";
                icon.innerText = "●";
                alert("API URL Unreachable or Error ❌");
            });
        }

        function copySmileApi(){
          var copyText = document.getElementById("smileApiUrl");
          copyText.select();
          copyText.setSelectionRange(0, 99999);
          navigator.clipboard.writeText(copyText.value).then(() => {
             // Visual Feedback
             const box = document.getElementById('copyBox');
             box.style.borderColor = "#E91E63";
             box.style.background = "#FCE4EC";
             
             const btnTxt = document.getElementById('copyBtnTxt');
             const icon = document.getElementById('copyIcon');
             const originalTxt = btnTxt.innerText;
             
             btnTxt.innerText = "COPIED!";
             icon.innerText = "✅";
             
             setTimeout(() => {
                box.style.borderColor = "#CFD8DC";
                box.style.background = "#F5F7F8";
                btnTxt.innerText = originalTxt;
                icon.innerText = "📋";
             }, 2000);
          });
        }

        function testSmileApi(){
            const url = document.getElementById('smileApiUrl').value;
            const checkerUrl = document.getElementById('u_url');
            const checkerBtn = document.getElementById('u_btn');
            
            // Fill URL
            checkerUrl.value = url;
            
            // Scroll to checker
            checkerUrl.scrollIntoView({behavior: "smooth", block: "center"});
            
            // Highlight
            checkerUrl.style.borderColor = "#29B6F6";
            checkerUrl.style.boxShadow = "0 0 0 4px #E1F5FE";
            setTimeout(() => {
                checkerUrl.style.borderColor = "#DDD";
                checkerUrl.style.boxShadow = "none";
            }, 1500);
        }
      </script>
    </div>

    <!-- Universal API Checker -->
    <div class="card">
        <h4 style="margin-top:0;color:var(--p-dim); display:flex; align-items:center; gap:8px">
            <img src="https://cdn-icons-png.flaticon.com/512/8297/8297358.png" width="24"> Universal API Checker
        </h4>
        <div class="mini" style="margin-bottom:15px">Test any API endpoint directly from your server (bypassing CORS).</div>
        
        <div class="row" style="gap:10px; margin-bottom:10px">
            <div style="flex:3">
                <input id="u_url" placeholder="https://api.example.com/v1/..." style="width:100%; padding:10px; border-radius:8px; border:1px solid #DDD">
            </div>
            <div style="flex:1; min-width:100px">
                <select id="u_method" style="width:100%; padding:10px; border-radius:8px; border:1px solid #DDD; background:#fff">
                    <option value="GET">GET</option>
                    <option value="POST">POST</option>
                </select>
            </div>
        </div>
        
        <div style="margin-bottom:10px">
            <textarea id="u_headers" placeholder="Headers (Optional)&#10;Authorization: Bearer token...&#10;Content-Type: application/json" style="width:100%; height:80px; padding:10px; border-radius:8px; border:1px solid #DDD; font-family:monospace"></textarea>
        </div>
        
        <button class="btn" onclick="runApiCheck()" id="u_btn" style="background:var(--p-dim); width:100%">🚀 Test Request</button>
        
        <div id="u_result" style="display:none; margin-top:15px; background:#263238; color:#ECEFF1; padding:15px; border-radius:8px; font-family:monospace; overflow-x:auto; font-size:13px">
            <div style="margin-bottom:10px; border-bottom:1px solid #455A64; padding-bottom:5px; font-weight:bold" id="u_status"></div>
            <pre id="u_body" style="margin:0; white-space:pre-wrap; word-break:break-all"></pre>
        </div>
        
        <script>
            function runApiCheck(){
                const url = document.getElementById('u_url').value;
                if(!url) { alert("Please enter a URL"); return; }
                
                const btn = document.getElementById('u_btn');
                const resDiv = document.getElementById('u_result');
                const statusDiv = document.getElementById('u_status');
                const bodyDiv = document.getElementById('u_body');
                
                btn.innerHTML = "⏳ Sending...";
                btn.disabled = true;
                resDiv.style.display = 'none';
                
                const fd = new FormData();
                fd.append('proxy_api_check', '1');
                fd.append('url', url);
                fd.append('method', document.getElementById('u_method').value);
                fd.append('headers', document.getElementById('u_headers').value);
                
                fetch('admin.php', { method:'POST', body:fd })
                .then(r => r.json())
                .then(d => {
                    resDiv.style.display = 'block';
                    
                    let color = "#66BB6A"; // Green
                    if(d.status_code >= 400) color = "#EF5350"; // Red
                    if(d.error) color = "#FFA726"; // Orange
                    
                    statusDiv.innerHTML = `<span style="color:${color}">HTTP ${d.status_code}</span> ${d.error ? ' | Err: '+d.error : ''}`;
                    
                    // Try to pretty print JSON
                    try {
                        const j = JSON.parse(d.response);
                        bodyDiv.innerText = JSON.stringify(j, null, 2);
                    } catch(e) {
                        bodyDiv.innerText = d.response || "(Empty Response)";
                    }
                })
                .catch(e => {
                    alert("Request failed: " + e);
                })
                .finally(() => {
                    btn.innerHTML = "🚀 Test Request";
                    btn.disabled = false;
                });
            }
        </script>
    </div>

    <div class="card">
      <div style="margin-bottom:10px">
        <input type="file" id="impS" accept=".php" style="display:none" onchange="importText(this, 'smileTa')">
        <button type="button" class="btn" onclick="document.getElementById('impS').click()" style="background:#C2185B;width:auto">📂 Import PHP</button>
      </div>
      <form method="post">
        <textarea id="smileTa" name="smile_text" style="min-height:450px"><?=h($smile_now)?></textarea>
        
        <div style="margin-top:10px; display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:10px">
            <!-- Left: Save -->
            <button class="btn" name="save_smile" style="width:auto; padding:10px 25px">SAVE SMILE.PHP</button>
            
            <!-- Right: Action Buttons -->
            <div style="display:flex; gap:8px">
                <button type="button" onclick="document.getElementById('smileTa').value=''" 
                        style="background:#E57373; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(229,115,115,0.3)">
                    <span>🗑 CLEAR</span>
                </button>
                <button type="button" onclick="navigator.clipboard.writeText(document.getElementById('smileTa').value).then(()=>alert('Copied!'))" 
                        style="background:#64B5F6; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(100,181,246,0.3)">
                    <span>📋 COPY</span>
                </button>
                <button type="button" onclick="navigator.clipboard.readText().then(t => document.getElementById('smileTa').value = t)" 
                        style="background:#FFB74D; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(255,183,77,0.3)">
                    <span>📥 PASTE</span>
                </button>
            </div>
        </div>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="smile_calc"): ?>
    <div class="card">
      <h3><span class='e'>🧮</span> Smile One Price Calculator</h3>
      <div class="mini">Calculate selling prices based on Base Cost (MMK) and Profit %. Changes here do NOT affect the live JSON files.</div>
      
      <div class="row" style="margin-top:20px; align-items:end">
        <div>
           <label style="font-weight:bold;color:var(--p-dim)">Global Profit % (Optional)</label>
           <input type="number" id="globalProfit" placeholder="e.g. 10" oninput="applyGlobalProfit()">
        </div>
        <div>
           <button class="btn" onclick="applyGlobalProfit()">Apply to All Rows</button>
        </div>
      </div>
    </div>

    <script>
      function calcPrice(id){
        let cost = parseFloat(document.getElementById('cost_'+id).value) || 0;
        let prof = parseFloat(document.getElementById('prof_'+id).value) || 0;
        if(cost > 0){
          let sell = cost + (cost * prof / 100);
          sell = Math.ceil(sell); // Round up
          document.getElementById('res_'+id).innerText = sell.toLocaleString() + " MMK";
        } else {
          document.getElementById('res_'+id).innerText = "-";
        }
      }

      function applyGlobalProfit(){
        let gp = document.getElementById('globalProfit').value;
        let inputs = document.querySelectorAll('.profit-input');
        inputs.forEach(inp => {
          inp.value = gp;
          let id = inp.id.replace('prof_', '');
          calcPrice(id);
        });
      }
    </script>

    <div class="card">
      <h3><span class='e'>💎</span> Mobile Legends</h3>
      <div class="table-wrap">
        <table>
          <tr>
            <th>Item</th>
            <th>Current Price</th>
            <th>Base Cost (MMK)</th>
            <th>Profit %</th>
            <th>New Price</th>
          </tr>
          <?php 
            $ml_list = @json_decode($ml, true);
            if(is_array($ml_list)):
              foreach($ml_list as $i=>$item): 
                $id = "ml_".$i;
          ?>
          <tr>
            <td><?=h($item['name'])?></td>
            <td><?=h($item['price'])?></td>
            <td><input type="number" id="cost_<?=$id?>" oninput="calcPrice('<?=$id?>')" placeholder="Cost"></td>
            <td><input type="number" id="prof_<?=$id?>" class="profit-input" oninput="calcPrice('<?=$id?>')" placeholder="%"></td>
            <td id="res_<?=$id?>" style="font-weight:bold;color:var(--p-dim)">-</td>
          </tr>
          <?php endforeach; endif; ?>
        </table>
      </div>
    </div>

    <div class="card">
      <h3><span class='e'>🔫</span> PUBG UC</h3>
      <div class="table-wrap">
        <table>
          <tr>
            <th>Item</th>
            <th>Current Price</th>
            <th>Base Cost (MMK)</th>
            <th>Profit %</th>
            <th>New Price</th>
          </tr>
          <?php 
            $uc_list = @json_decode($uc, true);
            if(is_array($uc_list)):
              foreach($uc_list as $i=>$item): 
                $id = "uc_".$i;
          ?>
          <tr>
            <td><?=h($item['name'])?></td>
            <td><?=h($item['price'])?></td>
            <td><input type="number" id="cost_<?=$id?>" oninput="calcPrice('<?=$id?>')" placeholder="Cost"></td>
            <td><input type="number" id="prof_<?=$id?>" class="profit-input" oninput="calcPrice('<?=$id?>')" placeholder="%"></td>
            <td id="res_<?=$id?>" style="font-weight:bold;color:var(--p-dim)">-</td>
          </tr>
          <?php endforeach; endif; ?>
        </table>
      </div>
    </div>
  <?php endif; ?>

  <?php if($view==="app"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <div class="card">
      <h3><span class='e'>📱</span> BOT APP Editor (index.php)</h3>
      <div class="mini">Auto-backups to <code>/BackupApp</code> when you click SAVE.</div>
    </div>

    <div class="card">
      <h3><span class='e'>✍️</span> Edit index.php</h3>
      <form method="post">
        <textarea id="appTa" name="app_text" style="min-height:500px; font-family:'Consolas',monospace; font-size:13px; line-height:1.5; padding:15px; border:2px solid #E1E8ED; border-radius:15px; outline:none; transition:0.3s; width:100%"><?=h($app_now)?></textarea>
        
        <div style="margin-top:15px; display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:10px">
            <!-- Left: Save -->
            <button class="btn" name="save_app" style="width:auto; padding:12px 30px; font-weight:bold; font-size:15px; border-radius:30px; box-shadow:0 4px 15px rgba(233,30,99,0.3)">💾 SAVE & BACKUP</button>
            
            <!-- Right: Action Buttons -->
            <div style="display:flex; gap:8px">
                <button type="button" onclick="document.getElementById('appTa').value=''" 
                        style="background:#E57373; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(229,115,115,0.3)">
                    <span>🗑 CLEAR</span>
                </button>
                <button type="button" onclick="navigator.clipboard.writeText(document.getElementById('appTa').value).then(()=>alert('Copied!'))" 
                        style="background:#64B5F6; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(100,181,246,0.3)">
                    <span>📋 COPY</span>
                </button>
                <button type="button" onclick="navigator.clipboard.readText().then(t => document.getElementById('appTa').value = t)" 
                        style="background:#FFB74D; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(255,183,77,0.3)">
                    <span>📥 PASTE</span>
                </button>
            </div>
        </div>
      </form>
    </div>
  <?php endif; ?>

  <?php if($view==="bot"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <div class="card">
      <h3><span class='e'>🧩</span> bot.php Manager</h3>
      <div class="mini">Save/Upload လုပ်တိုင်း <code>/backup</code> ထဲ backup သိမ်းပေးမယ် ✅</div>
    </div>

    <div class="card">
      <h3><span class='e'>✍️</span> Edit & Save</h3>
      <form method="post">
        <textarea id="botTa" name="bot_text" style="min-height:420px"><?=h($bot_now)?></textarea>
        
        <div style="margin-top:10px; display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:10px">
            <!-- Left: Save -->
            <button class="btn" name="bot_save_text" style="width:auto; padding:10px 25px">SAVE bot.php</button>
            
            <!-- Right: Action Buttons -->
            <div style="display:flex; gap:8px">
                <button type="button" onclick="document.getElementById('botTa').value=''" 
                        style="background:#E57373; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(229,115,115,0.3)">
                    <span>🗑 CLEAR</span>
                </button>
                <button type="button" onclick="navigator.clipboard.writeText(document.getElementById('botTa').value).then(()=>alert('Copied!'))" 
                        style="background:#64B5F6; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(100,181,246,0.3)">
                    <span>📋 COPY</span>
                </button>
                <button type="button" onclick="navigator.clipboard.readText().then(t => document.getElementById('botTa').value = t)" 
                        style="background:#FFB74D; color:white; border:none; border-radius:8px; padding:8px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; box-shadow:0 2px 5px rgba(255,183,77,0.3)">
                    <span>📥 PASTE</span>
                </button>
            </div>
        </div>
      </form>
    </div>

    <div class="card">
      <h3><span class='e'>📤</span> Upload bot.php</h3>
      <form method="post" enctype="multipart/form-data">
        <input type="file" name="bot_file" accept=".php,text/plain" required>
        <button class="btn" name="bot_upload_file" style="margin-top:10px">UPLOAD & REPLACE</button>
      </form>
      <div class="mini">Max <?=h(MAX_PHP_MB)?>MB • PHP မဟုတ်ရင် reject လုပ်မယ်</div>
    </div>
  <?php endif; ?>

  <?php if($view==="history"): ?>
    <div class="card"><h3><span class='e'>📜</span> Global History</h3></div>
    
    <style>
      @media (max-width: 768px) {
        .history-card {
            padding: 10px 5px !important;
            margin: 10px -10px !important; /* Pull out to edges */
            width: calc(100% + 20px) !important;
            border-radius: 0 !important;
            border-left: none !important;
            border-right: none !important;
        }
        .history-table th, .history-table td {
            padding: 12px 10px !important; /* BIGGER TOUCH TARGETS */
            font-size: 13px !important;    /* BIGGER TEXT */
            white-space: nowrap; 
        }
        /* Allow horizontal scroll to feel "big" rather than cramped */
        .history-table {
            min-width: 800px !important; /* Force wide table so it scrolls */
        }
        .history-controls {
            flex-direction: column;
            align-items: stretch !important;
        }
        .history-controls input, .history-controls select, .history-controls button {
            width: 100% !important;
            margin-bottom: 5px;
            padding: 15px !important; /* BIGGER INPUTS */
            font-size: 16px !important; /* PREVENT ZOOM ON IOS */
        }
        .hide-mobile { display: none !important; }
      }
    </style>

    <div class="card history-card">
      <div class="history-controls" style="margin-bottom:20px; display:flex; flex-direction:column; gap:15px">
         <div style="display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; gap:10px">
            <h3 style="margin:0; font-size:18px; color:var(--p-dim)">Transaction Log</h3>
            <div style="font-weight:bold; color:var(--p-dim); background:rgba(0,188,212,0.1); padding:5px 15px; border-radius:20px">
                Total: <span id="totalRows">0</span>
            </div>
         </div>

         <div style="display:flex; gap:10px; flex-wrap:wrap">
            <input type="text" id="searchInput" onkeyup="curPage=1; renderHistory()" placeholder="🔍 Search User, ID, or Item..." 
                   style="flex:1; min-width:200px; padding:12px 15px; border:2px solid var(--border); border-radius:12px; outline:none; transition:border-color 0.2s">
            
            <select id="statusFilter" onchange="curPage=1; renderHistory()" 
                    style="padding:12px 15px; border:2px solid var(--border); border-radius:12px; outline:none; background:var(--bg); cursor:pointer">
                <option value="all">All Status</option>
                <option value="success">✅ Success</option>
                <option value="fail">❌ Fail</option>
            </select>

            <button onclick="downloadHistory()" class="btn" style="width:auto; padding:10px 20px; font-size:14px; display:flex; align-items:center; gap:5px">
                <span class='e'>📥</span> Export
            </button>
         </div>
      </div>

      <div style="overflow-x:auto; border-radius:12px; border:1px solid var(--border)">
      <table class="history-table" style="width:100%; border-collapse:collapse; min-width:600px">
        <thead>
        <tr style="background:var(--bg-2); color:var(--p-dim); font-size:13px; text-transform:uppercase; letter-spacing:0.5px">
            <th style="padding:15px; text-align:left; border-bottom:2px solid var(--border)">Time</th>
            <th style="padding:15px; text-align:left; border-bottom:2px solid var(--border)">Status</th>
            <th style="padding:15px; text-align:left; border-bottom:2px solid var(--border)">User</th>
            <th style="padding:15px; text-align:left; border-bottom:2px solid var(--border)">Item</th>
            <th style="padding:15px; text-align:right; border-bottom:2px solid var(--border)">Amt</th>
            <th style="padding:15px; text-align:left; border-bottom:2px solid var(--border)">Info</th>
        </tr>
        </thead>
        <tbody id="historyBody"></tbody>
      </table>
      </div>

      <div class="pagination-controls" style="margin-top:25px; display:flex; flex-direction:column; align-items:center; gap:15px">
          <div style="display:flex; gap:5px; align-items:center">
              <button id="btnFirst" class="page-btn" onclick="setPage(1)" title="First Page">«</button>
              <button id="btnPrev" class="page-btn" onclick="changePage(-1)" title="Previous">‹</button>
              
              <div id="pageNumbers" style="display:flex; gap:5px; margin:0 10px"></div>
              
              <button id="btnNext" class="page-btn" onclick="changePage(1)" title="Next">›</button>
              <button id="btnLast" class="page-btn" onclick="changePage(1000)" title="Last Page">»</button>
          </div>
          
          <div style="display:flex; gap:15px; align-items:center; font-size:13px; color:var(--text-dim)">
              <span id="pageInfoText">Page 1 of 1</span>
              <select id="rowsPerPage" onchange="curPage=1; renderHistory()" style="background:var(--bg); color:var(--text); border:1px solid var(--border); padding:5px; border-radius:5px; outline:none">
                  <option value="10">10 rows</option>
                  <option value="25">25 rows</option>
                  <option value="50">50 rows</option>
                  <option value="100">100 rows</option>
              </select>
          </div>
      </div>

      <?php
          $rows=[];
          foreach($hist as $cid=>$list){
            if(!is_array($list)) continue;
            foreach($list as $r){
              $r["cid"] = $cid;
              // Pre-calculate user name for JS
              $r["uName"] = $users[$cid]["name"] ?? ($users[$cid]["username"] ? "@".$users[$cid]["username"] : $cid);
              $rows[] = $r;
            }
          }
          
          // Sort descending by time
          usort($rows, function($a, $b){
             $t1 = DateTime::createFromFormat("H:i d.m.Y", $a["time"]??'');
             $t2 = DateTime::createFromFormat("H:i d.m.Y", $b["time"]??'');
             if(!$t1) return 1; if(!$t2) return -1;
             return $t2 <=> $t1;
          });
      ?>

      <script>
        const historyData = <?= json_encode($rows) ?>;
        let curPage = 1;
        let rowsPerPage = 10;
        let filteredData = [];

        function renderHistory(){
            const search = document.getElementById('searchInput').value.toLowerCase().trim();
            const statusFilter = document.getElementById('statusFilter').value;
            const tbody = document.getElementById('historyBody');
            
            const rppSelect = document.getElementById('rowsPerPage');
            if(rppSelect) rowsPerPage = parseInt(rppSelect.value);
            
            tbody.innerHTML = "";

            // Filter data
            filteredData = historyData.filter(r => {
                let matchSearch = true;
                if(search){
                    const searchStr = (
                        (r.uName || "") + " " + 
                        (r.cid || "") + " " + 
                        (r.item || r.order || "") + " " +
                        (r.sn || "")
                    ).toLowerCase();
                    matchSearch = searchStr.includes(search);
                }
                
                let matchStatus = true;
                if(statusFilter !== 'all'){
                    const st = (r.status || "success").toLowerCase();
                    if(statusFilter === 'success' && st !== 'success') matchStatus = false;
                    if(statusFilter === 'fail' && st !== 'fail') matchStatus = false;
                }
                
                return matchSearch && matchStatus;
            });

            document.getElementById('totalRows').innerText = filteredData.length;

            const totalPages = Math.ceil(filteredData.length / rowsPerPage) || 1;
            if(curPage < 1) curPage = 1;
            if(curPage > totalPages) curPage = totalPages;

            // Generate Page Numbers
            let pageNumsHtml = '';
            let startP = Math.max(1, curPage - 2);
            let endP = Math.min(totalPages, curPage + 2);
            
            if(startP > 1) pageNumsHtml += `<button class="page-num" onclick="setPage(1)">1</button>`;
            if(startP > 2) pageNumsHtml += `<span style="color:var(--text-dim)">...</span>`;
            
            for(let i=startP; i<=endP; i++){
                let active = i === curPage ? 'active' : '';
                pageNumsHtml += `<button class="page-num ${active}" onclick="setPage(${i})">${i}</button>`;
            }
            
            if(endP < totalPages - 1) pageNumsHtml += `<span style="color:var(--text-dim)">...</span>`;
            if(endP < totalPages) pageNumsHtml += `<button class="page-num" onclick="setPage(${totalPages})">${totalPages}</button>`;
            
            const pnContainer = document.getElementById('pageNumbers');
            if(pnContainer) pnContainer.innerHTML = pageNumsHtml;
            
            const piText = document.getElementById('pageInfoText');
            if(piText) piText.innerText = `Page ${curPage} of ${totalPages}`;

            // Disable/Enable buttons
            const btnFirst = document.getElementById('btnFirst');
            const btnPrev = document.getElementById('btnPrev');
            const btnNext = document.getElementById('btnNext');
            const btnLast = document.getElementById('btnLast');
            
            if(btnFirst) btnFirst.disabled = curPage === 1;
            if(btnPrev) btnPrev.disabled = curPage === 1;
            if(btnNext) btnNext.disabled = curPage === totalPages;
            if(btnLast) btnLast.disabled = curPage === totalPages;

            const start = (curPage - 1) * rowsPerPage;
            const end = start + rowsPerPage;
            const pageData = filteredData.slice(start, end);

            if(pageData.length === 0){
                tbody.innerHTML = "<tr><td colspan='6' style='padding:40px; text-align:center; color:var(--text-dim); font-size:15px'>No matching records found</td></tr>";
                return;
            }

            pageData.forEach(r => {
                let st = r.status || "success";
                let isFail = st === "fail";
                let bg = isFail ? "rgba(255, 235, 238, 0.05)" : "transparent";
                let stBadge = isFail 
                    ? "<span style='background:rgba(211, 47, 47, 0.1); color:#FF5252; padding:4px 10px; border-radius:12px; font-size:11px; font-weight:bold; border:1px solid rgba(211, 47, 47, 0.3)'>❌ FAILED</span>" 
                    : "<span style='background:rgba(46, 125, 50, 0.1); color:#69F0AE; padding:4px 10px; border-radius:12px; font-size:11px; font-weight:bold; border:1px solid rgba(46, 125, 50, 0.3)'>✅ SUCCESS</span>";
                
                let info = isFail ? (r.error || "-") : (r.sn || "-");
                let amt = r.amount ? parseInt(r.amount).toLocaleString() : "0";
                let orderItem = r.order || r.item || "-";
                let uName = r.uName || "Unknown";
                
                let tr = `<tr style="border-bottom:1px solid var(--border); background:${bg}; transition:background 0.2s" onmouseover="this.style.background='var(--panel)'" onmouseout="this.style.background='${bg}'">
                    <td style="padding:15px; font-size:13px; color:var(--text-dim); white-space:nowrap">${r.time || "-"}</td>
                    <td style="padding:15px">${stBadge}</td>
                    <td style="padding:15px">
                        <div style="font-weight:bold; color:var(--p); font-size:14px">${uName}</div>
                        <div class="mini" style="font-family:monospace; color:var(--text-dim)">${r.cid}</div>
                    </td>
                    <td style="padding:15px">
                        <div style="font-weight:600; color:var(--text)">${orderItem}</div>
                    </td>
                    <td style="padding:15px; text-align:right; font-family:'Fredoka',sans-serif; font-weight:bold; color:var(--text)">${amt}</td>
                    <td style="padding:15px; font-size:12px; color:var(--text-dim); max-width:200px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap" title="${info}">${info}</td>
                </tr>`;
                tbody.innerHTML += tr;
            });
        }

        function changePage(d){
            const totalPages = Math.ceil(filteredData.length / rowsPerPage) || 1;
            let newPage = curPage;
            
            if(d === 1000) newPage = totalPages;
            else if(d === -1000) newPage = 1;
            else newPage += d;

            if(newPage >= 1 && newPage <= totalPages){
                curPage = newPage;
                renderHistory();
            }
        }
        
        function setPage(p){
            curPage = p;
            renderHistory();
        }

        function downloadHistory(){
            if(filteredData.length === 0) { alert("No history to export!"); return; }
            let txt = "Time | Status | User ID | User | Item | Amount | Info\n";
            txt += "--------------------------------------------------------------------------------\n";
            filteredData.forEach(r => {
                let st = r.status || "success";
                let info = st === "fail" ? (r.error||"") : (r.sn||"");
                let u = (r.uName||"").replace(/\|/g, "");
                let item = (r.order||r.item||"").replace(/\|/g, "");
                txt += `${r.time} | ${st} | ${r.cid} | ${u} | ${item} | ${r.amount} | ${info}\n`;
            });
            
            const blob = new Blob([txt], { type: 'text/plain' });
            const a = document.createElement('a');
            a.href = URL.createObjectURL(blob);
            a.download = "history_export_" + new Date().toISOString().slice(0,10) + ".txt";
            a.click();
        }

        // Init
        renderHistory();
      </script>
      <style>
        .page-btn {
            background: var(--panel);
            border: 1px solid var(--border);
            color: var(--text);
            width: 36px;
            height: 36px;
            border-radius: 50%;
            cursor: pointer;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
        }
        .page-btn:hover:not(:disabled) {
            background: var(--p);
            color: white;
            border-color: var(--p);
        }
        .page-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .page-num {
            background: transparent;
            border: none;
            color: var(--text-dim);
            width: 32px;
            height: 32px;
            border-radius: 50%;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.2s;
        }
        .page-num:hover { background: rgba(255,255,255,0.1); color: var(--text); }
        .page-num.active {
            background: var(--p);
            color: white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.3);
        }
      </style>
    </div>
  <?php endif; ?>

  <?php if($view==="topup" || $view==="topup_config"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <div class="card">
      <h3><span class='e'>💳</span> Page Configurations</h3>
      <?php if(isset($msg)) echo "<div class='ok' style='padding:10px;margin-bottom:10px;background:#C8E6C9;color:#2E7D32;border-radius:8px'>$msg</div>"; ?>
      <?php if(isset($err)) echo "<div class='bad' style='padding:10px;margin-bottom:10px;background:#FFCDD2;color:#C62828;border-radius:8px'>$err</div>"; ?>
      
      <form method="post" style="margin-bottom:30px">
        <label style="font-weight:bold;display:block;margin-bottom:5px;color:var(--p-dim)">TopUp Instructions (Modal):</label>
        <div class="mini" style="margin-bottom:5px">Shown when user clicks "Top Up Balance"</div>
        <textarea name="topup_msg_text" style="width:100%;height:200px;font-family:monospace;white-space:pre-wrap;padding:15px;border:2px solid var(--border);border-radius:15px;outline:none;resize:vertical;font-size:14px" placeholder="Enter HTML content..."><?= htmlspecialchars($topup_msg_now) ?></textarea>
        <button name="save_topup_msg" class="btn" style="margin-top:10px">💾 Save TopUp Message</button>
      </form>

      <hr style="border:0; border-top:2px dashed #eee; margin:20px 0">

      <h3><span class='e'>💳</span> Payment Methods</h3>
      <div style="margin-bottom:20px">
          <?php if(!empty($pms_now)): ?>
          <table style="width:100%; border-collapse:collapse; margin-bottom:15px; border-radius:10px; overflow:hidden; border:1px solid #eee">
            <tr style="background:#FCE4EC; text-align:left; color:#880E4F">
              <th style="padding:12px">Method</th>
              <th style="padding:12px">Number</th>
              <th style="padding:12px">Acc Name</th>
              <th style="padding:12px">Note</th>
              <th style="padding:12px">Action</th>
            </tr>
            <?php foreach($pms_now as $pm): ?>
            <tr style="border-bottom:1px solid #f0f0f0">
                <td style="padding:12px; font-weight:bold"><?= htmlspecialchars($pm['name']) ?></td>
                <td style="padding:12px; font-family:monospace"><?= htmlspecialchars($pm['no']) ?></td>
                <td style="padding:12px"><?= htmlspecialchars($pm['acc_name']) ?></td>
                <td style="padding:12px; color:#666; font-size:13px"><?= htmlspecialchars($pm['note']) ?></td>
                <td style="padding:12px">
                    <form method="post" onsubmit="return confirm('Delete this method?');" style="margin:0">
                        <input type="hidden" name="del_id" value="<?= $pm['id'] ?>">
                        <button name="del_payment_method" class="btn-sm" style="background:#E57373; color:white; border:none; padding:5px 10px; cursor:pointer">🗑</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
          </table>
          <?php else: ?>
            <div style="padding:20px; text-align:center; color:#999; border:1px dashed #ccc; border-radius:10px; margin-bottom:15px">No payment methods added yet.</div>
          <?php endif; ?>

          <form method="post" style="background:#FAFAFA; padding:20px; border-radius:15px; border:1px solid #eee">
             <h4 style="margin-top:0; color:var(--p-dim)"><span class='e'>➕</span> Add Payment Method</h4>
             <div class="row">
                <div style="flex:1; min-width:200px">
                    <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em; display:block; margin-bottom:4px">Method Name</label>
                    <input name="pm_name" placeholder="e.g. Kpay, Wave" required style="width:100%">
                </div>
                <div style="flex:1; min-width:200px">
                    <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em; display:block; margin-bottom:4px">Number</label>
                    <input name="pm_no" placeholder="e.g. 09xxxxxxxxx" required style="width:100%">
                </div>
             </div>
             <div class="row">
                <div style="flex:1; min-width:200px">
                    <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em; display:block; margin-bottom:4px">Account Name <span style="font-weight:normal;color:#999">(Optional)</span></label>
                    <input name="pm_acc_name" placeholder="e.g. Mg Kyaw" style="width:100%">
                </div>
                <div style="flex:1; min-width:200px">
                    <label style="font-weight:bold; color:var(--p-dim); font-size:0.9em; display:block; margin-bottom:4px">Note <span style="font-weight:normal;color:#999">(Optional)</span></label>
                    <input name="pm_note" placeholder="e.g. Personal Account" style="width:100%">
                </div>
             </div>
             <button name="add_payment_method" class="btn" style="width:auto; margin-bottom:0; margin-top:10px">Add Method</button>
          </form>
      </div>

      <hr style="border:0; border-top:2px dashed #eee; margin:20px 0">

      <form method="post">
        <label style="font-weight:bold;display:block;margin-bottom:5px;color:var(--p-dim)">Balance Page Message:</label>
        <div class="mini" style="margin-bottom:5px">Shown below the Top Up button on the dashboard</div>
        <textarea name="balance_msg_text" style="width:100%;height:200px;font-family:monospace;white-space:pre-wrap;padding:15px;border:2px solid var(--border);border-radius:15px;outline:none;resize:vertical;font-size:14px" placeholder="Enter HTML content..."><?= htmlspecialchars($balance_msg_now) ?></textarea>
        <button name="save_balance_msg" class="btn" style="margin-top:10px">💾 Save Balance Message</button>
      </form>


    </div>
  <?php endif; ?>

  <?php if($view==="logs"): ?>
    <div class="card">
        <div style="display:flex; flex-wrap:wrap; gap:10px; justify-content:space-between; align-items:center; margin-bottom:15px">
            <h3 style="margin:0"><span class='e'>📝</span> System Logs (Smile Debug)</h3>
            <div style="display:flex; flex-wrap:wrap; gap:8px; align-items:center">
                <input id="logSearch" placeholder="Search..." oninput="filterLogs()" style="margin:0; background:var(--bg); border:1px solid var(--border); color:var(--text); padding:8px 12px; border-radius:12px">
                <select id="logLimitSel" onchange="changeLogLimit()" style="margin:0; background:var(--bg); border:1px solid var(--border); color:var(--text); padding:8px 12px; border-radius:12px">
                    <?php $cur_limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20; foreach([20,50,100] as $opt){ $sel = ($cur_limit==$opt) ? "selected" : ""; echo "<option value='$opt' $sel>$opt</option>"; } ?>
                </select>
                <button type="button" class="btn-sm" onclick="exportLogs()" style="width:auto"><span class='e'>📥</span> Export</button>
                <form method="post" onsubmit="return confirm('Clear all logs?');" style="margin:0">
                    <button name="clear_logs" class="btn-sm" style="background:#E57373;color:white;border:none;padding:8px 15px;border-radius:20px;font-weight:bold"><span class='e'>🗑</span> Clear Logs</button>
                </form>
            </div>
        </div>

        <?php if(isset($msg)) echo "<div class='ok' style='padding:10px;margin-bottom:10px;background:#C8E6C9;color:#2E7D32;border-radius:8px'>$msg</div>"; ?>

        <div style="background:var(--panel); border-radius:15px; border:1px solid var(--border); overflow-x:auto; box-shadow:var(--shadow); -webkit-overflow-scrolling: touch;">
            <table id="logTable" style="width:100%; min-width:600px; border-collapse:collapse; font-size:13px">
                <thead>
                    <tr style="background:linear-gradient(135deg, var(--p), var(--p-dim)); color:white; text-align:left">
                        <th style="padding:15px; font-weight:600; width:160px; position:sticky; top:0">Time</th>
                        <th style="padding:15px; font-weight:600; position:sticky; top:0">Message</th>
                        <th style="padding:15px; font-weight:600; position:sticky; top:0">Data</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $logFile = __DIR__."/smile_debug.log";
                    if(!file_exists($logFile) || filesize($logFile) == 0){
                        echo "<tr><td colspan='3' style='padding:30px; text-align:center; color:#999; font-style:italic'>No logs found.</td></tr>";
                    } else {
                        $all_lines = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                        $all_lines = array_reverse($all_lines); // Newest first
                        $limit = isset($_GET['limit']) ? max(1,min(200,(int)$_GET['limit'])) : 20;
                        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                        if($page < 1) $page = 1;
                        $total_items = count($all_lines);
                        $total_pages = ceil($total_items / $limit);
                        if($page > $total_pages && $total_pages > 0) $page = $total_pages;
                        $offset = ($page - 1) * $limit;
                        $paged_lines = array_slice($all_lines, $offset, $limit);
                        foreach($paged_lines as $line){
                            $parts = explode(' | ', $line, 3);
                            $time = $parts[0] ?? "-";
                            $msg_log = $parts[1] ?? "-";
                            $data = $parts[2] ?? "";
                            if(!empty($data) && ($json = json_decode($data, true))){
                                $data = "<pre style='margin:0; max-height:160px; overflow:auto; font-size:11px; font-family:Consolas,monospace; background:var(--bg); padding:8px; border-radius:6px; border:1px solid var(--border); color:var(--text)'>".json_encode($json, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)."</pre>";
                            } else if(!empty($data)) {
                                $data = "<span style='color:var(--text); font-family:monospace'>$data</span>";
                            }

                            echo "<tr style='border-bottom:1px solid #f0f0f0; transition:background 0.2s'>";
                            echo "<td style='padding:12px 15px; white-space:nowrap; color:#00838F; font-size:12px'>$time</td>";
                            echo "<td style='padding:12px 15px; font-weight:500; color:#37474F'>$msg_log</td>";
                            echo "<td style='padding:12px 15px; word-break:break-all'>$data<div style='margin-top:8px; display:flex; gap:8px; flex-wrap:wrap'><button type='button' class='btn-sm' style='width:auto' onclick='copyLogRow(this)'><span class=\"e\">📋</span> Copy Row</button><button type='button' class='btn-sm' style='width:auto' onclick='toggleData(this)'><span class=\"e\">🔍</span> Expand</button></div></td>";
                            echo "</tr>";
                        }
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <?php if(isset($total_pages) && $total_pages > 1): ?>
        <div style="display:flex; justify-content:center; align-items:center; gap:10px; margin-top:20px">
            <?php if($page > 1): ?>
                <a href="?view=logs&page=<?= $page-1 ?>&limit=<?= $limit ?>" class="page-btn">◀ Prev</a>
            <?php else: ?>
                <button class="page-btn" disabled style="opacity:0.5; cursor:not-allowed">◀ Prev</button>
            <?php endif; ?>

            <span style="font-weight:bold; color:var(--p-dim); background:white; padding:5px 15px; border-radius:15px; border:1px solid var(--border)">
                Page <?= $page ?> of <?= $total_pages ?>
            </span>

            <?php if($page < $total_pages): ?>
                <a href="?view=logs&page=<?= $page+1 ?>&limit=<?= $limit ?>" class="page-btn">Next ▶</a>
            <?php else: ?>
                <button class="page-btn" disabled style="opacity:0.5; cursor:not-allowed">Next ▶</button>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <div class="mini" style="margin-top:15px; text-align:center; color:#90A4AE">
            Total Logs: <?= number_format($total_items ?? 0) ?>
        </div>
        <script>
          function filterLogs(){
            const q = (document.getElementById('logSearch').value || '').toLowerCase();
            const rows = document.querySelectorAll('#logTable tbody tr');
            rows.forEach(r=>{
              const t = r.innerText.toLowerCase();
              r.style.display = q && !t.includes(q) ? 'none' : '';
            });
          }
         function exportLogs(){
            const rows = Array.from(document.querySelectorAll('#logTable tbody tr')).filter(r=>r.style.display!=='none');
            let csv = 'Time,Message,Data\n';
            rows.forEach(r=>{
              const cells = r.querySelectorAll('td');
              const vals = Array.from(cells).map(c=>{
                const txt = c.innerText.replace(/\r?\n+/g,' ').replace(/"/g,'""');
                return `"${txt}"`;
              });
              csv += vals.join(',') + '\n';
            });
            const blob = new Blob([csv], {type:'text/csv'});
            const a = document.createElement('a');
            a.href = URL.createObjectURL(blob);
            a.download = 'smile_logs_page_'+(<?= $page ?? 1 ?>)+'.csv';
            a.click();
          }
          function changeLogLimit(){
            const v = document.getElementById('logLimitSel').value;
            const params = new URLSearchParams(window.location.search);
            params.set('view','logs');
            params.set('limit', v);
            params.set('page','1');
            window.location.search = params.toString();
          }
          function copyLogRow(btn){
            const tr = btn.closest('tr');
            const cells = tr ? tr.querySelectorAll('td') : [];
            let txt = '';
            cells.forEach((c,i)=>{
              if(i<3){
                txt += c.innerText.trim();
                if(i<2) txt += ' | ';
              }
            });
            navigator.clipboard.writeText(txt);
          }
          function toggleData(btn){
            const td = btn.closest('td');
            if(!td) return;
            const pre = td.querySelector('pre');
            if(pre){
              if(pre.style.maxHeight && pre.style.maxHeight!=='none'){
                pre.style.maxHeight='none';
                btn.innerText='Collapse';
              } else {
                pre.style.maxHeight='160px';
                btn.innerText='Expand';
              }
            }
          }
        </script>
        <style>
          #logTable tbody tr:nth-child(even){background:rgba(255,255,255,0.03)}
          #logTable tbody tr:hover{background:rgba(233,30,99,0.08)}
          #logTable td{border-bottom:1px solid var(--border)}
        </style>
    </div>
  <?php endif; ?>

  <?php if($view==="calculator"): ?>
    <?php
    $plansFile = __DIR__ . "/data/calculator_plans.json";
    $type = $_GET['type'] ?? 'brl';
    if(!in_array($type, ['brl', 'ols'])) $type = 'brl';
    
    $allPlans = file_exists($plansFile) ? json_decode(file_get_contents($plansFile), true) : [];
    if(isset($allPlans[0])){ $allPlans = ['brl'=>$allPlans, 'ols'=>$allPlans]; }
    if(!isset($allPlans['brl'])) $allPlans['brl'] = [];
    if(!isset($allPlans['ols'])) $allPlans['ols'] = [];

    // Handle Add Plan
    if(isset($_POST['add_plan'])){
        $pType = $_POST['plan_type'];
        $dia = (int)$_POST['dia'];
        $coin = (float)$_POST['coin'];
        
        if($dia > 0 && $coin > 0 && isset($allPlans[$pType])){
            $nextNo = count($allPlans[$pType]) + 1;
            $allPlans[$pType][] = ["no" => $nextNo, "dia" => $dia, "coin" => $coin];
            file_put_contents($plansFile, json_encode($allPlans, JSON_PRETTY_PRINT));
            echo "<div class='alert success'>Plan added to ".strtoupper($pType)."! ✅</div>";
        }
    }

    // Handle Delete Plan
    if(isset($_GET['del_plan'])){
        $delIdx = (int)$_GET['del_plan'];
        $delType = $_GET['dtype'] ?? 'brl';
        
        if(isset($allPlans[$delType][$delIdx])){
            array_splice($allPlans[$delType], $delIdx, 1);
            foreach($allPlans[$delType] as $k => &$v){ $v['no'] = $k + 1; }
            file_put_contents($plansFile, json_encode($allPlans, JSON_PRETTY_PRINT));
            echo "<script>window.location='admin.php?view=calculator&type=$delType';</script>";
        }
    }
    
    // Handle Edit Plan
    if(isset($_POST['edit_plan'])){
        $pType = $_POST['plan_type'];
        $idx = (int)$_POST['plan_idx'];
        $dia = (int)$_POST['dia'];
        $coin = (float)$_POST['coin'];
        
        if(isset($allPlans[$pType][$idx])){
            $allPlans[$pType][$idx]['dia'] = $dia;
            $allPlans[$pType][$idx]['coin'] = $coin;
            file_put_contents($plansFile, json_encode($allPlans, JSON_PRETTY_PRINT));
            echo "<div class='alert success'>Plan updated! ✅</div>";
        }
    }

    $currentPlans = $allPlans[$type];
    ?>

    <div style="display:flex; gap:10px; margin-bottom:20px; border-bottom:1px solid #444; padding-bottom:10px">
        <a href="?view=calculator&type=brl" class="btn" style="background:<?= $type=='brl'?'var(--p)':'#444' ?>; border:none">BRL Coin</a>
        <a href="?view=calculator&type=ols" class="btn" style="background:<?= $type=='ols'?'var(--p)':'#444' ?>; border:none">OLS Coin</a>
    </div>

    <div class="card">
        <h2>MLBB <?= strtoupper($type) ?> Coin Table Calculator</h2>
        <p style="text-align:center; opacity:0.8;">SmileOne Code ဈေး + အမြတ် % နဲ့ MMK အလိုအလျောက်တွက်ချက်ပေးပါတယ်။</p>
        
        <div style="display:flex; gap:20px; flex-wrap:wrap; justify-content:center; margin-bottom:20px">
            <div style="display:flex; flex-direction:column; gap:5px">
                <label style="color:var(--p); font-weight:bold">SmileOne Code Price (1000 Coin)</label>
                <input type="number" id="coinPrice" placeholder="Enter Price (e.g. 4500)" oninput="calcCoin()" style="padding:10px; border-radius:5px; border:1px solid var(--border); background:var(--bg); color:var(--text); width:200px">
            </div>
            <div style="display:flex; flex-direction:column; gap:5px">
                <label style="color:var(--p); font-weight:bold">Profit %</label>
                <input type="number" id="profitPercent" placeholder="Enter % (e.g. 10)" value="0" oninput="calcCoin()" style="padding:10px; border-radius:5px; border:1px solid var(--border); background:var(--bg); color:var(--text); width:200px">
            </div>
        </div>

        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Dia Plan</th>
                        <th>Coin</th>
                        <th>MMK (Cost)</th>
                        <th>Profit</th>
                        <th>Total (Sell)</th>
                    </tr>
                </thead>
                <tbody id="coinTableBody"></tbody>
            </table>
        </div>
    </div>
    
    <!-- Plan Management Section -->
    <div class="card" style="margin-top:20px">
        <h3><span class="e">⚙️</span> Manage <?= strtoupper($type) ?> Plans</h3>
        
        <!-- Add Plan Form -->
        <form method="POST" style="display:flex; gap:10px; flex-wrap:wrap; align-items:flex-end; margin-bottom:20px; background:rgba(0,0,0,0.2); padding:15px; border-radius:10px">
            <input type="hidden" name="plan_type" value="<?= $type ?>">
            <div style="flex:1; min-width:120px">
                <label style="font-size:12px; color:#AAA">Diamonds</label>
                <input type="number" name="dia" placeholder="Diamonds" required style="width:100%; margin:0">
            </div>
            <div style="flex:1; min-width:120px">
                <label style="font-size:12px; color:#AAA">Coins</label>
                <input type="number" step="0.1" name="coin" placeholder="Coins" required style="width:100%; margin:0">
            </div>
            <button type="submit" name="add_plan" style="width:auto; padding:10px 20px; height:46px"><span class="e">➕</span> Add</button>
        </form>

        <!-- Edit/Delete List -->
        <div class="table-wrap" style="max-height:400px; overflow-y:auto">
            <table>
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Diamonds</th>
                        <th>Coins</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($currentPlans as $idx => $plan): ?>
                    <tr>
                        <td><?= $plan['no'] ?></td>
                        <td>
                            <form method="POST" style="display:inline" id="form_<?= $idx ?>">
                                <input type="hidden" name="plan_type" value="<?= $type ?>">
                                <input type="hidden" name="plan_idx" value="<?= $idx ?>">
                                <input type="number" name="dia" value="<?= $plan['dia'] ?>" style="width:80px; padding:5px; margin:0; background:rgba(0,0,0,0.2); border:1px solid #444; color:white">
                            </form>
                        </td>
                        <td>
                            <input type="number" step="0.1" name="coin" form="form_<?= $idx ?>" value="<?= $plan['coin'] ?>" style="width:80px; padding:5px; margin:0; background:rgba(0,0,0,0.2); border:1px solid #444; color:white">
                        </td>
                        <td>
                            <button type="submit" name="edit_plan" form="form_<?= $idx ?>" style="width:auto; padding:5px 10px; font-size:12px; background:var(--p-dim)">Save</button>
                            <a href="?view=calculator&del_plan=<?= $idx ?>&dtype=<?= $type ?>" onclick="return confirm('Delete this plan?')" style="color:#FF5252; text-decoration:none; margin-left:10px; font-weight:bold">Delete</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
    const coinPlans = <?= json_encode($currentPlans) ?>;

    function calcCoin() {
        const coinPrice = parseFloat(document.getElementById('coinPrice').value) || 0;
        const profitPercent = parseFloat(document.getElementById('profitPercent').value) || 0;
        
        const tbody = document.getElementById('coinTableBody');
        tbody.innerHTML = '';

        coinPlans.forEach(plan => {
            let cost = (plan.coin / 1000) * coinPrice;
            let profit = cost * (profitPercent / 100);
            let total = cost + profit;
            
            let row = `<tr>
                <td>${plan.no}</td>
                <td>${plan.dia} Diamonds</td>
                <td>${plan.coin}</td>
                <td>${Math.round(cost).toLocaleString()} Ks</td>
                <td>${Math.round(profit).toLocaleString()} Ks</td>
                <td><b>${Math.round(total).toLocaleString()} Ks</b></td>
            </tr>`;
            tbody.innerHTML += row;
        });
    }
    calcCoin();
    </script>
  <?php endif; ?>

  <?php if($view==="buttons"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    
    <?php
    $btnFile = __DIR__."/bot_buttons.json";
    if(isset($_POST['save_buttons'])){
        $json = $_POST['buttons_json'] ?? '{}';
        $decoded = json_decode($json, true);
        if($decoded){
            write_text_atomic($btnFile, json_encode($decoded, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
            echo "<div class='alert success'>Buttons updated successfully!</div>";
        } else {
            echo "<div class='alert error'>Invalid JSON format!</div>";
        }
    }
    
    $currentBtns = file_exists($btnFile) ? file_get_contents($btnFile) : '{}';
    ?>

    <style>
        :root { --p-light: #64B5F6; --bg-dark: #1e1e1e; --bg-card: #252525; }
        .tab-container { display:flex; gap:10px; border-bottom:2px solid #333; margin-bottom:20px; padding-bottom:0 }
        .tab-btn { 
            padding: 12px 24px; 
            cursor: pointer; 
            background: transparent; 
            color: #888; 
            border: none; 
            border-bottom: 3px solid transparent; 
            font-weight: 600; 
            font-size: 14px; 
            transition: all 0.3s ease; 
            position: relative;
            top: 2px;
        }
        .tab-btn:hover { color: #ccc }
        .tab-btn.active { 
            color: var(--p); 
            border-bottom-color: var(--p); 
            background: transparent;
        }
        
        .editor-panel { 
            display: none; 
            animation: fadeIn 0.3s ease;
        }
        .editor-panel.active { display: block }
        @keyframes fadeIn { from { opacity:0; transform:translateY(5px) } to { opacity:1; transform:translateY(0) } }

        .row-container { 
            background: var(--bg-card); 
            padding: 20px; 
            margin-bottom: 15px; 
            border-radius: 12px; 
            border: 1px solid #333; 
            position: relative;
            transition: all 0.2s ease;
        }
        .row-container:hover { border-color: #444; box-shadow: 0 5px 15px rgba(0,0,0,0.1) }
        
        .btn-list { display: flex; flex-wrap: wrap; gap: 15px; }
        
        .btn-item { 
            background: #1a1a1a; 
            padding: 15px; 
            border-radius: 10px; 
            border: 1px solid #333; 
            display: flex; 
            flex-direction: column; 
            gap: 10px; 
            min-width: 220px; 
            flex: 1;
            transition: all 0.2s ease;
            position: relative;
        }
        .btn-item:hover { 
            transform: translateY(-3px); 
            box-shadow: 0 5px 15px rgba(0,0,0,0.2); 
            border-color: #555;
        }
        
        .btn-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 5px }
        .btn-label { font-size: 11px; color: var(--p); font-weight: 700; letter-spacing: 0.5px; text-transform: uppercase }
        
        .del-btn { 
            color: #ff5252; 
            cursor: pointer; 
            font-size: 16px; 
            width: 24px; 
            height: 24px; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            border-radius: 50%; 
            background: rgba(255,82,82,0.1);
            transition: all 0.2s;
        }
        .del-btn:hover { background: #ff5252; color: white }
        
        .form-group label { display: block; font-size: 10px; color: #888; margin-bottom: 3px }
        .btn-item input, .btn-item select { 
            width: 100%; 
            padding: 10px; 
            border-radius: 8px; 
            border: 1px solid #333; 
            background: #222; 
            color: #eee; 
            font-size: 13px; 
            transition: all 0.2s;
        }
        .btn-item input:focus, .btn-item select:focus { 
            border-color: var(--p); 
            background: #151515; 
            outline: none; 
            box-shadow: 0 0 0 3px rgba(33, 150, 243, 0.1); 
        }
        
        .add-btn-mini { 
            background: rgba(255,255,255,0.02); 
            color: #888; 
            border: 2px dashed #444; 
            border-radius: 10px; 
            padding: 10px; 
            cursor: pointer; 
            font-size: 13px; 
            font-weight: 600;
            display: flex; 
            align-items: center; 
            justify-content: center; 
            min-height: 140px; 
            min-width: 100px;
            transition: all 0.2s;
        }
        .add-btn-mini:hover { 
            background: rgba(33,150,243,0.05); 
            border-color: var(--p); 
            color: var(--p); 
            transform: scale(0.98);
        }
        
        .row-actions { 
            position: absolute; 
            top: 10px; 
            right: 10px; 
            opacity: 0.5; 
            transition: 0.2s; 
        }
        .row-container:hover .row-actions { opacity: 1 }
        
        .save-bar {
            background: linear-gradient(to right, #2c3e50, #3498db);
            padding: 15px 25px;
            border-radius: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 30px;
            box-shadow: 0 10px 30px rgba(52, 152, 219, 0.3);
        }
        .btn-glow {
            background: white;
            color: #3498db;
            border: none;
            padding: 10px 30px;
            border-radius: 30px;
            font-weight: 800;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            transition: all 0.3s;
            cursor: pointer;
            text-transform: uppercase;
            font-size: 12px;
            letter-spacing: 1px;
        }
        .btn-glow:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.3);
            background: #f0f8ff;
        }
    </style>

    <div class="card" style="padding:0; background:transparent; box-shadow:none">
        <div style="display:flex; align-items:center; justify-content:space-between; margin-bottom:20px">
            <div>
                <h3 style="margin:0; font-size:24px; background: -webkit-linear-gradient(45deg, #2196F3, #00BCD4); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><span style="-webkit-text-fill-color: initial">🎛️</span> Button Studio</h3>
                <div class="mini">Design your bot's interactive menu</div>
            </div>
            <div style="background:#333; padding:5px 15px; border-radius:20px; font-size:12px; color:#aaa">
                Live Preview: <span style="color:#4CAF50">● Active</span>
            </div>
        </div>
        
        <form method="post" id="btnForm">
            <!-- Tabs -->
            <div class="tab-container">
                <button type="button" class="tab-btn active" onclick="openTab('start')">🏠 MAIN MENU</button>
                <button type="button" class="tab-btn" onclick="openTab('pay')">💰 PAY MENU</button>
                <button type="button" class="tab-btn" onclick="openTab('json')">⚙️ JSON SOURCE</button>
            </div>

            <!-- Start Editor -->
            <div id="tab-start" class="editor-panel active">
                <div id="rows-start"></div>
                <button type="button" class="btn" style="width:100%; margin-top:20px; padding:15px; border:2px dashed #444; background:transparent; color:#666; font-weight:600; border-radius:12px; transition:0.2s" onmouseover="this.style.borderColor='#666';this.style.color='#888'" onmouseout="this.style.borderColor='#444';this.style.color='#666'" onclick="addNewRow('start')">
                    + ADD NEW ROW
                </button>
            </div>

            <!-- Pay Editor -->
            <div id="tab-pay" class="editor-panel">
                <div id="rows-pay"></div>
                <button type="button" class="btn" style="width:100%; margin-top:20px; padding:15px; border:2px dashed #444; background:transparent; color:#666; font-weight:600; border-radius:12px; transition:0.2s" onmouseover="this.style.borderColor='#666';this.style.color='#888'" onmouseout="this.style.borderColor='#444';this.style.color='#666'" onclick="addNewRow('pay')">
                    + ADD NEW ROW
                </button>
            </div>

            <!-- JSON Editor -->
            <div id="tab-json" class="editor-panel">
                <div style="margin-bottom:10px; font-weight:bold; color:var(--p)">Raw Configuration</div>
                <textarea name="buttons_json" id="jsonEditor" oninput="parseJSONtoUI()" style="width:100%; height:500px; padding:20px; border-radius:15px; background:#1e1e1e; color:#a6accd; font-family:'Fira Code', monospace; border:1px solid #333; resize:vertical; line-height:1.5"><?=h($currentBtns)?></textarea>
                <div style="margin-top:15px; display:flex; gap:10px">
                     <button type="button" onclick="formatJSON()" class="btn-sm" style="background:#2196F3; color:white; border:none; padding:10px 20px; border-radius:8px; cursor:pointer; font-weight:600">✨ Beautify JSON</button>
                     <button type="button" onclick="resetDefault()" class="btn-sm" style="background:#FF9800; color:white; border:none; padding:10px 20px; border-radius:8px; cursor:pointer; font-weight:600">🔄 Reset to Factory</button>
                </div>
            </div>

            <div class="save-bar">
                <div style="color:white">
                    <div style="font-weight:bold; font-size:14px">Ready to publish?</div>
                    <div style="font-size:11px; opacity:0.8">Changes will be live on Telegram immediately.</div>
                </div>
                <button type="submit" name="save_buttons" class="btn-glow">
                    💾 Publish Changes
                </button>
            </div>
        </form>
    </div>

    <script>
    let config = { start: [], pay: [], prices: {} };

    // Initialize
    document.addEventListener('DOMContentLoaded', () => {
        parseJSONtoUI();
    });

    function openTab(tabName) {
        document.querySelectorAll('.editor-panel').forEach(el => el.classList.remove('active'));
        document.querySelectorAll('.tab-btn').forEach(el => el.classList.remove('active'));
        document.getElementById('tab-' + tabName).classList.add('active');
        document.querySelector(`.tab-btn[onclick="openTab('${tabName}')"]`).classList.add('active');
    }

    function parseJSONtoUI() {
        try {
            const jsonVal = document.getElementById('jsonEditor').value;
            config = JSON.parse(jsonVal);
            if(!config.start) config.start = [];
            if(!config.pay) config.pay = [];
            renderRows('start');
            renderRows('pay');
        } catch(e) {
            console.log("JSON Parse Error (waiting for valid JSON): " + e.message);
        }
    }

    function syncUItoJSON() {
        const jsonStr = JSON.stringify(config, null, 2);
        document.getElementById('jsonEditor').value = jsonStr;
    }

    function renderRows(type) {
        const container = document.getElementById('rows-' + type);
        container.innerHTML = '';
        
        config[type].forEach((row, rowIndex) => {
            const rowDiv = document.createElement('div');
            rowDiv.className = 'row-container';
            
            let btnsHtml = '';
            row.forEach((btn, btnIndex) => {
                const isUrl = btn.url !== undefined;
                const val = isUrl ? btn.url : btn.callback_data;
                const typeSel = isUrl ? 'url' : 'callback_data';
                
                btnsHtml += `
                    <div class="btn-item">
                        <div class="btn-header">
                            <span class="btn-label">BUTTON ${btnIndex+1}</span>
                            <span class="del-btn" onclick="removeBtn('${type}', ${rowIndex}, ${btnIndex})" title="Remove Button">✕</span>
                        </div>
                        
                        <div class="form-group">
                            <label>Label Text</label>
                            <input type="text" placeholder="e.g. 💰 Balance" value="${btn.text || ''}" oninput="updateBtn('${type}', ${rowIndex}, ${btnIndex}, 'text', this.value)">
                        </div>

                        <div class="form-group">
                            <label>Action Type</label>
                            <select onchange="updateBtnType('${type}', ${rowIndex}, ${btnIndex}, this.value)">
                                <option value="callback_data" ${!isUrl?'selected':''}>⚡ Callback Action</option>
                                <option value="url" ${isUrl?'selected':''}>🔗 Open URL</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Action Value</label>
                            <input type="text" placeholder="e.g. SYS:BAL" value="${val || ''}" oninput="updateBtn('${type}', ${rowIndex}, ${btnIndex}, 'value', this.value)">
                        </div>
                    </div>
                `;
            });

            // Add button placeholder
            btnsHtml += `
                <div class="add-btn-mini" onclick="addBtn('${type}', ${rowIndex})">
                    <div style="text-align:center">
                        <div style="font-size:24px; margin-bottom:5px">+</div>
                        <div>ADD BTN</div>
                    </div>
                </div>
            `;

            rowDiv.innerHTML = `
                <div class="btn-list">${btnsHtml}</div>
                <div class="row-actions">
                    <button type="button" class="btn-sm red" style="padding:5px 10px; font-size:10px; border-radius:20px; background:#ff5252; color:white; border:none; cursor:pointer; font-weight:bold" onclick="removeRow('${type}', ${rowIndex})">DELETE ROW</button>
                </div>
            `;
            container.appendChild(rowDiv);
        });
    }

    /* --- Actions --- */
    // ... (rest of the JS functions remain mostly the same, but re-included for completeness if I replace the whole block)
    function addNewRow(type) { config[type].push([]); renderRows(type); syncUItoJSON(); }
    function removeRow(type, rowIndex) { if(!confirm('Delete this entire row?')) return; config[type].splice(rowIndex, 1); renderRows(type); syncUItoJSON(); }
    function addBtn(type, rowIndex) { config[type][rowIndex].push({ text: "New Button", callback_data: "NAV:HOME" }); renderRows(type); syncUItoJSON(); }
    function removeBtn(type, rowIndex, btnIndex) { config[type][rowIndex].splice(btnIndex, 1); renderRows(type); syncUItoJSON(); }
    function updateBtn(type, rowIndex, btnIndex, field, value) {
        if(field === 'text') config[type][rowIndex][btnIndex].text = value;
        else if (field === 'value') {
            const btn = config[type][rowIndex][btnIndex];
            if(btn.url !== undefined) btn.url = value;
            else btn.callback_data = value;
        }
        syncUItoJSON();
    }
    function updateBtnType(type, rowIndex, btnIndex, newType) {
        const btn = config[type][rowIndex][btnIndex];
        const currentVal = btn.url || btn.callback_data || "";
        const newBtn = { text: btn.text };
        if(newType === 'url') newBtn.url = currentVal;
        else newBtn.callback_data = currentVal;
        config[type][rowIndex][btnIndex] = newBtn;
        renderRows(type); syncUItoJSON();
    }
    function formatJSON(){
        const el = document.getElementById('jsonEditor');
        try { const v = JSON.parse(el.value); el.value = JSON.stringify(v, null, 2); parseJSONtoUI(); } 
        catch(e){ alert('Invalid JSON: '+e.message); }
    }
    function resetDefault(){
        if(!confirm('Reset to default buttons?')) return;
        const def = {
          "start": [
            [{"text": "💳 PUBG Auto Topup", "callback_data": "NAV:PUBG_TOPUP"}, {"text": "🎟️ PUBG Code Auto", "callback_data": "NAV:PUBG_CODE"}],
            [{"text": "🎮 Mobile Legends", "callback_data": "NAV:ML"}, {"text": "💰 Balance", "callback_data": "SYS:BAL"}],
            [{"text": "📜 History", "callback_data": "SYS:HIS"}, {"text": "🔑 API Key", "callback_data": "SYS:API"}],
            [{"text": "📞 Contact", "url": "https://t.me/foxadm25"}, {"text": "🎫 Topup Code", "callback_data": "NAV:TOPUP_CODE"}]
          ],
          "pay": [
            [{"text": "💬 CONTACT ADMIN", "url": "https://t.me/foxadm25"}],
            [{"text": "🏠 HOME", "callback_data": "NAV:HOME"}]
          ],
          "prices": { "ML": "ML Prices", "PUBG": "PUBG UC", "CODE": "PUBG CODE" }
        };
        document.getElementById('jsonEditor').value = JSON.stringify(def, null, 2);
        parseJSONtoUI();
    }
    </script>
  <?php endif; ?>

  <?php if($view==="api_keys"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>
    <div class="card">
        <h3><span class='e'>🔑</span> External API Keys</h3>
        <div class="mini">Manage your external service keys here.</div>
    </div>

    <div class="card">
        <form method="post">
            <h4><span class='e'>🔑</span> Telegram Bot Token</h4>
            <div class="mini" style="margin-bottom:10px">The token for your Telegram bot (from @BotFather).</div>
            <textarea id="bot_token_input" name="new_token" placeholder="123456:ABC-DEF..." required style="width:100%; height:80px; padding:10px; border:2px solid var(--border); border-radius:10px; resize:vertical; font-family:monospace"><?=h(BOT_TOKEN)?></textarea>
            
            <div style="display:flex; flex-wrap:wrap; gap:10px; margin-top:5px; margin-bottom:15px; align-items:center">
                <div style="display:flex; gap:5px">
                     <button type="button" onclick="document.getElementById('bot_token_input').value=''" 
                            style="background:#E57373; color:white; border:none; border-radius:8px; padding:5px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; font-size:12px">
                        <span><span class='e'>🗑</span> CLEAR</span>
                    </button>
                    <button type="button" onclick="navigator.clipboard.writeText(document.getElementById('bot_token_input').value).then(()=>alert('Copied!'))" 
                            style="background:#64B5F6; color:white; border:none; border-radius:8px; padding:5px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; font-size:12px">
                        <span><span class='e'>📋</span> COPY</span>
                    </button>
                    <button type="button" onclick="navigator.clipboard.readText().then(t => document.getElementById('bot_token_input').value = t)" 
                            style="background:#FFB74D; color:white; border:none; border-radius:8px; padding:5px 15px; font-weight:600; cursor:pointer; display:flex; align-items:center; gap:5px; font-size:12px">
                        <span><span class='e'>📥</span> PASTE</span>
                    </button>
                </div>
                
                <button name="save_token" class="btn" style="width:auto; margin:0; margin-left:auto; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; padding: 10px 25px; font-weight: bold; border-radius: 30px; box-shadow: 0 4px 15px rgba(118, 75, 162, 0.4); display: flex; align-items: center; gap: 8px; transition: all 0.3s ease;">
                    <span class='e'>🤖</span> 
                    <span>UPDATE BOT TOKEN</span>
                </button>
            </div>
        </form>

        <hr style="border:0; border-top:2px dashed #eee; margin:20px 0">

        <form method="post">
            <h4>PUBG API Key</h4>
            <div class="mini" style="margin-bottom:10px">Used for fetching balance and placing orders.</div>
            <?php 
                $sai_data = jr(SAI_KEY_FILE);
                $cur_sai = $sai_data['key'] ?? "5d270c847f8d7c4538a0bcb875dc83f0";
            ?>
            <textarea id="sai_key_input" name="sai_api_key" placeholder="Enter PUBG API Key" required style="width:100%; height:80px; padding:10px; border:2px solid var(--border); border-radius:10px; resize:vertical; font-family:monospace"><?=h($cur_sai)?></textarea>
            
            <div style="display:flex; gap:10px; margin-top:5px; margin-bottom:15px">
                <button type="button" class="btn-sm" onclick="cleanInput('sai_key_input')" style="background:#00BCD4; border:none; color:white; padding:5px 10px; border-radius:5px; cursor:pointer">✨ Clean</button>
                <button type="button" class="btn-sm" onclick="copyInput('sai_key_input')" style="background:#607D8B; border:none; color:white; padding:5px 10px; border-radius:5px; cursor:pointer">📋 Copy</button>
                <button type="button" class="btn-sm" onclick="pasteInput('sai_key_input')" style="background:#FF9800; border:none; color:white; padding:5px 10px; border-radius:5px; cursor:pointer">📋 Paste</button>
            </div>

            <script>
            function cleanInput(id){
                let el = document.getElementById(id);
                if(!el) return;
                el.value = el.value.trim();
            }
            function copyInput(id){
                let el = document.getElementById(id);
                if(!el) return;
                el.select();
                navigator.clipboard.writeText(el.value);
            }
            async function pasteInput(id){
                try{
                    let txt = await navigator.clipboard.readText();
                    let el = document.getElementById(id);
                    if(el) el.value = txt.trim();
                }catch(e){
                    alert('Paste permission denied or not supported.');
                }
            }
            </script>
            
            <div style="margin-top:20px">
                <button class="btn" name="save_api_keys"><span class='e'>💾</span> SAVE KEYS</button>
            </div>
        </form>
    </div>
  <?php endif; ?>

  <?php if($view==="topup_codes"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>

    <?php
    $codeFile = __DIR__."/data/topup_codes.json";
    if(!file_exists($codeFile)) write_text_atomic($codeFile, json_encode([], JSON_PRETTY_PRINT));
    
    // Handle Generation
    if(isset($_POST['gen_codes'])){
        $amt = (int)$_POST['amount'];
        $qty = (int)$_POST['quantity'];
        if($amt > 0 && $qty > 0){
            $data = jr($codeFile);
            if(!$data) $data = [];
            
            $newCodes = [];
            for($i=0; $i<$qty; $i++){
                $code = "TC-".strtoupper(substr(md5(uniqid(mt_rand(), true)), 0, 10));
                $data[$code] = ["amount"=>$amt, "date"=>date("Y-m-d H:i")];
                $newCodes[] = $code;
            }
            jw($codeFile, $data);
            echo "<div class='alert success'>Successfully generated $qty codes for ".number_format($amt)." MMK!</div>";
        }
    }

    // Handle Delete
    if(isset($_POST['del_code'])){
        $c = $_POST['del_code'];
        $data = jr($codeFile);
        if(isset($data[$c])){
            unset($data[$c]);
            jw($codeFile, $data);
            echo "<div class='alert success'>Code deleted!</div>";
        }
    }
    
    // Handle Delete All
    if(isset($_POST['del_all'])){
        jw($codeFile, []);
        echo "<div class='alert success'>All codes deleted!</div>";
    }

    $allCodes = jr($codeFile) ?: [];
    ?>

    <div class="card">
        <h3><span class='e'>🎫</span> Generate Topup Codes</h3>
        <div class="mini">Create one-time use codes for users to top up their wallet.</div>
        
        <form method="post" style="margin-top:20px; display:flex; gap:15px; flex-wrap:wrap; align-items:end">
            <div style="flex:1; min-width:200px">
                <label style="display:block; margin-bottom:5px; font-weight:bold; color:var(--p)">Amount (MMK)</label>
                <input type="number" name="amount" placeholder="e.g. 1000" min="1" required style="width:100%; padding:10px; border-radius:8px; border:1px solid var(--border); background:#1e1e1e; color:white">
            </div>
            <div style="flex:1; min-width:200px">
                <label style="display:block; margin-bottom:5px; font-weight:bold; color:var(--p)">Quantity</label>
                <input type="number" name="quantity" value="1" min="1" max="100" required style="width:100%; padding:10px; border-radius:8px; border:1px solid var(--border); background:#1e1e1e; color:white">
            </div>
            <button type="submit" name="gen_codes" class="btn" style="width:auto; height:42px; display:flex; align-items:center; gap:5px">
                <span class='e'>✨</span> Generate
            </button>
        </form>
    </div>

    <div class="card">
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px">
            <div>
                <h3><span class='e'>📋</span> Active Codes (<?=count($allCodes)?>)</h3>
                <div class="mini">Send these codes to users.</div>
            </div>
            <?php if(count($allCodes)>0): ?>
            <button onclick="openDeleteConfirm('all')" class="btn-sm red" style="padding:8px 15px; border:none; cursor:pointer">🗑 Delete All</button>
            <?php endif; ?>
        </div>

        <div style="max-height:600px; overflow-y:auto">
            <table style="width:100%; border-collapse:collapse; font-size:13px">
                <thead style="background:rgba(255,255,255,0.05); text-align:left; position:sticky; top:0">
                    <tr>
                        <th style="padding:10px; border-bottom:1px solid var(--border)">Code</th>
                        <th style="padding:10px; border-bottom:1px solid var(--border)">Amount</th>
                        <th style="padding:10px; border-bottom:1px solid var(--border)">Created</th>
                        <th style="padding:10px; border-bottom:1px solid var(--border); text-align:right">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($allCodes)): ?>
                        <tr><td colspan="4" style="padding:20px; text-align:center; color:#666">No active codes found.</td></tr>
                    <?php else: ?>
                        <?php foreach($allCodes as $code => $info): ?>
                        <tr style="border-bottom:1px solid var(--border)">
                            <td style="padding:10px; font-family:monospace; font-size:14px; color:var(--p)">
                                <?=h($code)?>
                                <span onclick="copyCode('<?=h($code)?>', this)" style="cursor:pointer; margin-left:8px; padding:4px 10px; border-radius:12px; border:1px solid var(--border); background:rgba(255,255,255,0.06); color:var(--text); font-weight:600; font-size:12px; box-shadow:0 2px 6px rgba(0,0,0,0.15); transition:all .2s">📋 Copy</span>
                            </td>
                            <td style="padding:10px; font-weight:bold; color:#4CAF50"><?=number_format($info['amount'])?> MMK</td>
                            <td style="padding:10px; color:#aaa"><?=h($info['date'])?></td>
                            <td style="padding:10px; text-align:right">
                                <button onclick="openDeleteConfirm('single', '<?=h($code)?>')" class="btn-sm red" style="padding:5px 10px; border:none; cursor:pointer">🗑</button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <form method="post" id="deleteForm" style="display:none">
      <input type="hidden" name="del_all" id="del_all_input">
      <input type="hidden" name="del_code" id="del_code_input">
    </form>

    <div id="deleteConfirmOverlay" style="position:fixed; inset:0; background:rgba(0,0,0,0.6); backdrop-filter:blur(5px); display:none; align-items:center; justify-content:center; z-index:9999; opacity:0; transition:opacity 0.3s ease" onclick="if(event.target===this) closeDeleteConfirm()">
        <div style="width:90%; max-width:380px; background:var(--panel); border:1px solid var(--border); border-radius:24px; box-shadow: 0 10px 40px rgba(0,0,0,0.5); overflow:hidden; transform:scale(0.9); transition:transform 0.3s cubic-bezier(0.34, 1.56, 0.64, 1)">
            <div style="padding:30px 20px; text-align:center">
                <div id="delIcon" style="font-size:50px; margin-bottom:15px; filter:drop-shadow(0 4px 10px rgba(0,0,0,0.2))">🗑</div>
                <h2 id="delTitle" style="margin:0 0 10px 0; font-size:22px; color:var(--text)"></h2>
                <p id="delMsg" style="color:#CCC; margin:0; line-height:1.6; font-size:15px"></p>
            </div>
            <div style="display:flex; gap:12px; padding:20px; background:rgba(0,0,0,0.2); border-top:1px solid var(--border)">
                <button type="button" onclick="closeDeleteConfirm()" style="flex:1; padding:14px; border-radius:14px; background:transparent; border:1px solid var(--border); color:var(--text); cursor:pointer; font-weight:bold; font-family:inherit; transition:all 0.2s">Cancel</button>
                <button type="button" id="delConfirmBtn" onclick="document.getElementById('deleteForm').submit()" style="flex:1; padding:14px; border-radius:14px; border:none; cursor:pointer; font-weight:bold; font-family:inherit; color:white; background:linear-gradient(45deg, #F44336, #E57373); box-shadow:0 4px 15px rgba(244, 67, 54, 0.4); transition:all 0.2s">Delete</button>
            </div>
        </div>
    </div>

    <script>
    function openDeleteConfirm(type, code = ''){
        const form = document.getElementById('deleteForm');
        const allInput = document.getElementById('del_all_input');
        const codeInput = document.getElementById('del_code_input');
        
        const title = document.getElementById('delTitle');
        const msg = document.getElementById('delMsg');
        const overlay = document.getElementById('deleteConfirmOverlay');
        const modal = overlay.querySelector('div');

        if(type === 'all'){
            allInput.disabled = false;
            allInput.value = '1';
            codeInput.disabled = true;
            title.innerText = 'Delete All Codes?';
            msg.innerHTML = 'Are you sure you want to delete <b>ALL</b> active codes?<br><span style="font-size:13px; color:#FF5252">This action cannot be undone.</span>';
        } else {
            allInput.disabled = true;
            codeInput.disabled = false;
            codeInput.value = code;
            title.innerText = 'Delete Code?';
            msg.innerHTML = `Are you sure you want to delete code:<br><b style="color:var(--p); font-family:monospace; font-size:16px">${code}</b>?`;
        }

        overlay.style.display = 'flex';
        setTimeout(() => {
            overlay.style.opacity = '1';
            modal.style.transform = 'scale(1)';
        }, 10);
    }

    function closeDeleteConfirm(){
        const overlay = document.getElementById('deleteConfirmOverlay');
        const modal = overlay.querySelector('div');
        overlay.style.opacity = '0';
        modal.style.transform = 'scale(0.9)';
        setTimeout(() => {
            overlay.style.display = 'none';
        }, 300);
    }
    </script>
  <?php endif; ?>

  <?php if($view==="settings"): ?>
    <div class="card">
      <h3><span class='e'>⚙️</span> Settings</h3>
      
      <!-- Change Password -->
      <form method="post" style="max-width:400px; margin:0 auto;">
        <h4><span class='e'>🔐</span> Change Admin Password</h4>
        <div class="mini" style="margin-bottom:15px">Current password is stored in password.json</div>
        
        <input type="password" name="old_pass" placeholder="Old Password" required>
        <input type="password" name="new_pass" placeholder="New Password" required>
        
        <button class="btn" name="change_pass" style="margin-top:10px; background:var(--p-dim)">UPDATE PASSWORD</button>
      </form>
      
      <div style="border-top:2px dashed var(--border); margin:30px 0;"></div>

      <!-- Support Admins -->
      <div style="max-width:500px; margin:0 auto;">
        <h4><span class='e'>🛡️</span> Support Admins</h4>
        <div class="mini" style="margin-bottom:20px">These Telegram IDs will receive support messages from users.</div>
        
        <?php 
          $s_admins = jr(SUPPORT_ADMINS_FILE); 
          if(empty($s_admins)): ?>
              <div style="padding:20px; text-align:center; border:2px dashed var(--border); border-radius:15px; color:#888;">
                  <span style="font-size:30px; display:block; margin-bottom:10px">📭</span>
                  No support admins configured.
              </div>
          <?php else: ?>
              <div style="display:grid; gap:10px;">
              <?php foreach($s_admins as $sid): ?>
                  <form method="post" style="display:flex; align-items:center; background:var(--panel); padding:15px; border-radius:15px; border:1px solid var(--border); transition:0.3s; box-shadow:var(--shadow)">
                      <div style="width:40px; height:40px; background:var(--p); border-radius:50%; display:flex; align-items:center; justify-content:center; font-size:20px; color:white; margin-right:15px; box-shadow:0 2px 5px rgba(0,0,0,0.2)">
                          👤
                      </div>
                      <div style="flex:1">
                          <div style="font-size:12px; color:#888; margin-bottom:2px">Admin ID</div>
                          <div style="font-weight:bold; font-family:monospace; font-size:16px; color:var(--text)"><?= $sid ?></div>
                      </div>
                      <input type="hidden" name="del_support_admin" value="<?= $sid ?>">
                      <button class="btn-sm" style="background:transparent; color:#FF5252; border:1px solid #FF5252; width:35px; height:35px; padding:0; display:flex; align-items:center; justify-content:center; border-radius:10px" title="Remove Admin">
                          <span class="e" style="margin:0">🗑</span>
                      </button>
                  </form>
              <?php endforeach; ?>
              </div>
          <?php endif; ?>
        
        <form method="post" style="margin-top:20px; background:var(--panel); padding:20px; border-radius:20px; border:1px solid var(--border)">
            <label style="display:block; margin-bottom:10px; font-weight:bold; color:var(--p)">Add New Admin</label>
            <div style="display:flex; gap:10px">
                <input type="number" name="new_admin_id" placeholder="Enter Telegram ID" required style="margin:0; flex:1; background:var(--bg); border:1px solid var(--border); color:var(--text)">
                <button class="btn" name="add_support_admin" style="width:auto; padding:0 25px; border-radius:12px"><span class='e'>➕</span> ADD</button>
            </div>
        </form>
      </div>

      <div style="border-top:2px dashed var(--border); margin:30px 0;"></div>
    </div>
  <?php endif; ?>

  <?php if($view==="bot_menu"): ?>
    <div class="card" style="margin-bottom:15px; background:transparent; border:none; padding:0">
        <a href="?view=admin_manager" class="btn-back">
            <span class="e">⬅</span> Back to Admin Manager
        </a>
    </div>

    <?php
    if(isset($_POST['save_menu'])){
        $json = $_POST['menu_json'] ?? '';
        $decoded = json_decode($json, true);
        if($decoded && isset($decoded['inline_keyboard'])){
            jw(MENU_FILE, $decoded);
            echo "<div class='card ok'>Menu updated successfully! ✅</div>";
        } else {
            echo "<div class='card bad'>Invalid JSON or missing 'inline_keyboard' key! ❌</div>";
        }
    }
    
    $currentMenu = file_exists(MENU_FILE) ? file_get_contents(MENU_FILE) : "{}";
    // Beautify JSON for display
    $currentMenu = json_encode(json_decode($currentMenu), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    ?>

    <div class="card">
        <h3><span class='e'>🤖</span> Bot Menu Editor</h3>
        <div class="mini">
            Configure your bot's main menu buttons. This uses standard Telegram <code>InlineKeyboardMarkup</code> JSON format.<br>
            You can use tools like <b>Button Studio</b> or any JSON editor to generate this structure.
        </div>
        
        <form method="post" style="margin-top:20px">
            <div style="margin-bottom:10px; display:flex; justify-content:space-between; align-items:center">
                <label style="font-weight:bold; color:var(--p)">Menu JSON</label>
                <a href="https://core.telegram.org/bots/api#inlinekeyboardmarkup" target="_blank" class="mini" style="color:var(--p)">📚 Telegram Docs</a>
            </div>
            
            <textarea name="menu_json" style="width:100%; height:400px; font-family:'Consolas',monospace; font-size:14px; line-height:1.5; background:#1E1E1E; color:#A7FFEB; border:1px solid var(--border)" spellcheck="false"><?= h($currentMenu) ?></textarea>
            
            <div style="margin-top:15px">
                <button class="btn" name="save_menu"><span class='e'>💾</span> Save Menu</button>
            </div>
        </form>
    </div>
  <?php endif; ?>

  <?php if($view==="admin_editor"): ?>
    <div class="card">
        <h3><span class='e'>🛠</span> Admin Editor (Pure PHP)</h3>
        <div class="mini">
            <b>Warning:</b> Editing this file (admin.php) can break the dashboard.<br>
            A backup is automatically created in <code>/BackupAdm</code> before saving.<br>
            Use with caution!
        </div>
    </div>

    <div class="card">
        <form method="post">
            <div style="display:flex;justify-content:space-between;margin-bottom:10px">
                 <span style="font-weight:bold;color:var(--p-dim)">admin.php Source Code</span>
                 <a href="admin.php" target="_blank" class="btn-sm" style="background:#8BC34A;text-decoration:none">👁 View Live</a>
            </div>
            <textarea name="admin_text" style="width:100%; height:600px; font-family:'Consolas',monospace; font-size:13px; padding:10px; border:2px solid var(--border); border-radius:10px; background:#1E1E1E; color:var(--text); outline:none; resize:vertical" spellcheck="false"><?= h(file_get_contents(ADMIN_FILE)) ?></textarea>
            
            <div style="margin-top:15px; display:flex; gap:10px; align-items:center">
                <button class="btn" name="save_admin" style="width:auto; padding:10px 25px" onclick="return confirm('Are you sure you want to overwrite admin.php? If you break it, you will need to restore manually via FTP/File Manager.')"><span class='e'>💾</span> SAVE & BACKUP</button>
            </div>
        </form>
    </div>
  <?php endif; ?>

  <?php if($view==="theme"): ?>
    <div class="card">
        <h3><span class='e'>🎨</span> Theme Manager</h3>
        <div class="mini">Choose a preset or customize your own colors.</div>

        <style>
            .theme-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(140px, 1fr)); gap: 15px; margin: 20px 0; }
            .theme-card {
                border-radius: 15px; cursor: pointer; overflow: hidden; position: relative;
                border: 2px solid transparent; transition: 0.3s;
                box-shadow: 0 4px 10px rgba(0,0,0,0.2);
            }
            .theme-card:hover { transform: translateY(-5px); box-shadow: 0 8px 20px rgba(0,0,0,0.3); }
            .theme-preview { height: 80px; display: flex; align-items: center; justify-content: center; font-size: 24px; }
            .theme-name { padding: 10px; text-align: center; font-weight: bold; font-size: 13px; background: rgba(0,0,0,0.2); color: white; }
        </style>

        <div class="theme-grid">
            <!-- Midnight Blue -->
            <div class="theme-card" onclick="setTheme('MidnightBlue')" style="background:#0D1117; border-color:#29B6F6">
                <div class="theme-preview" style="color:#29B6F6">🌊</div>
                <div class="theme-name">Midnight Blue</div>
            </div>
            <!-- Cyberpunk -->
            <div class="theme-card" onclick="setTheme('Cyberpunk')" style="background:#000000; border-color:#F50057">
                <div class="theme-preview" style="color:#00E5FF; text-shadow:0 0 5px #F50057">👾</div>
                <div class="theme-name">Cyberpunk</div>
            </div>
            <!-- Forest -->
            <div class="theme-card" onclick="setTheme('Forest')" style="background:#051C05; border-color:#00E676">
                <div class="theme-preview" style="color:#00E676">🌲</div>
                <div class="theme-name">Deep Forest</div>
            </div>
            <!-- Sunset -->
            <div class="theme-card" onclick="setTheme('Sunset')" style="background:#1A1A1A; border-color:#FF9800">
                <div class="theme-preview" style="color:#FF9800">🌅</div>
                <div class="theme-name">Sunset</div>
            </div>
            <!-- Royal -->
            <div class="theme-card" onclick="setTheme('Royal')" style="background:#12002E; border-color:#D500F9">
                <div class="theme-preview" style="color:#D500F9">👑</div>
                <div class="theme-name">Royal Purple</div>
            </div>
             <!-- SeaBlue -->
            <div class="theme-card" onclick="setTheme('SeaBlue')" style="background:#121212; border-color:#00BCD4">
                <div class="theme-preview" style="color:#00BCD4">🐬</div>
                <div class="theme-name">Sea Blue</div>
            </div>
            <!-- Dark Pink -->
            <div class="theme-card" onclick="setTheme('DarkPink')" style="background:#121212; border-color:#E91E63">
                <div class="theme-preview" style="color:#E91E63">🎀</div>
                <div class="theme-name">Dark Pink</div>
            </div>
             <!-- Light Pink -->
            <div class="theme-card" onclick="setTheme('LightPink')" style="background:#FCE4EC; border-color:#E91E63">
                <div class="theme-preview" style="color:#E91E63">🌸</div>
                <div class="theme-name" style="color:#880E4F; background:rgba(255,255,255,0.5)">Light Pink</div>
            </div>
        </div>

        <form method="post">
            <h4 style="margin-bottom:15px; color:var(--p)">Custom Colors</h4>
            <div class="row">
                <div style="flex:1">
                    <label>Primary Color</label>
                    <div style="display:flex; gap:10px">
                        <input type="color" name="p" value="<?= h($theme['p']) ?>" style="height:50px; padding:5px; width:50px; border-radius:10px; cursor:pointer">
                        <input type="text" name="p" value="<?= h($theme['p']) ?>" id="p_text" style="flex:1">
                    </div>
                </div>
                <div style="flex:1">
                    <label>Dim Color (Hover)</label>
                    <div style="display:flex; gap:10px">
                        <input type="color" name="p_dim" value="<?= h($theme['p_dim']) ?>" style="height:50px; padding:5px; width:50px; border-radius:10px; cursor:pointer">
                        <input type="text" name="p_dim" value="<?= h($theme['p_dim']) ?>" id="p_dim_text" style="flex:1">
                    </div>
                </div>
            </div>

            <div class="row">
                <div style="flex:1">
                    <label>Background Color</label>
                    <div style="display:flex; gap:10px">
                        <input type="color" name="bg" value="<?= h($theme['bg']) ?>" style="height:50px; padding:5px; width:50px; border-radius:10px; cursor:pointer">
                        <input type="text" name="bg" value="<?= h($theme['bg']) ?>" id="bg_text" style="flex:1">
                    </div>
                </div>
                <div style="flex:1">
                    <label>Panel Color</label>
                    <div style="display:flex; gap:10px">
                        <input type="color" name="panel" value="<?= h($theme['panel']) ?>" style="height:50px; padding:5px; width:50px; border-radius:10px; cursor:pointer">
                        <input type="text" name="panel" value="<?= h($theme['panel']) ?>" id="panel_text" style="flex:1">
                    </div>
                </div>
            </div>

            <div class="row">
                <div style="flex:1">
                    <label>Text Color</label>
                    <div style="display:flex; gap:10px">
                        <input type="color" name="text" value="<?= h($theme['text']) ?>" style="height:50px; padding:5px; width:50px; border-radius:10px; cursor:pointer">
                        <input type="text" name="text" value="<?= h($theme['text']) ?>" id="text_text" style="flex:1">
                    </div>
                </div>
                <div style="flex:1">
                    <label>Border Color</label>
                    <div style="display:flex; gap:10px">
                        <input type="color" name="border" value="<?= h($theme['border']) ?>" style="height:50px; padding:5px; width:50px; border-radius:10px; cursor:pointer">
                        <input type="text" name="border" value="<?= h($theme['border']) ?>" id="border_text" style="flex:1">
                    </div>
                </div>
            </div>

            <h4 style="margin-top:20px; color:var(--p)">Quick Palette</h4>
            <div id="palette" style="display:grid; grid-template-columns:repeat(auto-fill, minmax(30px, 1fr)); gap:8px; margin-bottom:20px">
                <!-- JS will fill this -->
            </div>

            <button class="btn" name="save_theme" style="padding:15px; font-size:18px"><span class='e'>💾</span> APPLY THEME</button>
        </form>
    </div>

    <script>
        function setTheme(name) {
            const themes = {
                'MidnightBlue': { p: '#29B6F6', p_dim: '#0277BD', bg: '#0D1117', panel: '#161B22', text: '#C9D1D9', border: '#30363D' },
                'Cyberpunk': { p: '#F50057', p_dim: '#C51162', bg: '#000000', panel: '#121212', text: '#00E5FF', border: '#333333' },
                'Forest': { p: '#00E676', p_dim: '#00C853', bg: '#051C05', panel: '#0A2E0A', text: '#E8F5E9', border: '#1B5E20' },
                'Sunset': { p: '#FF9800', p_dim: '#F57C00', bg: '#1A1A1A', panel: '#2D2D2D', text: '#FFE0B2', border: '#424242' },
                'Royal': { p: '#D500F9', p_dim: '#AA00FF', bg: '#12002E', panel: '#240046', text: '#E1BEE7', border: '#4A148C' },
                'SeaBlue': { p: '#00BCD4', p_dim: '#0097A7', bg: '#121212', panel: '#1E1E1E', text: '#E0F7FA', border: '#333333' },
                'DarkPink': { p: '#E91E63', p_dim: '#C2185B', bg: '#121212', panel: '#1E1E1E', text: '#F8BBD0', border: '#333333' },
                'LightPink': { p: '#E91E63', p_dim: '#C2185B', bg: '#FCE4EC', panel: '#FFFFFF', text: '#880E4F', border: '#F8BBD0' }
            };
            const t = themes[name];
            if(t) {
                updateInputs('p', t.p);
                updateInputs('p_dim', t.p_dim);
                updateInputs('bg', t.bg);
                updateInputs('panel', t.panel);
                updateInputs('text', t.text);
                updateInputs('border', t.border);
            }
        }

        function updateInputs(name, val) {
            const colorInput = document.querySelector(`input[type=color][name=${name}]`);
            const textInput = document.querySelector(`input[type=text][name=${name}]`); // Fixed selector
            if(colorInput) colorInput.value = val;
            if(textInput) textInput.value = val;
        }

        // Sync inputs
        ['p', 'p_dim', 'bg', 'panel', 'text', 'border'].forEach(name => {
            const c = document.querySelector(`input[type=color][name=${name}]`);
            const t = document.querySelector(`input[type=text][name=${name}]`); // Fixed selector
            
            if(c && t) {
                c.addEventListener('input', (e) => t.value = e.target.value);
                t.addEventListener('input', (e) => c.value = e.target.value);
            }
        });

        // Generate 50 Colors
        const colors = [
            '#F44336', '#E91E63', '#9C27B0', '#673AB7', '#3F51B5', '#2196F3', '#03A9F4', '#00BCD4', '#009688', '#4CAF50',
            '#8BC34A', '#CDDC39', '#FFEB3B', '#FFC107', '#FF9800', '#FF5722', '#795548', '#9E9E9E', '#607D8B', '#000000',
            '#FFCDD2', '#F8BBD0', '#E1BEE7', '#D1C4E9', '#C5CAE9', '#BBDEFB', '#B3E5FC', '#B2EBF2', '#B2DFDB', '#C8E6C9',
            '#DCEDC8', '#F0F4C3', '#FFF9C4', '#FFECB3', '#FFE0B2', '#FFCCBC', '#D7CCC8', '#F5F5F5', '#CFD8DC', '#FFFFFF',
            '#D32F2F', '#C2185B', '#7B1FA2', '#512DA8', '#303F9F', '#1976D2', '#0288D1', '#0097A7', '#00796B', '#388E3C'
        ];
        
        const pal = document.getElementById('palette');
        if(pal){
            colors.forEach(c => {
                const d = document.createElement('div');
                d.style.backgroundColor = c;
                d.style.height = '30px';
                d.style.borderRadius = '5px';
                d.style.cursor = 'pointer';
                d.style.border = '1px solid #555';
                d.onclick = () => {
                    updateInputs('p', c);
                    // Auto calculate dim (simple darken)
                    updateInputs('p_dim', c); // User can adjust manually
                };
                pal.appendChild(d);
            });
        }
    </script>
  <?php endif; ?>

</div>

<!-- Ban Confirmation Modal -->
<form method="post" id="banForm" style="display:none">
  <input type="hidden" name="cid" id="ban_cid_input">
  <input type="hidden" name="toggle_ban" value="1">
</form>

<div id="banConfirmOverlay" style="position:fixed; inset:0; background:rgba(0,0,0,0.6); backdrop-filter:blur(5px); display:none; align-items:center; justify-content:center; z-index:9999; opacity:0; transition:opacity 0.3s ease" onclick="if(event.target===this) closeBanConfirm()">
    <div style="width:90%; max-width:380px; background:var(--panel); border:1px solid var(--border); border-radius:24px; box-shadow: 0 10px 40px rgba(0,0,0,0.5); overflow:hidden; transform:scale(0.9); transition:transform 0.3s cubic-bezier(0.34, 1.56, 0.64, 1)">
        <div style="padding:30px 20px; text-align:center">
            <div id="banIcon" style="font-size:50px; margin-bottom:15px; filter:drop-shadow(0 4px 10px rgba(0,0,0,0.2))"></div>
            <h2 id="banTitle" style="margin:0 0 10px 0; font-size:22px; color:var(--text)"></h2>
            <p id="banMsg" style="color:#CCC; margin:0; line-height:1.6; font-size:15px"></p>
        </div>
        <div style="display:flex; gap:12px; padding:20px; background:rgba(0,0,0,0.2); border-top:1px solid var(--border)">
            <button onclick="closeBanConfirm()" style="flex:1; padding:14px; border-radius:14px; background:transparent; border:1px solid var(--border); color:var(--text); cursor:pointer; font-weight:bold; font-family:inherit; transition:all 0.2s">Cancel</button>
            <button id="banConfirmBtn" onclick="document.getElementById('banForm').submit()" style="flex:1; padding:14px; border-radius:14px; border:none; cursor:pointer; font-weight:bold; font-family:inherit; color:white; box-shadow:0 4px 15px rgba(0,0,0,0.2); transition:all 0.2s"></button>
        </div>
    </div>
</div>

<script>
function openBanConfirm(cid, isBanned){
    document.getElementById('ban_cid_input').value = cid;
    
    let name = cid;
    if(typeof allUsers !== 'undefined' && allUsers[cid]){
        name = allUsers[cid].username ? '@'+allUsers[cid].username : (allUsers[cid].name || cid);
    }
    
    const icon = document.getElementById('banIcon');
    const title = document.getElementById('banTitle');
    const msg = document.getElementById('banMsg');
    const btn = document.getElementById('banConfirmBtn');
    const overlay = document.getElementById('banConfirmOverlay');
    const modal = overlay.querySelector('div');
    
    if(isBanned){
        icon.innerHTML = '✅';
        title.innerText = 'Unban User Account?';
        msg.innerHTML = `You are about to <b>UNBAN</b><br><span style="font-size:18px; color:#4CAF50; font-weight:bold; display:block; margin-top:5px">${name}</span><br><span style="font-size:13px; opacity:0.7">They will regain access to the bot.</span>`;
        btn.innerText = 'Confirm Unban';
        btn.style.background = 'linear-gradient(45deg, #4CAF50, #81C784)';
    } else {
        icon.innerHTML = '⛔';
        title.innerText = 'Ban User Account?';
        msg.innerHTML = `You are about to <b>BAN</b><br><span style="font-size:18px; color:#F44336; font-weight:bold; display:block; margin-top:5px">${name}</span><br><span style="font-size:13px; opacity:0.7">They will be blocked from using the bot.</span>`;
        btn.innerText = 'Confirm Ban';
        btn.style.background = 'linear-gradient(45deg, #F44336, #E57373)';
    }
    
    overlay.style.display = 'flex';
    // Small timeout for animation
    setTimeout(() => {
        overlay.style.opacity = '1';
        modal.style.transform = 'scale(1)';
    }, 10);
    return false;
}
function closeBanConfirm(){
    const overlay = document.getElementById('banConfirmOverlay');
    const modal = overlay.querySelector('div');
    overlay.style.opacity = '0';
    modal.style.transform = 'scale(0.9)';
    setTimeout(() => {
        overlay.style.display = 'none';
    }, 300);
}
</script>

</body>
</html>
