<?php
session_start();
error_reporting(0);
date_default_timezone_set("Asia/Yangon");

$passFile = __DIR__ . "/password.json";
$tokenFile = __DIR__ . "/token.json";
$supportFile = __DIR__ . "/support_admins.json";

// Helper: Telegram Send
function send_tg_msg($cid, $text, $token){
    if(!$token) return false;
    $url = "https://api.telegram.org/bot$token/sendMessage";
    $data = [
        "chat_id" => $cid,
        "text" => $text,
        "parse_mode" => "HTML",
        "disable_web_page_preview" => true
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [CURLOPT_RETURNTRANSFER=>1, CURLOPT_POST=>1, CURLOPT_POSTFIELDS=>$data, CURLOPT_TIMEOUT=>10]);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

// Helper: Telegram Send Photo
function send_tg_photo($cid, $photo_path, $caption, $token){
    if(!$token) return false;
    $url = "https://api.telegram.org/bot$token/sendPhoto";
    
    // Use realpath to ensure curl can find the file on Windows
    $real_path = realpath($photo_path);
    if(!$real_path) $real_path = $photo_path;

    $cfile = new CURLFile($real_path);
    // Let curl auto-detect mime type from the file extension of our temp file
    
    $data = [
        "chat_id" => $cid,
        "photo" => $cfile,
        "caption" => $caption,
        "parse_mode" => "HTML"
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => 1, 
        CURLOPT_POST => 1, 
        CURLOPT_POSTFIELDS => $data, 
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false // Fix for local Windows SSL issues
    ]);
    $res = curl_exec($ch);
    
    // Debug Logging
    if(curl_errno($ch)){
        file_put_contents("debug_photo.log", date("Y-m-d H:i:s") . " Curl Error: " . curl_error($ch) . "\n", FILE_APPEND);
    } else {
        file_put_contents("debug_photo.log", date("Y-m-d H:i:s") . " Response: " . $res . "\n", FILE_APPEND);
    }
    
    curl_close($ch);
    return $res;
}

// Handle Support Message
if (isset($_POST['send_support']) && isset($_SESSION['user_tg_id'])) {
    $msg = trim($_POST['support_msg']);
    $uid = $_SESSION['user_tg_id'];
    
    if(strlen($msg) > 500){
        $support_error = "Message is too long! Max 500 characters.";
    }

    $photo_attached = false;
    $photo_path = null;
    $temp_file_created = false;

    // Handle Photo Upload
    if(isset($_FILES['support_photo'])){
        if($_FILES['support_photo']['error'] === UPLOAD_ERR_OK){
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];
            $ext = strtolower(pathinfo($_FILES['support_photo']['name'], PATHINFO_EXTENSION));
            if(in_array($ext, $allowed)){
                if($_FILES['support_photo']['size'] <= 5 * 1024 * 1024){ // 5MB limit
                    // Move to a temporary file with correct extension
                    $temp_name = 'temp_img_' . time() . '_' . rand(1000,9999) . '.' . $ext;
                    if(move_uploaded_file($_FILES['support_photo']['tmp_name'], $temp_name)){
                        $photo_path = $temp_name;
                        $photo_attached = true;
                        $temp_file_created = true;
                    } else {
                        $support_error = "Failed to save uploaded image!";
                    }
                } else {
                    $support_error = "Image too large (Max 5MB)!";
                }
            } else {
                $support_error = "Invalid image format (JPG, PNG, GIF only)!";
            }
        } elseif($_FILES['support_photo']['error'] !== UPLOAD_ERR_NO_FILE){
            $err_code = $_FILES['support_photo']['error'];
            if($err_code == UPLOAD_ERR_INI_SIZE || $err_code == UPLOAD_ERR_FORM_SIZE){
                $support_error = "Image too large (Server Limit)!";
            } else {
                $support_error = "Upload failed (Error Code: $err_code)";
            }
        }
    }
    
    if (!isset($support_error) && (!empty($msg) || $photo_attached)) {
        // Load Token
        $tk_data = @json_decode(@file_get_contents($tokenFile), true);
        $token = $tk_data['token'] ?? null;
        
        // Load Support Admins
        $admins = @json_decode(@file_get_contents($supportFile), true);
        if (!is_array($admins)) $admins = [];
        
        if ($token && !empty($admins)) {
            $formatted_msg = "📩 <b>New Support Message</b>\n\n";
            $formatted_msg .= "From: User (ID: <code>$uid</code>)\n";
            if(!empty($msg)) $formatted_msg .= "Message:\n$msg";
            else $formatted_msg .= "Message: [Photo Only]";
            
            foreach ($admins as $admin_id) {
                if($photo_attached){
                    send_tg_photo($admin_id, $photo_path, $formatted_msg, $token);
                } else {
                    send_tg_msg($admin_id, $formatted_msg, $token);
                }
            }
            $support_status = "Message sent to support! ✅";
        } else {
            $support_error = "Support system offline (No Token/Admins).";
        }
        
        // Clean up temp file
        if($temp_file_created && file_exists($photo_path)){
            @unlink($photo_path);
        }
        
    } elseif(!isset($support_error)) {
        $support_error = "Message cannot be empty!";
    }
}

// Handle Login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    $inputPass = $_POST['password'];
    
    // Read stored password
    $storedData = @json_decode(@file_get_contents($passFile), true);
    $storedPass = $storedData['password'] ?? 'AutoBot2025';

    if ($inputPass === $storedPass) {
        $_SESSION['admin_auth'] = true;
        header("Location: admin.php");
        exit;
    } else {
        $error = "Incorrect Password!";
    }
}

// Handle User Login (TG ID)
if (isset($_POST['tg_id_login'])) {
    $tg_id = trim($_POST['tg_id_login']);
    if (!empty($tg_id)) {
        $_SESSION['user_tg_id'] = $tg_id;
        header("Location: index.php");
        exit;
    }
}
// Handle User Logout
if (isset($_GET['logout_user'])) {
    unset($_SESSION['user_tg_id']);
    header("Location: index.php");
    exit;
}

// User Data Loading
$user_id = $_SESSION['user_tg_id'] ?? null;
$user_info = [];
$user_history = [];
if ($user_id) {
    // Load User Balance
    $uFile = __DIR__ . "/data/users.json";
    if (file_exists($uFile)) {
        $all_users = json_decode(file_get_contents($uFile), true);
        $user_info = $all_users[$user_id] ?? [];
    }
    // Load History
    $hFile = __DIR__ . "/data/history.json";
    if (file_exists($hFile)) {
        $all_hist = json_decode(file_get_contents($hFile), true);
        $user_history = $all_hist[$user_id] ?? [];
        $user_history = array_reverse($user_history); // Newest first
    }
}

// Read Prices
$prices_ml = [];
$mlFile = __DIR__ . "/prices.json";
if (file_exists($mlFile)) {
    $prices_ml = json_decode(file_get_contents($mlFile), true);
}

// Read PUBG UC Prices
$prices_uc = [];
$ucFile = __DIR__ . "/pubg_prices.json";
if (file_exists($ucFile)) {
    $tmp = json_decode(file_get_contents($ucFile), true);
    if(isset($tmp['pubg_uc'])) $tmp = $tmp['pubg_uc'];
    $prices_uc = is_array($tmp) ? $tmp : [];
}

// Read PUBG CODE Prices
$prices_code = [];
$codeFile = __DIR__ . "/pubg_code_prices.json";
if (file_exists($codeFile)) {
    $tmp = json_decode(file_get_contents($codeFile), true);
    if(isset($tmp['pubg_code'])) $tmp = $tmp['pubg_code'];
    $prices_code = is_array($tmp) ? $tmp : [];
}

// Read TopUp Message
$topup_message = "";
$tmFile = __DIR__ . "/topup_msg.json";
if (file_exists($tmFile)) {
    $tm_data = json_decode(file_get_contents($tmFile), true);
    $topup_message = $tm_data['message'] ?? "";
}

// Read Payment Methods
$payment_methods = [];
$pmFile = __DIR__ . "/payment_methods.json";
if (file_exists($pmFile)) {
    $payment_methods = json_decode(file_get_contents($pmFile), true);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AutoTopUp BOT - Home</title>
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --p: #00BCD4;       /* Primary Cyan */
            --p-dim: #0097A7;   /* Darker Cyan */
            --bg: #F0F4F8;      /* Light Gray-Blue BG */
            --panel: #FFFFFF;   /* White Panel */
            --text: #37474F;    /* Dark Blue-Gray Text */
            --border: #B2EBF2;  /* Light Cyan Border */
            --shadow: 0 4px 20px rgba(0, 188, 212, 0.15);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0; padding: 0;
            font-family: 'Fredoka', sans-serif;
            background: var(--bg);
            color: var(--text);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .container {
            width: 100%;
            max-width: 800px;
            padding: 20px;
            margin-top: 20px;
        }
        .card {
            background: var(--panel);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            border: 1px solid white;
            animation: fadeIn 0.5s ease;
        }
        h1, h2 { margin: 0 0 15px 0; color: var(--p-dim); text-align: center; }
        .logo {
            width: 80px; height: 80px;
            background: var(--p);
            color: white;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 40px;
            margin: 0 auto 15px auto;
            box-shadow: 0 5px 15px rgba(0, 188, 212, 0.4);
        }
        p { line-height: 1.6; text-align: center; color: #607D8B; }

        /* Table */
        table { width: 100%; border-collapse: separate; border-spacing: 0 8px; }
        th { text-align: left; padding: 12px; color: var(--p-dim); border-bottom: 2px dashed var(--border); }
        td { background: #E0F7FA; padding: 12px; font-weight: 500; }
        tr td:first-child { border-top-left-radius: 10px; border-bottom-left-radius: 10px; }
        tr td:last-child { border-top-right-radius: 10px; border-bottom-right-radius: 10px; text-align: right; color: var(--p-dim); font-weight: 700; }
        
        /* Login Form */
        .login-box { max-width: 400px; margin: 0 auto; }
        input {
            width: 100%; padding: 15px;
            border: 2px solid var(--border);
            border-radius: 15px;
            font-family: inherit; font-size: 16px;
            margin-bottom: 15px;
            outline: none; transition: 0.3s;
        }
        input:focus { border-color: var(--p); box-shadow: 0 0 0 4px rgba(0, 188, 212, 0.1); }
        button {
            width: 100%; padding: 15px;
            background: var(--p); color: white;
            border: none; border-radius: 50px;
            font-size: 16px; font-weight: bold;
            cursor: pointer; transition: 0.3s;
            box-shadow: 0 5px 15px rgba(0, 188, 212, 0.3);
        }
        button:hover { background: var(--p-dim); transform: translateY(-2px); }
        .error { color: #E57373; text-align: center; margin-bottom: 10px; font-weight: bold; }

        /* Custom Select */
        .custom-select-container { position: relative; width: 100%; font-family: 'Fredoka', sans-serif; user-select: none; margin-bottom: 20px; }
        .custom-select-trigger { background: white; border: 2px solid var(--border); border-radius: 12px; padding: 12px; display: flex; align-items: center; cursor: pointer; transition: all 0.3s; }
        .custom-select-trigger:hover { border-color: var(--p); box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .custom-select-trigger img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; object-fit: cover; border: 1px solid #eee; }
        .custom-select-trigger span { font-weight: 600; color: #555; flex-grow: 1; font-size: 15px; }
        .custom-select-trigger .arrow { color: #999; font-size: 12px; transition: transform 0.3s; }
        .custom-options { position: absolute; top: 115%; left: 0; right: 0; background: white; border: 2px solid var(--border); border-radius: 12px; box-shadow: 0 8px 24px rgba(0,0,0,0.1); opacity: 0; visibility: hidden; transform: translateY(-10px); transition: all 0.3s; z-index: 100; overflow-y: auto; max-height: 300px; }
        .custom-options.open { opacity: 1; visibility: visible; transform: translateY(0); }
        .custom-option { padding: 12px; display: flex; align-items: center; cursor: pointer; transition: background 0.2s; border-bottom: 1px solid #f9f9f9; }
        .custom-option:last-child { border-bottom: none; }
        .custom-option:hover { background: var(--bg); }
        .custom-option img { width: 28px; height: 28px; margin-right: 12px; border-radius: 50%; border: 1px solid #eee; }
        .custom-option.selected { background: var(--bg); font-weight: bold; color: var(--p-dim); }
        .custom-select-container.active .arrow { transform: rotate(180deg); }

        @keyframes fadeIn { from{opacity:0;transform:translateY(10px)} to{opacity:1;transform:translateY(0)} }

        /* Modal */
        .modal {
            display: none; position: fixed; z-index: 1000; left: 0; top: 0;
            width: 100%; height: 100%; overflow: auto;
            background-color: rgba(0,0,0,0.5);
            animation: fadeIn 0.3s;
        }
        .modal-content {
            background-color: #fefefe; margin: 10% auto; padding: 25px;
            border: 1px solid #888; width: 90%; max-width: 600px;
            border-radius: 20px; box-shadow: 0 5px 20px rgba(0,0,0,0.2);
            position: relative;
        }
        .close {
            color: #aaa; float: right; font-size: 28px; font-weight: bold;
            cursor: pointer; transition: 0.3s;
        }
        .close:hover { color: #000; }
    </style>
</head>
<body>

    <div class="container">
        <!-- Intro Section -->
        <div class="card">
            <div class="logo">🤖</div>
            <h1>AutoTopUp BOT</h1>
            <p>Welcome to our automated top-up service! 🚀<br>
            Fast, secure, and 24/7 instant delivery for all your gaming needs.<br>
            Enjoy the best rates and seamless experience.</p>
        </div>

        <!-- User Dashboard / Login -->
        <?php if ($user_id): ?>
            <div class="card">
                <h2>👤 User Dashboard</h2>
                <p>Welcome, ID: <b><?= htmlspecialchars($user_id) ?></b></p>
                
                <div style="background:#E0F7FA; padding:15px; border-radius:15px; text-align:center; margin-bottom:20px;">
                    <div style="font-size:14px; color:#006064; margin-bottom:5px;">Your Balance</div>
                    <div style="font-size:24px; font-weight:bold; color:#00BCD4;">
                        <?= number_format($user_info['bal'] ?? $user_info['balance_mmk'] ?? 0) ?> Ks
                    </div>
                    <button onclick="toggleTopUp()" style="background:#FF9800; margin-top:15px; width:auto; padding:10px 25px; border-radius:30px; box-shadow:0 4px 10px rgba(255,152,0,0.3)">
                        💰 Top Up Balance
                    </button>
                </div>

                <!-- Top Up Modal -->
                <div id="topupModal" class="modal">
                    <div class="modal-content">
                        <span class="close" onclick="toggleTopUp()">&times;</span>
                        <h2>💰 Top Up Balance</h2>
                        <div style="line-height:1.6; color:#455A64">
                            <?= nl2br($topup_message) ?> 
                        </div>

                        <?php if(!empty($payment_methods)): ?>
                            <h3 style="margin-top:20px; border-bottom:1px dashed #ccc; padding-bottom:10px">💳 Payment Methods</h3>
                            <div style="overflow-x:auto">
                                <table style="font-size:14px; min-width:300px">
                                    <thead><tr><th>Method</th><th>Number</th><th>Name</th><th>Note</th></tr></thead>
                                    <tbody>
                                        <?php foreach($payment_methods as $pm): ?>
                                            <tr>
                                                <td style="font-weight:bold; color:#0097A7"><?= htmlspecialchars($pm['name']??"") ?></td>
                                                <td style="font-family:monospace; font-size:15px; cursor:pointer" onclick="copyText('<?= htmlspecialchars($pm['no']??"") ?>')">
                                                    <?= htmlspecialchars($pm['no']??"") ?> 📋
                                                </td>
                                                <td><?= htmlspecialchars($pm['acc_name']??"") ?></td>
                                                <td style="font-style:italic; color:#888"><?= htmlspecialchars($pm['note']??"") ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <p style="font-size:12px; color:#999; margin-top:5px">* Click on number to copy</p>
                        <?php endif; ?>
                        
                        <div style="text-align:center; margin-top:20px">
                            <button onclick="toggleTopUp()" style="background:#78909C; width:auto; padding:10px 30px">Close</button>
                        </div>
                    </div>
                </div>

                <h3>📜 TopUp History</h3>
                <?php if (!empty($user_history)): ?>
                    <?php
                        // Pagination Logic
                        $limit = 10;
                        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                        if ($page < 1) $page = 1;
                        $total_items = count($user_history);
                        $total_pages = ceil($total_items / $limit);
                        $offset = ($page - 1) * $limit;
                        $paged_history = array_slice($user_history, $offset, $limit);
                    ?>
                    <div style="overflow-x:auto;">
                        <table>
                            <thead>
                                <tr>
                                    <th>Time</th>
                                    <th>SN</th>
                                    <th>Game ID</th>
                                    <th>Item</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($paged_history as $h): ?>
                                    <tr>
                                        <td style="font-size:14px; color:#78909C;"><?= htmlspecialchars($h['time'] ?? '-') ?></td>
                                        <td style="font-size:13px; font-family:monospace; color:#546E7A;"><?= htmlspecialchars($h['sn'] ?? '-') ?></td>
                                        <td style="font-weight:500; color:#37474F"><?= htmlspecialchars($h['uid_show'] ?? '-') ?></td>
                                        <td style="font-weight:bold; color:#37474F"><?= htmlspecialchars($h['order'] ?? '-') ?></td>
                                        <td style="color:#0097A7; font-weight:bold;"><?= number_format($h['amount'] ?? 0) ?> Ks</td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination Controls -->
                    <?php if ($total_pages > 1): ?>
                        <div style="display:flex; justify-content:center; gap:10px; margin-top:15px;">
                            <?php if ($page > 1): ?>
                                <a href="?page=<?= $page - 1 ?>" style="text-decoration:none; padding:8px 15px; background:var(--p); color:white; border-radius:5px; font-weight:bold;">&laquo; Prev</a>
                            <?php else: ?>
                                <span style="padding:8px 15px; background:#ccc; color:white; border-radius:5px; font-weight:bold; cursor:not-allowed;">&laquo; Prev</span>
                            <?php endif; ?>

                            <span style="padding:8px 15px; background:#E0F7FA; color:var(--p-dim); border-radius:5px; font-weight:bold;">
                                Page <?= $page ?> of <?= $total_pages ?>
                            </span>

                            <?php if ($page < $total_pages): ?>
                                <a href="?page=<?= $page + 1 ?>" style="text-decoration:none; padding:8px 15px; background:var(--p); color:white; border-radius:5px; font-weight:bold;">Next &raquo;</a>
                            <?php else: ?>
                                <span style="padding:8px 15px; background:#ccc; color:white; border-radius:5px; font-weight:bold; cursor:not-allowed;">Next &raquo;</span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <p>No transaction history found.</p>
                <?php endif; ?>

                <!-- Support Box -->
                <div style="margin-top:30px; border-top:2px dashed #B2EBF2; padding-top:20px;">
                    <h3>📩 Support Box</h3>
                    <p>Send a message to admin (Report issues / Help)</p>
                    
                    <?php if(isset($support_status)): ?>
                        <div style="background:#E8F5E9; color:#2E7D32; padding:10px; border-radius:10px; margin-bottom:10px; text-align:center; font-weight:bold"><?= $support_status ?></div>
                    <?php endif; ?>
                    <?php if(isset($support_error)): ?>
                        <div style="background:#FFEBEE; color:#C62828; padding:10px; border-radius:10px; margin-bottom:10px; text-align:center; font-weight:bold"><?= $support_error ?></div>
                    <?php endif; ?>

                    <form method="post" enctype="multipart/form-data">
                        <textarea name="support_msg" maxlength="500" rows="4" placeholder="Write your message here (Max 500 chars)..." style="width:100%; padding:15px; border:2px solid #B2EBF2; border-radius:15px; font-family:inherit; resize:vertical; outline:none; transition:0.3s" oninput="document.getElementById('char-count').textContent = this.value.length + '/500'"></textarea>
                        <div id="char-count" style="text-align:right; font-size:12px; color:#00BCD4; margin-top:5px; font-weight:bold">0/500</div>
                        
                        <div style="margin-top:10px; display:flex; align-items:center; gap:10px">
                            <label for="support_photo" style="cursor:pointer; background:#E0F7FA; padding:10px 15px; border-radius:10px; color:#006064; font-size:14px; font-weight:bold; border:1px dashed #00BCD4; display:flex; align-items:center; gap:5px; transition:0.3s">
                                📷 Attach Photo
                                <input type="file" name="support_photo" id="support_photo" accept="image/*" style="display:none" onchange="document.getElementById('file-name').textContent = this.files[0] ? this.files[0].name : ''">
                            </label>
                            <span id="file-name" style="font-size:13px; color:#78909C; max-width:150px; white-space:nowrap; overflow:hidden; text-overflow:ellipsis"></span>
                        </div>

                        <button name="send_support" style="background:#00BCD4; margin-top:15px">📨 Send Message</button>
                    </form>
                </div>

                <a href="?logout_user=1" style="display:block; text-align:center; margin-top:20px; color:#E57373; text-decoration:none; font-weight:bold;">Logout</a>
            </div>
        <?php else: ?>
            <div class="card login-box">
                <h2>👤 User Login</h2>
                <form method="POST">
                    <input type="number" name="tg_id_login" placeholder="Enter Telegram ID to check History" required>
                    <button type="submit" style="background:#FF7043;">Check History</button>
                </form>
            </div>
        <?php endif; ?>

        <!-- Price Table -->
        <div class="card">
            <h2>💎 Price List</h2>
            
            <!-- Custom Select UI -->
            <div class="custom-select-container" id="guestPriceSel">
                <div class="custom-select-trigger" onclick="toggleGuestSelect()">
                    <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64" id="selImg">
                    <span id="selText">ML Prices</span>
                    <div class="arrow">▼</div>
                </div>
                <div class="custom-options" id="guestOptions">
                    <div class="custom-option selected" onclick="selectGuestOption('ml', 'ML Prices', 'https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64')">
                        <img src="https://www.google.com/s2/favicons?domain=mobilelegends.com&sz=64"> ML Prices
                    </div>
                    <div class="custom-option" onclick="selectGuestOption('uc', 'PUBG UC Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                        <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG UC Prices
                    </div>
                    <div class="custom-option" onclick="selectGuestOption('code', 'PUBG CODE Prices', 'https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64')">
                        <img src="https://www.google.com/s2/favicons?domain=pubgmobile.com&sz=64"> PUBG CODE Prices
                    </div>
                </div>
            </div>

            <!-- ML Table -->
            <div id="table_ml" class="price-table">
                <?php if (!empty($prices_ml)): ?>
                    <table>
                        <thead><tr><th>Item Name</th><th>Price (MMK)</th></tr></thead>
                        <tbody>
                            <?php foreach ($prices_ml as $p): ?>
                                <tr>
                                    <td><?= htmlspecialchars($p['name'] ?? 'Unknown') ?></td>
                                    <td><?= number_format($p['price'] ?? 0) ?> Ks</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No prices available.</p>
                <?php endif; ?>
            </div>

            <!-- UC Table -->
            <div id="table_uc" class="price-table" style="display:none">
                <?php if (!empty($prices_uc)): ?>
                    <table>
                        <thead><tr><th>Item Name</th><th>Price (MMK)</th></tr></thead>
                        <tbody>
                            <?php foreach ($prices_uc as $p): ?>
                                <tr>
                                    <td><?= htmlspecialchars($p['name'] ?? 'Unknown') ?></td>
                                    <td><?= number_format($p['price'] ?? 0) ?> Ks</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No prices available.</p>
                <?php endif; ?>
            </div>

            <!-- CODE Table -->
            <div id="table_code" class="price-table" style="display:none">
                <?php if (!empty($prices_code)): ?>
                    <table>
                        <thead><tr><th>Item Name</th><th>Price (MMK)</th></tr></thead>
                        <tbody>
                            <?php foreach ($prices_code as $p): ?>
                                <tr>
                                    <td><?= htmlspecialchars($p['name'] ?? 'Unknown') ?></td>
                                    <td><?= number_format($p['price'] ?? 0) ?> Ks</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No prices available.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Admin Login -->
        <div class="card login-box">
            <h2>Admin Login</h2>
            <?php if (isset($error)): ?>
                <div class="error"><?= $error ?></div>
            <?php endif; ?>
            <form method="POST">
                <input type="password" name="password" placeholder="Enter Admin Password" required>
                <button type="submit">Login to Panel</button>
            </form>
        </div>
    </div>

    <script>
    function toggleGuestSelect() {
        document.getElementById('guestOptions').classList.toggle('open');
        document.getElementById('guestPriceSel').classList.toggle('active');
    }

    function selectGuestOption(val, text, imgUrl) {
        // Update trigger UI
        document.getElementById('selImg').src = imgUrl;
        document.getElementById('selText').innerText = text;

        // Update options styling
        document.querySelectorAll('.custom-option').forEach(opt => opt.classList.remove('selected'));
        event.currentTarget.classList.add('selected');

        toggleGuestSelect();

        // Switch Table
        document.querySelectorAll('.price-table').forEach(t => t.style.display = 'none');
        document.getElementById('table_' + val).style.display = 'block';
    }

    // Close on click outside
    document.addEventListener('click', function(e) {
        if (!e.target.closest('#guestPriceSel')) {
            const opts = document.getElementById('guestOptions');
            const sel = document.getElementById('guestPriceSel');
            if(opts && opts.classList.contains('open')) {
                opts.classList.remove('open');
                sel.classList.remove('active');
            }
        }
    });

    function toggleTopUp() {
        var modal = document.getElementById("topupModal");
        if (modal.style.display === "block") {
            modal.style.display = "none";
        } else {
            modal.style.display = "block";
        }
    }
    
    // Close modal if clicked outside (Global)
    window.onclick = function(event) {
        var modal = document.getElementById("topupModal");
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }

    function copyText(text) {
        navigator.clipboard.writeText(text).then(function() {
            // Create/Show Toast
            var toast = document.getElementById("copy_toast");
            if(!toast){
                toast = document.createElement("div");
                toast.id = "copy_toast";
                toast.style.cssText = "position:fixed; bottom:30px; left:50%; transform:translateX(-50%); background:rgba(0,0,0,0.8); color:white; padding:12px 24px; border-radius:25px; z-index:9999; font-size:14px; box-shadow:0 4px 15px rgba(0,0,0,0.2); transition:opacity 0.3s";
                document.body.appendChild(toast);
            }
            toast.innerText = "Copied: " + text;
            toast.style.opacity = "1";
            toast.style.display = "block";
            
            setTimeout(function(){ 
                toast.style.opacity = "0"; 
                setTimeout(function(){ toast.style.display = "none"; }, 300);
            }, 2000);
        }, function(err) {
            console.error('Async: Could not copy text: ', err);
        });
    }
    </script>
</body>
</html>
